/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItemProvider;
import org.eclipse.osee.ats.api.team.IAtsTeamWorkflowProvider;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.column.AbstractServicesColumn;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class ActionableItemsColumn
extends AbstractServicesColumn {
    public ActionableItemsColumn(IAtsServices services) {
        super(services);
    }

    @Override
    public String getText(IAtsObject atsObject) throws Exception {
        return this.getActionableItemsStr(atsObject);
    }

    public String getActionableItemsStr(IAtsObject atsObject) throws OseeCoreException {
        ArrayList<IAtsActionableItem> ais = new ArrayList<IAtsActionableItem>();
        ais.addAll(ActionableItemsColumn.getActionableItems(atsObject));
        Collections.sort(ais, new Comparator<IAtsActionableItem>(){

            @Override
            public int compare(IAtsActionableItem arg0, IAtsActionableItem arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        if (ais.size() == 1) {
            return ((IAtsActionableItem)ais.iterator().next()).getName();
        }
        StringBuilder sb = new StringBuilder();
        for (IAtsActionableItem ai : ais) {
            sb.append(ai.getName());
            sb.append(", ");
        }
        return sb.toString().replace(", $", "");
    }

    public static Collection<IAtsActionableItem> getActionableItems(IAtsObject atsObject) throws OseeCoreException {
        IAtsTeamWorkflow teamWf;
        HashSet<IAtsActionableItem> ais = new HashSet<IAtsActionableItem>();
        if (atsObject instanceof IAtsTeamWorkflowProvider) {
            for (IAtsTeamWorkflow team : ((IAtsTeamWorkflowProvider)atsObject).getTeamWorkflows()) {
                ais.addAll(ActionableItemsColumn.getActionableItems((IAtsObject)team));
            }
        } else if (atsObject instanceof IAtsActionableItemProvider) {
            ais.addAll(((IAtsActionableItemProvider)atsObject).getActionableItems());
        }
        if (atsObject instanceof IAtsWorkItem && (teamWf = ((IAtsWorkItem)atsObject).getParentTeamWorkflow()) != null && !teamWf.equals(atsObject)) {
            ais.addAll(ActionableItemsColumn.getActionableItems((IAtsObject)teamWf));
        }
        return ais;
    }
}

