/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.ai;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItemService;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IAtsStoreService;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.core.config.ActionableItems;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.core.util.AtsUtilCore;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;

public class ActionableItemManager
implements IAtsActionableItemService {
    private final IAttributeResolver attrResolver;
    private final IAtsStoreService atsStoreService;
    private final IAtsServices services;

    public ActionableItemManager(IAttributeResolver attrResolver, IAtsStoreService atsStoreService, IAtsServices services) {
        this.attrResolver = attrResolver;
        this.atsStoreService = atsStoreService;
        this.services = services;
    }

    public Set<IAtsActionableItem> getActionableItems(IAtsObject atsObject) throws OseeCoreException {
        HashSet<IAtsActionableItem> ais = new HashSet<IAtsActionableItem>();
        if (!this.atsStoreService.isDeleted(atsObject)) {
            for (String guid : this.getActionableItemGuids(atsObject)) {
                IAtsActionableItem aia = (IAtsActionableItem)this.services.getConfigItem(guid);
                if (aia == null) {
                    OseeLog.logf(ActionableItemManager.class, (Level)Level.SEVERE, (String)"Actionable Item Guid [%s] from [%s] doesn't match item in AtsConfigCache", (Object[])new Object[]{guid, atsObject.toStringWithId()});
                    continue;
                }
                ais.add(aia);
            }
        }
        return ais;
    }

    public String getActionableItemsStr(IAtsObject atsObject) throws OseeCoreException {
        return AtsObjects.toString("; ", this.getActionableItems(atsObject));
    }

    public Collection<String> getActionableItemGuids(IAtsObject atsObject) throws OseeCoreException {
        return this.attrResolver.getAttributesToStringList(atsObject, (AttributeTypeId)AtsAttributeTypes.ActionableItem);
    }

    public void addActionableItem(IAtsObject atsObject, IAtsActionableItem aia, IAtsChangeSet changes) throws OseeCoreException {
        String guid = AtsUtilCore.getGuid((IAtsObject)aia);
        if (!this.getActionableItemGuids(atsObject).contains(guid)) {
            changes.addAttribute(atsObject, (AttributeTypeId)AtsAttributeTypes.ActionableItem, (Object)guid);
        }
    }

    public void removeActionableItem(IAtsObject atsObject, IAtsActionableItem aia, IAtsChangeSet changes) throws OseeCoreException {
        String guid = AtsUtilCore.getGuid((IAtsObject)aia);
        changes.deleteAttribute(atsObject, (AttributeTypeId)AtsAttributeTypes.ActionableItem, (Object)guid);
    }

    public Result setActionableItems(IAtsObject atsObject, Collection<IAtsActionableItem> newItems, IAtsChangeSet changes) throws OseeCoreException {
        Set<IAtsActionableItem> existingAias = this.getActionableItems(atsObject);
        for (IAtsActionableItem existingAia : existingAias) {
            if (newItems.contains(existingAia)) continue;
            this.removeActionableItem(atsObject, existingAia, changes);
        }
        for (IAtsActionableItem newItem : newItems) {
            if (existingAias.contains(newItem)) continue;
            this.addActionableItem(atsObject, newItem, changes);
        }
        return Result.TrueResult;
    }

    public boolean hasActionableItems(IAtsObject atsObject) {
        return this.attrResolver.getAttributeCount(atsObject, (AttributeTypeId)AtsAttributeTypes.ActionableItem) > 0;
    }

    public Collection<IAtsTeamDefinition> getCorrespondingTeamDefinitions(IAtsObject atsObject) {
        HashSet<IAtsTeamDefinition> teamDefs = new HashSet<IAtsTeamDefinition>();
        if (this.getActionableItems(atsObject).size() > 0) {
            teamDefs.addAll(ActionableItems.getImpactedTeamDefs(this.getActionableItems(atsObject)));
        }
        return teamDefs;
    }
}

