/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.core.model.impl.AtsConfigObject;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.logger.Log;

public class AgileTeam
extends AtsConfigObject
implements IAgileTeam {
    public AgileTeam(Log logger, IAtsServices services, ArtifactToken artifact) {
        super(logger, services, artifact);
    }

    @Override
    public String getTypeName() {
        return "Agile Team";
    }

    public List<Long> getAtsTeamUuids() {
        ArrayList<Long> uuids = new ArrayList<Long>();
        for (ArtifactId atsTeam : this.services.getRelationResolver().getRelated((ArtifactId)this.artifact, AtsRelationTypes.AgileTeamToAtsTeam_AtsTeam)) {
            uuids.add(new Long(atsTeam.getId()));
        }
        return uuids;
    }

    @Override
    public String getDescription() {
        return (String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.Description, (Object)"");
    }

    public long getBacklogUuid() {
        long backlogUuid = -1L;
        try {
            ArtifactToken backlogArt = this.services.getRelationResolver().getRelatedOrNull((ArtifactId)this.artifact, AtsRelationTypes.AgileTeamToBacklog_Backlog);
            if (backlogArt != null) {
                backlogUuid = backlogArt.getId();
            }
        }
        catch (Exception exception) {}
        return backlogUuid;
    }
}

