/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.IAgileItem;
import org.eclipse.osee.ats.api.agile.IAgileService;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxAgileBacklog;
import org.eclipse.osee.ats.api.agile.JaxAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxAgileItem;
import org.eclipse.osee.ats.api.agile.JaxAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxNewAgileTeam;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.agile.AgileBacklog;
import org.eclipse.osee.ats.core.agile.AgileBacklogWriter;
import org.eclipse.osee.ats.core.agile.AgileFactory;
import org.eclipse.osee.ats.core.agile.AgileFolders;
import org.eclipse.osee.ats.core.agile.AgileItemWriter;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class AgileService
implements IAgileService {
    private final Log logger;
    private final IAtsServices services;

    public AgileService(Log logger, IAtsServices services) {
        this.logger = logger;
        this.services = services;
    }

    public IAgileTeam getAgileTeam(ArtifactId artifact) {
        return AgileFactory.getAgileTeam(this.logger, this.services, artifact);
    }

    public IAgileTeam getAgileTeam(long uuid) {
        IAgileTeam team = null;
        ArtifactToken teamArt = this.services.getArtifact(Long.valueOf(uuid));
        if (teamArt != null) {
            team = this.getAgileTeam((ArtifactId)teamArt);
        }
        return team;
    }

    public IAgileTeam getAgileTeamById(long teamUuid) {
        IAgileTeam team = null;
        ArtifactToken artifact = this.services.getArtifact(Long.valueOf(teamUuid));
        if (artifact != null) {
            team = this.getAgileTeam((ArtifactId)artifact);
        }
        return team;
    }

    public IAgileTeam createAgileTeam(JaxNewAgileTeam newTeam) {
        return AgileFactory.createAgileTeam(this.logger, this.services, newTeam);
    }

    public IAgileTeam updateAgileTeam(JaxAgileTeam team) {
        return AgileFactory.updateAgileTeam(this.logger, this.services, team);
    }

    public void deleteAgileTeam(long uuid) {
        ArtifactToken team = this.services.getArtifact(Long.valueOf(uuid));
        if (!this.services.getStoreService().isOfType((ArtifactId)team, new ArtifactTypeId[]{AtsArtifactTypes.AgileTeam})) {
            throw new OseeArgumentException("UUID %d is not a valid Agile Team", new Object[]{uuid});
        }
        IAtsChangeSet changes = this.services.createChangeSet("Delete Agile Team");
        this.deleteRecurse(this.services.getRelationResolver().getChildren((ArtifactId)team), changes);
        changes.deleteArtifact((ArtifactId)team);
        changes.execute();
    }

    private void deleteRecurse(Collection<ArtifactToken> resultSet, IAtsChangeSet changes) {
        for (ArtifactId artifactId : resultSet) {
            this.deleteRecurse(this.services.getRelationResolver().getChildren(artifactId), changes);
            changes.deleteArtifact(artifactId);
        }
    }

    public Collection<IAgileTeam> getTeams() {
        ArrayList<IAgileTeam> teams = new ArrayList<IAgileTeam>();
        for (ArtifactId teamArt : this.services.getQueryService().createQuery(new IArtifactType[]{AtsArtifactTypes.AgileTeam}).getResultArtifacts()) {
            teams.add(this.getAgileTeam(teamArt));
        }
        return teams;
    }

    public AttributeTypeId getAgileTeamPointsAttributeType(IAgileTeam team) {
        AttributeTypeToken type = AtsAttributeTypes.Points;
        String attrTypeName = (String)this.services.getAttributeResolver().getSoleAttributeValue((IAtsObject)team, (AttributeTypeId)AtsAttributeTypes.PointsAttributeType, null);
        if (Strings.isValid((String)attrTypeName)) {
            type = this.getTypeFromName(attrTypeName);
        }
        return type;
    }

    private AttributeTypeId getTypeFromName(String attrTypeName) {
        AttributeTypeToken type = null;
        for (AttributeTypeToken attrType : this.services.getStoreService().getAttributeTypes()) {
            if (!attrType.getName().equals(attrTypeName)) continue;
            type = attrType;
            break;
        }
        if (type == null) {
            throw new OseeCoreException("Invalid attribute type name provided: %s", new Object[]{attrTypeName});
        }
        return type;
    }

    public IAgileFeatureGroup getAgileFeatureGroup(ArtifactId artifact) {
        return AgileFactory.getAgileFeatureGroup(this.logger, this.services, artifact);
    }

    public void deleteAgileFeatureGroup(long uuid) {
        ArtifactToken featureGroup = this.services.getArtifact(Long.valueOf(uuid));
        if (!this.services.getStoreService().isOfType((ArtifactId)featureGroup, new ArtifactTypeId[]{AtsArtifactTypes.AgileFeatureGroup})) {
            throw new OseeArgumentException("UUID %d is not a valid Agile Feature Group", new Object[]{uuid});
        }
        IAtsChangeSet changes = this.services.createChangeSet("Delete Agile Feature Group");
        changes.deleteArtifact((ArtifactId)featureGroup);
        changes.execute();
    }

    public IAgileFeatureGroup createAgileFeatureGroup(long teamUuid, String name, String guid, Long uuid) {
        return AgileFactory.createAgileFeatureGroup(this.logger, this.services, teamUuid, name, guid, uuid);
    }

    public IAgileFeatureGroup createAgileFeatureGroup(JaxAgileFeatureGroup newFeatureGroup) {
        return AgileFactory.createAgileFeatureGroup(this.logger, this.services, newFeatureGroup);
    }

    public Collection<IAgileFeatureGroup> getAgileFeatureGroups(IAgileTeam team) {
        LinkedList<IAgileFeatureGroup> groups = new LinkedList<IAgileFeatureGroup>();
        ArtifactToken artifact = team.getStoreObject();
        for (ArtifactId groupArt : this.services.getRelationResolver().getRelated((ArtifactId)artifact, AtsRelationTypes.AgileTeamToFeatureGroup_FeatureGroup)) {
            groups.add(this.services.getConfigItemFactory().getAgileFeatureGroup(groupArt));
        }
        return groups;
    }

    public IAgileBacklog getBacklogForTeam(long teamUuid) {
        IAgileBacklog backlog = null;
        ArtifactToken teamArt = this.services.getArtifact(Long.valueOf(teamUuid));
        ArtifactToken backlogArt = this.services.getRelationResolver().getRelatedOrNull((ArtifactId)teamArt, AtsRelationTypes.AgileTeamToBacklog_Backlog);
        if (backlogArt != null) {
            backlog = this.getAgileBacklog((ArtifactId)backlogArt);
        }
        return backlog;
    }

    public IAgileSprint getAgileSprint(ArtifactId artifact) {
        return AgileFactory.getAgileSprint(this.logger, this.services, artifact);
    }

    public IAgileSprint createAgileSprint(long teamUuid, String name, String guid, Long uuid) {
        return AgileFactory.createAgileSprint(this.logger, this.services, teamUuid, name, guid, uuid);
    }

    public Collection<IAgileSprint> getSprintsForTeam(long teamUuid) {
        ArrayList<IAgileSprint> sprints = new ArrayList<IAgileSprint>();
        ArtifactToken team = this.services.getArtifact(Long.valueOf(teamUuid));
        for (ArtifactId sprintArt : this.services.getRelationResolver().getRelated((ArtifactId)team, AtsRelationTypes.AgileTeamToSprint_Sprint)) {
            sprints.add(this.getAgileSprint(sprintArt));
        }
        return sprints;
    }

    public Collection<IAgileSprint> getAgileSprints(IAgileTeam team) {
        LinkedList<IAgileSprint> sprints = new LinkedList<IAgileSprint>();
        ArtifactToken artifact = team.getStoreObject();
        for (ArtifactToken groupArt : this.services.getRelationResolver().getRelated((ArtifactId)artifact, AtsRelationTypes.AgileTeamToSprint_Sprint)) {
            sprints.add(this.services.getWorkItemFactory().getAgileSprint(groupArt));
        }
        return sprints;
    }

    public IAgileBacklog getAgileBacklog(ArtifactId artifact) {
        return AgileFactory.getAgileBacklog(this.logger, this.services, artifact);
    }

    public IAgileBacklog getAgileBacklog(IAgileTeam team) {
        ArtifactId teamFolder = AgileFolders.getTeamFolder(this.services, team.getId());
        if (teamFolder == null) {
            return null;
        }
        ArtifactToken backlogArt = this.services.getRelationResolver().getRelatedOrNull(teamFolder, AtsRelationTypes.AgileTeamToBacklog_Backlog);
        if (backlogArt == null) {
            return null;
        }
        return new AgileBacklog(this.logger, this.services, backlogArt);
    }

    public IAgileBacklog getAgileBacklog(long uuid) {
        IAgileBacklog backlog = null;
        ArtifactToken teamArt = this.services.getArtifact(Long.valueOf(uuid));
        if (teamArt != null) {
            backlog = this.getAgileBacklog((ArtifactId)teamArt);
        }
        return backlog;
    }

    public IAgileBacklog createAgileBacklog(long teamUuid, String name, String guid, Long uuid) {
        return AgileFactory.createAgileBacklog(this.logger, this.services, teamUuid, name, guid, uuid);
    }

    public IAgileBacklog updateAgileBacklog(JaxAgileBacklog updatedBacklog) {
        AgileBacklogWriter writer = new AgileBacklogWriter(this.services, this, updatedBacklog);
        return writer.write();
    }

    public JaxAgileItem updateItem(JaxAgileItem newItem) {
        AgileItemWriter writer = new AgileItemWriter(this.services, this, newItem);
        return writer.write();
    }

    public Collection<IAgileFeatureGroup> getAgileFeatureGroups(List<Long> uuids) {
        LinkedList<IAgileFeatureGroup> features = new LinkedList<IAgileFeatureGroup>();
        for (ArtifactId featureArt : this.services.getArtifacts(uuids)) {
            features.add(this.services.getConfigItemFactory().getAgileFeatureGroup(featureArt));
        }
        return features;
    }

    public Collection<IAgileItem> getItems(IAgileBacklog backlog) {
        return this.getItems((IAtsObject)backlog, AtsRelationTypes.Goal_Member);
    }

    private Collection<IAgileItem> getItems(IAtsObject backlogOrSprint, RelationTypeSide relationType) {
        LinkedList<IAgileItem> items = new LinkedList<IAgileItem>();
        ArtifactToken backlogArt = backlogOrSprint.getStoreObject();
        for (ArtifactToken art : this.services.getRelationResolver().getRelated((ArtifactId)backlogArt, relationType)) {
            if (this.services.getStoreService().isOfType((ArtifactId)art, new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) {
                items.add(this.services.getWorkItemFactory().getAgileItem((ArtifactId)art));
                continue;
            }
            throw new OseeStateException("Inavlid artifact [%s] in [%s].  Only workflows are allowed, not [%s]", new Object[]{art.toStringWithId(), backlogOrSprint, art.getArtifactType().getName()});
        }
        return items;
    }

    public Collection<IAgileItem> getItems(IAgileSprint sprint) {
        return this.getItems((IAtsObject)sprint, AtsRelationTypes.AgileSprintToItem_AtsItem);
    }

    public Collection<IAgileFeatureGroup> getFeatureGroups(IAgileItem aItem) {
        LinkedList<IAgileFeatureGroup> groups = new LinkedList<IAgileFeatureGroup>();
        ArtifactToken itemArt = this.services.getArtifact((IAtsObject)aItem);
        for (ArtifactId featureGroup : this.services.getRelationResolver().getRelated((ArtifactId)itemArt, AtsRelationTypes.AgileFeatureToItem_FeatureGroup)) {
            groups.add(this.services.getAgileService().getAgileFeatureGroup(featureGroup));
        }
        return groups;
    }

    public IAgileSprint getSprint(IAgileItem item) {
        IAgileSprint sprint = null;
        ArtifactToken itemArt = this.services.getArtifact((IAtsObject)item);
        ArtifactToken sprintArt = this.services.getRelationResolver().getRelatedOrNull((ArtifactId)itemArt, AtsRelationTypes.AgileSprintToItem_Sprint);
        if (sprintArt != null) {
            sprint = this.services.getWorkItemFactory().getAgileSprint(sprintArt);
        }
        return sprint;
    }

    public void deleteSprint(long sprintUuid) {
        ArtifactToken sprint = this.services.getArtifact(Long.valueOf(sprintUuid));
        if (sprint != null) {
            IAtsChangeSet changes = this.services.createChangeSet("Delete Agile Sprint");
            changes.deleteArtifact((ArtifactId)sprint);
            changes.execute();
        }
    }

    public IAgileTeam getAgileTeam(IAgileItem item) {
        ArtifactToken teamArt;
        ArtifactToken teamArt2;
        ArtifactToken itemArt = this.services.getArtifact((IAtsObject)item);
        ArtifactToken backlogArt = this.services.getRelationResolver().getRelatedOrNull((ArtifactId)itemArt, AtsRelationTypes.Goal_Member);
        if (backlogArt != null && (teamArt2 = this.services.getRelationResolver().getRelatedOrNull((ArtifactId)backlogArt, AtsRelationTypes.AgileTeamToBacklog_AgileTeam)) != null) {
            return this.services.getConfigItemFactory().getAgileTeam((ArtifactId)teamArt2);
        }
        ArtifactToken sprintArt = this.services.getRelationResolver().getRelatedOrNull((ArtifactId)itemArt, AtsRelationTypes.AgileSprintToItem_Sprint);
        if (sprintArt != null && (teamArt = this.services.getRelationResolver().getRelatedOrNull((ArtifactId)sprintArt, AtsRelationTypes.AgileTeamToSprint_AgileTeam)) != null) {
            return this.services.getConfigItemFactory().getAgileTeam((ArtifactId)teamArt);
        }
        return null;
    }

    public ArtifactToken getRelatedBacklogArt(IAtsWorkItem workItem) {
        ArtifactToken relatedBacklogArt = null;
        for (ArtifactToken backlogArt : this.services.getRelationResolver().getRelated((IAtsObject)workItem, AtsRelationTypes.Goal_Goal)) {
            if (!this.isBacklog(backlogArt)) continue;
            relatedBacklogArt = backlogArt;
        }
        return relatedBacklogArt;
    }

    public boolean isBacklog(Object object) {
        boolean backlog = false;
        if (object instanceof IAtsWorkItem) {
            backlog = this.services.getRelationResolver().getRelatedCount((IAtsWorkItem)object, AtsRelationTypes.AgileTeamToBacklog_AgileTeam) == 1;
        } else if (object instanceof ArtifactToken) {
            backlog = this.services.getRelationResolver().getRelatedCount((ArtifactToken)object, AtsRelationTypes.AgileTeamToBacklog_AgileTeam) == 1;
        }
        return backlog;
    }

    public boolean isSprint(ArtifactId artifact) {
        return this.services.getStoreService().isOfType(artifact, new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint});
    }

    public Collection<ArtifactToken> getRelatedSprints(ArtifactId artifact) {
        HashSet<ArtifactToken> sprints = new HashSet<ArtifactToken>();
        for (ArtifactToken sprintArt : this.services.getRelationResolver().getRelatedArtifacts(artifact, AtsRelationTypes.AgileSprintToItem_Sprint)) {
            sprints.add(sprintArt);
        }
        return sprints;
    }

    public String getAgileTeamPointsStr(IAtsWorkItem workItem) {
        String result = this.services.getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.Points, "");
        if (Strings.isInValid((String)result)) {
            result = ((Double)this.services.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.PointsNumeric, (Object)0.0)).toString();
        }
        return result;
    }

    public IAgileTeam getAgileTeam(IAtsWorkItem workItem) {
        IAgileTeam agileTeam = null;
        IAtsTeamWorkflow teamWf = workItem.getParentTeamWorkflow();
        if (teamWf != null) {
            IAgileBacklog backlog;
            ArtifactToken backlogArt;
            IAgileSprint sprint;
            ArtifactToken sprintArt;
            ArtifactToken agileTeamArt;
            IAtsTeamDefinition teamDef = teamWf.getTeamDefinition();
            if (teamDef != null && (agileTeamArt = this.services.getRelationResolver().getRelatedOrNull((IAtsObject)teamDef, AtsRelationTypes.AgileTeamToAtsTeam_AgileTeam)) != null) {
                agileTeam = this.services.getAgileService().getAgileTeam((ArtifactId)agileTeamArt);
            }
            if (agileTeam == null && (sprintArt = this.services.getRelationResolver().getRelatedOrNull((IAtsObject)workItem, AtsRelationTypes.AgileSprintToItem_Sprint)) != null && (sprint = this.getAgileSprint((ArtifactId)sprintArt)) != null) {
                agileTeam = this.services.getAgileService().getAgileTeamFromSprint(sprint);
            }
            if (agileTeam == null && (backlogArt = this.services.getRelationResolver().getRelatedOrNull((IAtsObject)workItem, AtsRelationTypes.Goal_Goal)) != null && (backlog = this.getAgileBacklog((ArtifactId)backlogArt)) != null) {
                agileTeam = this.services.getAgileService().getAgileTeamFromBacklog(backlog);
            }
        }
        return agileTeam;
    }

    public IAgileTeam getAgileTeamFromSprint(IAgileSprint sprint) {
        IAgileTeam agileTeam = null;
        ArtifactToken agileTeamArt = this.services.getRelationResolver().getRelatedOrNull((IAtsObject)sprint, AtsRelationTypes.AgileTeamToSprint_AgileTeam);
        if (agileTeamArt != null) {
            agileTeam = this.services.getAgileService().getAgileTeam((ArtifactId)agileTeamArt);
        }
        return agileTeam;
    }

    public IAgileTeam getAgileTeamFromBacklog(IAgileBacklog backlog) {
        IAgileTeam agileTeam = null;
        ArtifactToken agileBacklogArt = this.services.getRelationResolver().getRelatedOrNull((IAtsObject)backlog, AtsRelationTypes.AgileTeamToBacklog_AgileTeam);
        if (agileBacklogArt != null) {
            agileTeam = this.services.getAgileService().getAgileTeam((ArtifactId)agileBacklogArt);
        }
        return agileTeam;
    }
}

