/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.IAgileService;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.JaxAgileItem;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;

public class AgileItemWriter {
    private final IAtsServices services;
    private final JaxAgileItem newItem;
    private final IAgileService agileService;

    public AgileItemWriter(IAtsServices services, IAgileService agileService, JaxAgileItem newItem) {
        this.services = services;
        this.agileService = agileService;
        this.newItem = newItem;
    }

    public JaxAgileItem write() {
        IAtsChangeSet changes = this.services.getStoreService().createAtsChangeSet("Update new Agile Item", AtsCoreUsers.SYSTEM_USER);
        if (this.newItem.isSetFeatures()) {
            Collection features = this.agileService.getAgileFeatureGroups(this.newItem.getFeatures());
            LinkedList featureArts = new LinkedList();
            for (IAgileFeatureGroup feature : features) {
                featureArts.add(feature.getStoreObject());
            }
            for (ArtifactToken awa : this.services.getArtifacts(this.newItem.getUuids())) {
                for (IAgileFeatureGroup feature : features) {
                    ArtifactToken featureArt = feature.getStoreObject();
                    if (this.services.getRelationResolver().areRelated((ArtifactId)featureArt, AtsRelationTypes.AgileFeatureToItem_FeatureGroup, (ArtifactId)awa)) continue;
                    changes.relate((Object)feature, AtsRelationTypes.AgileFeatureToItem_AtsItem, (Object)awa);
                }
                for (ArtifactToken featureArt : this.services.getRelationResolver().getRelated((ArtifactId)awa, AtsRelationTypes.AgileFeatureToItem_FeatureGroup)) {
                    if (featureArts.contains(featureArt)) continue;
                    changes.unrelate((ArtifactId)featureArt, AtsRelationTypes.AgileFeatureToItem_AtsItem, (ArtifactId)awa);
                }
            }
        } else if (this.newItem.isRemoveFeatures()) {
            for (ArtifactToken awa : this.services.getArtifacts(this.newItem.getUuids())) {
                for (IAgileFeatureGroup feature : this.services.getRelationResolver().getRelated((ArtifactId)awa, AtsRelationTypes.AgileFeatureToItem_FeatureGroup)) {
                    changes.unrelate((ArtifactId)feature, AtsRelationTypes.AgileFeatureToItem_AtsItem, (ArtifactId)awa);
                }
            }
        }
        if (this.newItem.isSetSprint()) {
            ArtifactToken sprintArt = this.services.getArtifact(Long.valueOf(this.newItem.getSprintUuid()));
            IAgileSprint sprint = this.services.getAgileService().getAgileSprint((ArtifactId)sprintArt);
            for (ArtifactToken awa : this.services.getArtifacts(this.newItem.getUuids())) {
                if (sprint != null) {
                    changes.setRelation((Object)sprint, AtsRelationTypes.AgileSprintToItem_AtsItem, (Object)awa);
                } else {
                    changes.unrelateAll((Object)awa, AtsRelationTypes.AgileSprintToItem_AtsItem);
                }
                changes.add((Object)sprint);
            }
        }
        if (this.newItem.isSetBacklog()) {
            ArtifactToken backlogArt = this.services.getArtifact(Long.valueOf(this.newItem.getBacklogUuid()));
            IAgileSprint backlog = this.services.getAgileService().getAgileSprint((ArtifactId)backlogArt);
            for (ArtifactToken awa : this.services.getArtifacts(this.newItem.getUuids())) {
                if (backlog != null) {
                    changes.setRelation((Object)backlog, AtsRelationTypes.Goal_Member, (Object)awa);
                } else {
                    changes.unrelateAll((Object)awa, AtsRelationTypes.Goal_Member);
                }
                changes.add((Object)backlog);
            }
        }
        if (!changes.isEmpty()) {
            changes.execute();
        }
        return this.newItem;
    }
}

