/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile;

import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;

public class AgileFolders {
    public static ArtifactId getOrCreateTopSprintFolder(IAtsServices services, long teamUuid, IAtsChangeSet changes) {
        ArtifactId teamFolder = AgileFolders.getTeamFolder(services, teamUuid);
        ArtifactId sprintFolder = null;
        for (ArtifactToken child : services.getRelationResolver().getChildren(teamFolder)) {
            if (!child.getName().equals("Sprints")) continue;
            sprintFolder = child;
        }
        if (sprintFolder == null) {
            sprintFolder = changes.createArtifact(CoreArtifactTypes.Folder, "Sprints");
            changes.relate((Object)teamFolder, CoreRelationTypes.Default_Hierarchical__Child, (Object)sprintFolder);
        }
        return sprintFolder;
    }

    public static ArtifactId getTeamFolder(IAtsServices services, long teamUuid) {
        return services.getArtifact(Long.valueOf(teamUuid));
    }

    public static ArtifactId getOrCreateTopFeatureGroupFolder(IAtsServices services, long teamUuid, ArtifactId artifact, IAtsChangeSet changes) {
        ArtifactId teamFolder = AgileFolders.getTeamFolder(services, teamUuid);
        ArtifactId featureGroupFolder = null;
        for (ArtifactToken child : services.getRelationResolver().getChildren(teamFolder)) {
            if (!child.getName().equals("Feature Groups")) continue;
            featureGroupFolder = child;
        }
        if (featureGroupFolder == null) {
            featureGroupFolder = changes.createArtifact(CoreArtifactTypes.Folder, "Feature Groups");
            changes.addChild(teamFolder, featureGroupFolder);
        }
        return featureGroupFolder;
    }

    public static ArtifactId getOrCreateTopAgileFolder(IAtsServices services, ArtifactId userArt, IAtsChangeSet changes) {
        ArtifactToken agileFolder = services.getArtifact((ArtifactId)AtsArtifactToken.TopAgileFolder);
        if (agileFolder == null) {
            agileFolder = changes.createArtifact(AtsArtifactToken.TopAgileFolder);
            ArtifactToken rootArtifact = services.getArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot);
            changes.addChild((ArtifactId)rootArtifact, (ArtifactId)agileFolder);
        }
        return agileFolder;
    }
}

