/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxNewAgileTeam;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.core.agile.AgileBacklog;
import org.eclipse.osee.ats.core.agile.AgileFeatureGroup;
import org.eclipse.osee.ats.core.agile.AgileFolders;
import org.eclipse.osee.ats.core.agile.AgileSprint;
import org.eclipse.osee.ats.core.agile.AgileTeam;
import org.eclipse.osee.ats.core.config.TeamDefinitions;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class AgileFactory {
    private AgileFactory() {
    }

    public static IAgileTeam createAgileTeam(Log logger, IAtsServices services, JaxNewAgileTeam newTeam) {
        ArtifactToken userArt = services.getArtifact((IAtsObject)services.getUserService().getCurrentUser());
        ArtifactToken agileTeamArt = services.getArtifact(newTeam.getUuid());
        if (agileTeamArt == null) {
            IAtsChangeSet changes = services.createChangeSet("Create new Agile Team");
            agileTeamArt = changes.createArtifact(AtsArtifactTypes.AgileTeam, newTeam.getName(), GUID.create(), newTeam.getUuid());
            changes.setSoleAttributeValue((ArtifactId)agileTeamArt, (AttributeTypeId)AtsAttributeTypes.Active, (Object)true);
            ArtifactId topAgileFolder = AgileFolders.getOrCreateTopAgileFolder(services, (ArtifactId)userArt, changes);
            if (!topAgileFolder.equals(services.getRelationResolver().getParent((ArtifactId)agileTeamArt))) {
                changes.unrelateFromAll(CoreRelationTypes.Default_Hierarchical__Parent, (ArtifactId)agileTeamArt);
                changes.addChild(topAgileFolder, (ArtifactId)agileTeamArt);
            }
            HashSet atsTeamArts = new HashSet();
            changes.setRelations((Object)agileTeamArt, AtsRelationTypes.AgileTeamToAtsTeam_AtsTeam, atsTeamArts);
            changes.execute();
        }
        return AgileFactory.getAgileTeam(logger, services, agileTeamArt);
    }

    public static IAgileTeam updateAgileTeam(Log logger, IAtsServices services, JaxAgileTeam team) {
        ArtifactToken userArt = services.getArtifact((IAtsObject)services.getUserService().getCurrentUser());
        IAtsChangeSet changes = services.createChangeSet("Update new Agile Team");
        ArtifactToken agileTeamArt = services.getArtifact(team.getUuid());
        if (agileTeamArt == null) {
            throw new OseeStateException("Agile Team not found with Uuid [%d]", new Object[]{team.getUuid()});
        }
        if (Strings.isValid((String)team.getName()) && !team.getName().equals(agileTeamArt.getName())) {
            changes.setName(agileTeamArt, team.getName());
        }
        if (Strings.isValid((String)team.getDescription()) && !team.getDescription().equals(services.getAttributeResolver().getSoleAttributeValue((ArtifactId)agileTeamArt, (AttributeTypeId)AtsAttributeTypes.Description, (Object)""))) {
            changes.setSoleAttributeValue((ArtifactId)agileTeamArt, (AttributeTypeId)AtsAttributeTypes.Description, (Object)team.getDescription());
        }
        changes.setSoleAttributeValue((ArtifactId)agileTeamArt, (AttributeTypeId)AtsAttributeTypes.Active, (Object)team.isActive());
        ArtifactId topAgileFolder = AgileFolders.getOrCreateTopAgileFolder(services, (ArtifactId)userArt, changes);
        if (!topAgileFolder.equals(services.getRelationResolver().getParent((ArtifactId)agileTeamArt))) {
            changes.unrelateFromAll(CoreRelationTypes.Default_Hierarchical__Parent, (ArtifactId)agileTeamArt);
            changes.addChild(topAgileFolder, (ArtifactId)agileTeamArt);
        }
        HashSet<ArtifactToken> atsTeamArts = new HashSet<ArtifactToken>();
        Iterator iterator = team.getAtsTeamUuids().iterator();
        while (iterator.hasNext()) {
            long atsTeamUuid = (Long)iterator.next();
            ArtifactToken atsTeamArt = services.getArtifact(Long.valueOf(atsTeamUuid));
            if (atsTeamArt != null && services.getStoreService().isOfType((ArtifactId)atsTeamArt, new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition})) {
                atsTeamArts.add(atsTeamArt);
                continue;
            }
            throw new OseeArgumentException("UUID %d is not a valid Ats Team Definition", new Object[]{atsTeamUuid});
        }
        changes.setRelations((Object)agileTeamArt, AtsRelationTypes.AgileTeamToAtsTeam_AtsTeam, atsTeamArts);
        changes.execute();
        return AgileFactory.getAgileTeam(logger, services, agileTeamArt);
    }

    public static IAgileTeam getAgileTeam(Log logger, IAtsServices services, Object artifact) {
        return new AgileTeam(logger, services, (ArtifactToken)artifact);
    }

    public static IAgileFeatureGroup createAgileFeatureGroup(Log logger, IAtsServices services, long teamUuid, String name, String guid, Long uuid) {
        JaxAgileFeatureGroup feature = new JaxAgileFeatureGroup();
        feature.setName(name);
        feature.setUuid(uuid);
        feature.setTeamUuid(teamUuid);
        feature.setActive(true);
        return AgileFactory.createAgileFeatureGroup(logger, services, feature);
    }

    public static IAgileFeatureGroup createAgileFeatureGroup(Log logger, IAtsServices services, JaxAgileFeatureGroup newFeatureGroup) {
        ArtifactToken userArt = services.getArtifact((IAtsObject)services.getUserService().getCurrentUser());
        IAtsChangeSet changes = services.createChangeSet("Create new Agile Feature Group");
        ArtifactToken featureGroupArt = changes.createArtifact(AtsArtifactTypes.AgileFeatureGroup, newFeatureGroup.getName(), GUID.create(), newFeatureGroup.getUuid());
        changes.setSoleAttributeValue((ArtifactId)featureGroupArt, (AttributeTypeId)AtsAttributeTypes.Active, (Object)newFeatureGroup.isActive());
        ArtifactId featureGroupFolder = AgileFolders.getOrCreateTopFeatureGroupFolder(services, newFeatureGroup.getTeamUuid(), (ArtifactId)userArt, changes);
        changes.addChild(featureGroupFolder, (ArtifactId)featureGroupArt);
        ArtifactId team = AgileFolders.getTeamFolder(services, newFeatureGroup.getTeamUuid());
        changes.relate((Object)team, AtsRelationTypes.AgileTeamToFeatureGroup_FeatureGroup, (Object)featureGroupArt);
        changes.execute();
        return AgileFactory.getAgileFeatureGroup(logger, services, featureGroupArt);
    }

    public static IAgileFeatureGroup getAgileFeatureGroup(Log logger, IAtsServices services, Object artifact) {
        return new AgileFeatureGroup(logger, services, (ArtifactToken)artifact);
    }

    public static IAgileSprint createAgileSprint(Log logger, IAtsServices services, long teamUuid, String name, String guid, Long uuid) {
        IAtsChangeSet changes = services.getStoreService().createAtsChangeSet("Create new Agile Sprint", AtsCoreUsers.SYSTEM_USER);
        ArtifactToken sprintArt = changes.createArtifact(AtsArtifactTypes.AgileSprint, name, guid, uuid);
        IAgileSprint sprint = services.getWorkItemFactory().getAgileSprint(sprintArt);
        services.getActionFactory().setAtsId((IAtsObject)sprint, TeamDefinitions.getTopTeamDefinition(services.getQueryService()), changes);
        services.getActionFactory().initializeNewStateMachine((IAtsWorkItem)sprint, Arrays.asList(AtsCoreUsers.UNASSIGNED_USER), new Date(), services.getUserService().getCurrentUser(), changes);
        changes.add((Object)sprintArt);
        ArtifactId teamFolder = AgileFolders.getTeamFolder(services, teamUuid);
        ArtifactId agileSprintFolderArt = AgileFolders.getOrCreateTopSprintFolder(services, teamUuid, changes);
        changes.relate((Object)agileSprintFolderArt, CoreRelationTypes.Default_Hierarchical__Child, (Object)sprintArt);
        changes.relate((Object)teamFolder, AtsRelationTypes.AgileTeamToSprint_Sprint, (Object)sprintArt);
        changes.execute();
        return AgileFactory.getAgileSprint(logger, services, sprintArt);
    }

    public static IAgileSprint getAgileSprint(Log logger, IAtsServices services, Object artifact) {
        return new AgileSprint(logger, services, (ArtifactToken)artifact);
    }

    public static IAgileBacklog createAgileBacklog(Log logger, IAtsServices services, long teamUuid, String name, String guid, Long uuid) {
        IAtsChangeSet changes = services.getStoreService().createAtsChangeSet("Create new Agile Backlog", AtsCoreUsers.SYSTEM_USER);
        ArtifactToken backlogArt = changes.createArtifact(AtsArtifactTypes.Goal, name, guid, uuid);
        IAgileBacklog sprint = services.getWorkItemFactory().getAgileBacklog(backlogArt);
        services.getActionFactory().setAtsId((IAtsObject)sprint, TeamDefinitions.getTopTeamDefinition(services.getQueryService()), changes);
        services.getActionFactory().initializeNewStateMachine((IAtsWorkItem)sprint, Arrays.asList(AtsCoreUsers.UNASSIGNED_USER), new Date(), services.getUserService().getCurrentUser(), changes);
        changes.add((Object)backlogArt);
        ArtifactId teamFolder = AgileFolders.getTeamFolder(services, teamUuid);
        changes.relate((Object)teamFolder, AtsRelationTypes.AgileTeamToBacklog_Backlog, (Object)backlogArt);
        changes.relate((Object)teamFolder, CoreRelationTypes.Default_Hierarchical__Child, (Object)backlogArt);
        changes.execute();
        return AgileFactory.getAgileBacklog(logger, services, backlogArt);
    }

    public static IAgileBacklog getAgileBacklog(Log logger, IAtsServices services, Object artifact) {
        return new AgileBacklog(logger, services, (ArtifactToken)artifact);
    }
}

