/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile;

import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileService;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxAgileBacklog;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public class AgileBacklogWriter {
    private final IAtsServices services;
    private final IAgileService agileService;
    private final JaxAgileBacklog updatedBacklog;

    public AgileBacklogWriter(IAtsServices services, IAgileService agileService, JaxAgileBacklog updatedBacklog) {
        this.services = services;
        this.agileService = agileService;
        this.updatedBacklog = updatedBacklog;
    }

    public IAgileBacklog write() {
        IAtsChangeSet changes = this.services.getStoreService().createAtsChangeSet("Update Agile Backlog", AtsCoreUsers.SYSTEM_USER);
        IAgileBacklog currentBacklog = this.agileService.getAgileBacklog(this.updatedBacklog.getUuid().longValue());
        if (currentBacklog == null) {
            throw new OseeArgumentException("No Backlog found with UUID %d", new Object[]{this.updatedBacklog.getUuid()});
        }
        if (currentBacklog.getTeamUuid() != this.updatedBacklog.getTeamUuid()) {
            if (currentBacklog.getTeamUuid() == -1L) {
                IAgileTeam team = this.agileService.getAgileTeam(currentBacklog.getTeamUuid());
                if (team != null) {
                    changes.unrelateAll((Object)team, AtsRelationTypes.AgileTeamToBacklog_Backlog);
                    changes.add((Object)team);
                }
            } else {
                ArtifactToken currentTeamArt;
                ArtifactToken updateBacklogArt = this.services.getArtifact(this.updatedBacklog.getUuid());
                IAgileTeam updatedTeam = this.agileService.getAgileTeam(this.updatedBacklog.getTeamUuid());
                ArtifactToken updatedTeamArt = updatedTeam.getStoreObject();
                if (!this.services.getStoreService().isOfType((ArtifactId)updateBacklogArt, new ArtifactTypeId[]{AtsArtifactTypes.Goal})) {
                    throw new OseeArgumentException("Backlog UUID %d not valid type", new Object[]{this.updatedBacklog.getUuid()});
                }
                if (this.services.getRelationResolver().getRelatedCount(updateBacklogArt, AtsRelationTypes.AgileTeamToBacklog_AgileTeam) > 0 && !updatedTeamArt.equals(currentTeamArt = this.services.getRelationResolver().getRelatedOrNull((ArtifactId)updateBacklogArt, AtsRelationTypes.AgileTeamToBacklog_AgileTeam))) {
                    changes.unrelate((ArtifactId)currentTeamArt, AtsRelationTypes.AgileTeamToBacklog_Backlog, (ArtifactId)updateBacklogArt);
                    changes.add((Object)currentTeamArt);
                }
                changes.relate((Object)updatedTeamArt, AtsRelationTypes.AgileTeamToBacklog_Backlog, (Object)updateBacklogArt);
                if (!this.services.getRelationResolver().areRelated((ArtifactId)updatedTeamArt, CoreRelationTypes.Default_Hierarchical__Child, (ArtifactId)updateBacklogArt)) {
                    if (this.services.getRelationResolver().getParent((ArtifactId)updateBacklogArt) != null) {
                        changes.unrelate((ArtifactId)this.services.getRelationResolver().getParent((ArtifactId)updateBacklogArt), CoreRelationTypes.Default_Hierarchical__Child, (ArtifactId)updateBacklogArt);
                    }
                    changes.relate((Object)updatedTeamArt, CoreRelationTypes.Default_Hierarchical__Child, (Object)updateBacklogArt);
                }
                changes.add((Object)updatedTeamArt);
            }
        }
        if (!changes.isEmpty()) {
            changes.execute();
        }
        return this.agileService.getAgileBacklog(this.updatedBacklog.getUuid().longValue());
    }
}

