/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.x.server.application.internal.operations;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osee.framework.core.server.IApplicationServerManager;
import org.eclipse.osee.framework.core.server.IAuthenticationManager;
import org.eclipse.osee.framework.core.server.OseeServerProperties;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.x.server.application.internal.model.ServerStatus;
import org.eclipse.osee.x.server.application.internal.model.StatusKey;

public class BuildServerStatusOperation {
    private final IApplicationServerManager applicationServerManager;
    private final IAuthenticationManager authManager;

    public BuildServerStatusOperation(IApplicationServerManager applicationServerManager, IAuthenticationManager authManager) {
        this.applicationServerManager = applicationServerManager;
        this.authManager = authManager;
    }

    public ServerStatus get() {
        ServerStatus stat = new ServerStatus();
        stat.set(StatusKey.ServerUri, this.applicationServerManager.getServerUri().toString());
        stat.set(StatusKey.ServerId, this.applicationServerManager.getId());
        stat.set(StatusKey.StartTime, DateFormat.getDateTimeInstance(1, 1).format(this.applicationServerManager.getDateStarted()));
        stat.set(StatusKey.CodeLocation, System.getProperty("user.dir"));
        stat.set(StatusKey.BinaryDataPath, OseeServerProperties.getOseeApplicationServerData(null));
        stat.set(StatusKey.AuthenticationScheme, this.authManager.getProtocol());
        stat.set(StatusKey.AuthenticationSchemeSupported, Arrays.deepToString(this.authManager.getProtocols()));
        stat.set(StatusKey.SupportedVersions, Arrays.deepToString(this.applicationServerManager.getVersions()));
        MemoryUsage heapMem = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        stat.set(StatusKey.MemoryUsed, Lib.toMBytes((long)heapMem.getUsed()));
        stat.set(StatusKey.MemoryAllocated, Lib.toMBytes((long)heapMem.getCommitted()));
        stat.set(StatusKey.MemoryMax, Lib.toMBytes((long)heapMem.getMax()));
        stat.set(StatusKey.ServerState, this.applicationServerManager.isSystemIdle() ? "IDLE" : "BUSY");
        stat.set(StatusKey.ActiveThreads, String.valueOf(this.applicationServerManager.getNumberOfActiveThreads()));
        List entries = this.applicationServerManager.getCurrentProcesses();
        stat.set(StatusKey.CurrentTasks, entries.isEmpty() ? "NONE" : Collections.toString((String)", ", (Iterable)entries));
        return stat;
    }
}

