/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcClientConfig;
import org.eclipse.osee.jdbc.JdbcConstants;
import org.eclipse.osee.jdbc.JdbcException;
import org.eclipse.osee.jdbc.JdbcMigrationOptions;
import org.eclipse.osee.jdbc.JdbcMigrationResource;
import org.flywaydb.core.Flyway;

public class JdbcMigration {
    private static final String DB_BIGINT = "db.bigint";
    private static final String DB_CLOB = "db.clob";
    private static final String DB_BLOB = "db.blob";
    private static final String DB_ORGANIZATION_INDEX = "db.organization_index";
    private static final String DB_ORGANIZATION_INDEX_3 = "db.organization_index_3";
    private static final String DB_ORGANIZATION_INDEX_KEY_VALUE = "db.organization_index_key_value";
    private static final String DB_SYNONYM_2 = "db.synonym2";
    private static final String DB_GRANT_2 = "db.grant2";
    private static final String DB_SYNONYM_3 = "db.synonym3";
    private static final String DB_GRANT_3 = "db.grant3";
    private static final String DB_SYNONYM_4 = "db.synonym4";
    private static final String DB_GRANT_4 = "db.grant4";
    private static final String DB_SYNONYM_KEY_VALUE = "db.synonym_key_value";
    private static final String DB_GRANT_KEY_VALUE = "db.grant_key_value";
    private static final String DB_TABLESPACE = "db.tablespace";
    private static final String DB_PCTTHRESHOLD = "db.pctthreshold";
    private static final String DB_OVERFLOW = "db.overflow";
    private static final String DB_DEFERRABLE = "db.deferrable";
    private static final String LOCATION_TEMPLATE = "filesystem:%s";
    private boolean baselineOnMigrate = false;
    private final JdbcClient jdbcClient;

    public JdbcMigration(JdbcClient jdbcClient) {
        this.jdbcClient = jdbcClient;
    }

    public void migrate(JdbcMigrationOptions options, Iterable<JdbcMigrationResource> migrations) {
        try {
            ArrayList<String> allPaths = new ArrayList<String>();
            if (options.isBaselineOnMigration()) {
                this.baselineOnMigrate();
            }
            Flyway fly = this.newFlyway();
            Map placeholders = fly.getPlaceholders();
            for (JdbcMigrationResource migration : migrations) {
                migration.addPlaceholders(placeholders);
                URL location = migration.getLocation();
                try {
                    location = FileLocator.toFileURL((URL)location);
                }
                catch (Exception exception) {}
                String formated = String.format(LOCATION_TEMPLATE, location.getFile());
                allPaths.add(formated);
            }
            fly.setLocations(allPaths.toArray(new String[allPaths.size()]));
            this.before(placeholders);
            if (options.isClean()) {
                Conditions.checkExpressionFailOnTrue((boolean)this.jdbcClient.getConfig().isProduction(), (String)"Error - attempting to clean a production datastore.", (Object[])new Object[0]);
                fly.clean();
            }
            fly.migrate();
            this.after();
        }
        catch (Exception ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    public void baseline() {
        Flyway fly = this.newFlyway();
        fly.baseline();
    }

    public void clean() {
        Flyway fly = this.newFlyway();
        fly.clean();
    }

    public void baselineOnMigrate() {
        this.baselineOnMigrate = true;
    }

    private void before(Map<String, String> placeholders) {
        this.setDbTransactionControl("LOCKS");
        JdbcClientConfig config = this.jdbcClient.getConfig();
        String driver = config.getDbDriver();
        placeholders.put(DB_BLOB, "blob");
        placeholders.put(DB_CLOB, "clob");
        placeholders.put(DB_BIGINT, "bigint");
        placeholders.put(DB_ORGANIZATION_INDEX, "");
        placeholders.put(DB_ORGANIZATION_INDEX_3, "");
        placeholders.put(DB_ORGANIZATION_INDEX_KEY_VALUE, "");
        placeholders.put(DB_SYNONYM_2, "");
        placeholders.put(DB_GRANT_2, "");
        placeholders.put(DB_SYNONYM_3, "");
        placeholders.put(DB_GRANT_3, "");
        placeholders.put(DB_SYNONYM_4, "");
        placeholders.put(DB_GRANT_4, "");
        placeholders.put(DB_SYNONYM_KEY_VALUE, "");
        placeholders.put(DB_GRANT_KEY_VALUE, "");
        placeholders.put(DB_TABLESPACE, "");
        placeholders.put(DB_PCTTHRESHOLD, "");
        placeholders.put(DB_OVERFLOW, "");
        placeholders.put(DB_DEFERRABLE, "");
        if (JdbcConstants.JdbcDriverType.postgresql.getDriver().equals(driver)) {
            placeholders.put(DB_BLOB, "bytea");
            placeholders.put(DB_CLOB, "text");
            placeholders.put(DB_PCTTHRESHOLD, "");
            placeholders.put(DB_OVERFLOW, "");
            placeholders.put(DB_DEFERRABLE, "DEFERRABLE INITIALLY DEFERRED");
        } else if (JdbcConstants.JdbcDriverType.oracle_thin.getDriver().equals(driver)) {
            placeholders.put(DB_BIGINT, "number");
            placeholders.put(DB_ORGANIZATION_INDEX, "ORGANIZATION INDEX COMPRESS 2");
            placeholders.put(DB_ORGANIZATION_INDEX_3, "ORGANIZATION INDEX COMPRESS 3");
            placeholders.put(DB_ORGANIZATION_INDEX_KEY_VALUE, "ORGANIZATION INDEX");
            placeholders.put(DB_TABLESPACE, "TABLESPACE osee_data");
            placeholders.put(DB_PCTTHRESHOLD, "PCTTHRESHOLD 20");
            placeholders.put(DB_OVERFLOW, "OVERFLOW TABLESPACE osee_data");
            placeholders.put(DB_DEFERRABLE, "DEFERRABLE INITIALLY DEFERRED");
        }
    }

    private void after() {
        this.setDbTransactionControl("MVCC");
    }

    private void setDbTransactionControl(String mode) {
        JdbcClientConfig config = this.jdbcClient.getConfig();
        if (JdbcConstants.JdbcDriverType.hsql.getDriver().equals(config.getDbDriver())) {
            this.jdbcClient.runPreparedUpdate("SET DATABASE TRANSACTION CONTROL " + mode, new Object[0]);
        }
    }

    private Flyway newFlyway() {
        JdbcClientConfig config = this.jdbcClient.getConfig();
        Flyway fly = new Flyway();
        fly.setTable("OSEE_SCHEMA_VERSION");
        fly.setClassLoader(this.getClass().getClassLoader());
        fly.setDataSource(config.getDbUri(), config.getDbUsername(), config.getDbPassword(), new String[0]);
        fly.setBaselineOnMigrate(this.baselineOnMigrate);
        return fly;
    }
}

