/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.osee.jdbc.JdbcException;
import org.eclipse.osee.jdbc.internal.JdbcUtil;

public class OseePreparedStatement {
    private final PreparedStatement preparedStatement;
    private final int batchIncrementSize;
    private int currentBatchSize;
    private int resultCount;

    public OseePreparedStatement(PreparedStatement preparedStatement, int batchIncrementSize) {
        this.preparedStatement = preparedStatement;
        this.batchIncrementSize = batchIncrementSize;
    }

    public void addToBatch(Object ... params) {
        int i = 0;
        while (i < params.length) {
            JdbcUtil.setInputParameterForStatement(this.preparedStatement, params[i], i + 1);
            ++i;
        }
        this.finishAddToBatch();
    }

    public void addToBatch(Object param1) {
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param1, 1);
        this.finishAddToBatch();
    }

    public void addToBatch(Object param1, Object param2) {
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param1, 1);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param2, 2);
        this.finishAddToBatch();
    }

    public void addToBatch(Object param1, Object param2, Object param3) {
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param1, 1);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param2, 2);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param3, 3);
        this.finishAddToBatch();
    }

    public void addToBatch(Object param1, Object param2, Object param3, Object param4) {
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param1, 1);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param2, 2);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param3, 3);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param4, 4);
        this.finishAddToBatch();
    }

    public void addToBatch(Object param1, Object param2, Object param3, Object param4, Object param5) {
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param1, 1);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param2, 2);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param3, 3);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param4, 4);
        JdbcUtil.setInputParameterForStatement(this.preparedStatement, param5, 5);
        this.finishAddToBatch();
    }

    private void finishAddToBatch() {
        try {
            this.preparedStatement.addBatch();
            this.preparedStatement.clearParameters();
            ++this.currentBatchSize;
            if (this.currentBatchSize >= this.batchIncrementSize) {
                int[] updates = this.preparedStatement.executeBatch();
                this.resultCount += JdbcUtil.calculateBatchUpdateResults(updates);
                this.currentBatchSize = 0;
            }
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    public int execute() {
        int[] updates;
        if (this.currentBatchSize == 0) {
            return this.resultCount;
        }
        try {
            try {
                updates = this.preparedStatement.executeBatch();
            }
            catch (SQLException ex) {
                throw JdbcException.newJdbcException(ex);
            }
        }
        finally {
            JdbcUtil.close(this.preparedStatement);
        }
        return this.resultCount + JdbcUtil.calculateBatchUpdateResults(updates);
    }
}

