/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcConstants;
import org.eclipse.osee.jdbc.JdbcException;
import org.eclipse.osee.jdbc.internal.JdbcUtil;

public class JdbcPoolConfig {
    private boolean poolEnabled;
    private String poolConfigUri;
    private boolean poolPreparedStatementsAllowed;
    private int poolValidationQueryTimeoutSecs;
    private int poolMaxActiveConnections;
    private int poolMaxIdleConnections;
    private int poolMinIdleConnections;
    private long poolMaxWaitForConnection;
    private JdbcConstants.PoolExhaustedAction poolExhaustedAction;
    private boolean poolTestOnBorrowEnabled;
    private boolean poolTestOnReturnEnabled;
    private boolean poolTestWhileIdeEnabled;
    private long poolTimeBetweenEvictionCheckMillis;
    private int poolNumberTestsPerEvictionRun;
    private long poolMinEvictableIdleTimeMillis;
    private boolean poolLifo;
    private long poolSoftMinEvictableTimeoutMillis;
    private int poolMaxTotalPreparedStatements;
    private int poolMaxActivePreparedStatements;
    private int poolMaxIdlePreparedStatements;
    private int poolMinIdlePreparedStatements;
    private long poolMaxWaitPreparedStatements;
    private boolean poolAbandonedLoggingEnabled;
    private boolean poolAbandonedRemovalEnabled;
    private int poolAbandonedRemovalTimeout;

    JdbcPoolConfig() {
        this.reset();
    }

    void reset() {
        this.setPoolEnabled(true);
        this.setPoolConfigUri(JdbcConstants.DEFAULT_JDBC_POOL__CONFIG_FILE_URI);
        this.setPoolAbandonedLoggingEnabled(false);
        this.setPoolAbandonedRemovalEnabled(false);
        this.setPoolAbandonedRemovalTimeout(300);
        this.setPoolExhaustedAction(JdbcConstants.DEFAULT_JDBC_POOL__WHEN_EXHAUSTED_ACTION);
        this.setPoolLifo(true);
        this.setPoolMaxActiveConnections(10);
        this.setPoolMaxActivePreparedStatements(20);
        this.setPoolMaxIdleConnections(10);
        this.setPoolMaxIdlePreparedStatements(20);
        this.setPoolMaxTotalPreparedStatements(20);
        this.setPoolMaxWaitForConnection(-1L);
        this.setPoolMaxWaitPreparedStatements(-1L);
        this.setPoolMinEvictableIdleTimeMillis(60000L);
        this.setPoolMinIdleConnections(0);
        this.setPoolMinIdlePreparedStatements(0);
        this.setPoolNumberTestsPerEvictionRun(1);
        this.setPoolPreparedStatementsAllowed(false);
        this.setPoolSoftMinEvictableTimeoutMillis(-1L);
        this.setPoolTestOnBorrowEnabled(false);
        this.setPoolTestOnReturnEnabled(false);
        this.setPoolTestWhileIdeEnabled(true);
        this.setPoolTimeBetweenEvictionCheckMillis(5000L);
        this.setPoolValidationQueryTimeoutSecs(10);
    }

    public boolean isPoolEnabled() {
        return this.poolEnabled;
    }

    public String getPoolConfigUri() {
        return this.poolConfigUri;
    }

    public String getPoolConnectionDriver() {
        return "org.apache.commons.dbcp.PoolingDriver";
    }

    public String getPoolConnectionId() {
        return "jdbc:apache:commons:dbcp:";
    }

    public boolean isPoolPreparedStatementsAllowed() {
        return this.poolPreparedStatementsAllowed;
    }

    public int getPoolValidationQueryTimeoutSecs() {
        return this.poolValidationQueryTimeoutSecs;
    }

    public int getPoolMaxActiveConnections() {
        return this.poolMaxActiveConnections;
    }

    public int getPoolMaxIdleConnections() {
        return this.poolMaxIdleConnections;
    }

    public int getPoolMinIdleConnections() {
        return this.poolMinIdleConnections;
    }

    public long getPoolMaxWaitForConnection() {
        return this.poolMaxWaitForConnection;
    }

    public JdbcConstants.PoolExhaustedAction getPoolExhaustedAction() {
        return this.poolExhaustedAction;
    }

    public boolean isPoolTestOnBorrowEnabled() {
        return this.poolTestOnBorrowEnabled;
    }

    public boolean isPoolTestOnReturnEnabled() {
        return this.poolTestOnReturnEnabled;
    }

    public boolean isPoolTestWhileIdeEnabled() {
        return this.poolTestWhileIdeEnabled;
    }

    public long getPoolTimeBetweenEvictionCheckMillis() {
        return this.poolTimeBetweenEvictionCheckMillis;
    }

    public int getPoolNumberTestsPerEvictionRun() {
        return this.poolNumberTestsPerEvictionRun;
    }

    public long getPoolMinEvictableIdleTimeMillis() {
        return this.poolMinEvictableIdleTimeMillis;
    }

    public boolean isPoolLifo() {
        return this.poolLifo;
    }

    public long getPoolSoftMinEvictableTimeoutMillis() {
        return this.poolSoftMinEvictableTimeoutMillis;
    }

    public int getPoolMaxTotalPreparedStatements() {
        return this.poolMaxTotalPreparedStatements;
    }

    public int getPoolMaxActivePreparedStatements() {
        return this.poolMaxActivePreparedStatements;
    }

    public int getPoolMaxIdlePreparedStatements() {
        return this.poolMaxIdlePreparedStatements;
    }

    public int getPoolMinIdlePreparedStatements() {
        return this.poolMinIdlePreparedStatements;
    }

    public long getPoolMaxWaitPreparedStatements() {
        return this.poolMaxWaitPreparedStatements;
    }

    public boolean isPoolAbandonedLoggingEnabled() {
        return this.poolAbandonedLoggingEnabled;
    }

    public boolean isPoolAbandonedRemovalEnabled() {
        return this.poolAbandonedRemovalEnabled;
    }

    public int getPoolAbandonedRemovalTimeout() {
        return this.poolAbandonedRemovalTimeout;
    }

    void setPoolEnabled(boolean poolEnabled) {
        this.poolEnabled = poolEnabled;
    }

    void setPoolConfigUri(String poolConfigUri) {
        if (poolConfigUri != null && !poolConfigUri.equals(this.poolConfigUri)) {
            this.readPoolConfig(poolConfigUri);
        }
        this.poolConfigUri = poolConfigUri;
    }

    void setPoolPreparedStatementsAllowed(boolean poolPreparedStatementsAllowed) {
        this.poolPreparedStatementsAllowed = poolPreparedStatementsAllowed;
    }

    void setPoolValidationQueryTimeoutSecs(int poolValidationQueryTimeoutSecs) {
        this.poolValidationQueryTimeoutSecs = poolValidationQueryTimeoutSecs;
    }

    void setPoolMaxActiveConnections(int poolMaxActiveConnections) {
        this.poolMaxActiveConnections = poolMaxActiveConnections;
    }

    void setPoolMaxIdleConnections(int poolMaxIdleConnections) {
        this.poolMaxIdleConnections = poolMaxIdleConnections;
    }

    void setPoolMinIdleConnections(int poolMinIdleConnections) {
        this.poolMinIdleConnections = poolMinIdleConnections;
    }

    void setPoolMaxWaitForConnection(long poolMaxWaitForConnection) {
        this.poolMaxWaitForConnection = poolMaxWaitForConnection;
    }

    void setPoolExhaustedAction(JdbcConstants.PoolExhaustedAction poolExhaustedAction) {
        this.poolExhaustedAction = poolExhaustedAction;
    }

    void setPoolTestOnBorrowEnabled(boolean poolTestOnBorrowEnabled) {
        this.poolTestOnBorrowEnabled = poolTestOnBorrowEnabled;
    }

    void setPoolTestOnReturnEnabled(boolean poolTestOnReturnEnabled) {
        this.poolTestOnReturnEnabled = poolTestOnReturnEnabled;
    }

    void setPoolTestWhileIdeEnabled(boolean poolTestWhileIdeEnabled) {
        this.poolTestWhileIdeEnabled = poolTestWhileIdeEnabled;
    }

    void setPoolTimeBetweenEvictionCheckMillis(long poolTimeBetweenEvictionCheckMillis) {
        this.poolTimeBetweenEvictionCheckMillis = poolTimeBetweenEvictionCheckMillis;
    }

    void setPoolNumberTestsPerEvictionRun(int poolNumberTestsPerEvictionRun) {
        this.poolNumberTestsPerEvictionRun = poolNumberTestsPerEvictionRun;
    }

    void setPoolMinEvictableIdleTimeMillis(long poolMinEvictableIdleTimeMillis) {
        this.poolMinEvictableIdleTimeMillis = poolMinEvictableIdleTimeMillis;
    }

    void setPoolLifo(boolean poolLifo) {
        this.poolLifo = poolLifo;
    }

    void setPoolSoftMinEvictableTimeoutMillis(long poolSoftMinEvictableTimeoutMillis) {
        this.poolSoftMinEvictableTimeoutMillis = poolSoftMinEvictableTimeoutMillis;
    }

    void setPoolMaxTotalPreparedStatements(int poolMaxTotalPreparedStatements) {
        this.poolMaxTotalPreparedStatements = poolMaxTotalPreparedStatements;
    }

    void setPoolMaxActivePreparedStatements(int poolMaxActivePreparedStatements) {
        this.poolMaxActivePreparedStatements = poolMaxActivePreparedStatements;
    }

    void setPoolMaxIdlePreparedStatements(int poolMaxIdlePreparedStatements) {
        this.poolMaxIdlePreparedStatements = poolMaxIdlePreparedStatements;
    }

    void setPoolMinIdlePreparedStatements(int poolMinIdlePreparedStatements) {
        this.poolMinIdlePreparedStatements = poolMinIdlePreparedStatements;
    }

    void setPoolMaxWaitPreparedStatements(long poolMaxWaitPreparedStatements) {
        this.poolMaxWaitPreparedStatements = poolMaxWaitPreparedStatements;
    }

    void setPoolAbandonedLoggingEnabled(boolean poolAbandonedLoggingEnabled) {
        this.poolAbandonedLoggingEnabled = poolAbandonedLoggingEnabled;
    }

    void setPoolAbandonedRemovalEnabled(boolean poolAbandonedRemovalEnabled) {
        this.poolAbandonedRemovalEnabled = poolAbandonedRemovalEnabled;
    }

    void setPoolAbandonedRemovalTimeout(int poolAbandonedRemovalTimeout) {
        this.poolAbandonedRemovalTimeout = poolAbandonedRemovalTimeout;
    }

    void readProperties(Map<String, Object> src) {
        this.setPoolEnabled(JdbcUtil.getBoolean(src, JdbcConstants.JDBC_POOL__ENABLED, true));
        this.setPoolConfigUri(JdbcUtil.get(src, JdbcConstants.JDBC_POOL__CONFIG_FILE_URI, JdbcConstants.DEFAULT_JDBC_POOL__CONFIG_FILE_URI));
        this.setPoolAbandonedLoggingEnabled(JdbcUtil.getBoolean(src, JdbcConstants.JDBC_POOL__LOG_ABANDONED, false));
        this.setPoolAbandonedRemovalEnabled(JdbcUtil.getBoolean(src, JdbcConstants.JDBC_POOL__REMOVE_ABANDONED, false));
        this.setPoolAbandonedRemovalTimeout(JdbcUtil.getInt(src, JdbcConstants.JDBC_POOL__REMOVE_ABANDONED_TIMEOUT, 300));
        this.setPoolExhaustedAction(JdbcUtil.getExhaustedAction(src, JdbcConstants.JDBC_POOL__WHEN_EXHAUSTED_ACTION, JdbcConstants.DEFAULT_JDBC_POOL__WHEN_EXHAUSTED_ACTION));
        this.setPoolLifo(JdbcUtil.getBoolean(src, JdbcConstants.JDBC_POOL__LIFO, true));
        this.setPoolMaxActiveConnections(JdbcUtil.getInt(src, JdbcConstants.JDBC_POOL__MAX_ACTIVE_CONNECTIONS, 10));
        this.setPoolMaxActivePreparedStatements(JdbcUtil.getInt(src, JdbcConstants.JDBC_POOL__MAX_ACTIVE_PREPARED_STATEMENTS, 20));
        this.setPoolMaxIdleConnections(JdbcUtil.getInt(src, JdbcConstants.JDBC_POOL__MAX_IDLE_CONNECTIONS, 10));
        this.setPoolMaxIdlePreparedStatements(JdbcUtil.getInt(src, JdbcConstants.JDBC_POOL__MAX_IDLE_PREPARED_STATEMENTS, 20));
        this.setPoolMaxTotalPreparedStatements(JdbcUtil.getInt(src, JdbcConstants.JDBC_POOL__MAX_TOTAL_PREPARED_STATEMENTS, 20));
        this.setPoolMaxWaitForConnection(JdbcUtil.getLong(src, JdbcConstants.JDBC_POOL__MAX_WAIT_CONNECTIONS, -1L));
        this.setPoolMaxWaitPreparedStatements(JdbcUtil.getLong(src, JdbcConstants.JDBC_POOL__MAX_WAIT_PREPARED_STATEMENTS, -1L));
        this.setPoolMinEvictableIdleTimeMillis(JdbcUtil.getLong(src, JdbcConstants.JDBC_POOL__MIN_EVICTABLE_IDLE_TIME_MILLIS, 60000L));
        this.setPoolMinIdleConnections(JdbcUtil.getInt(src, JdbcConstants.JDBC_POOL__MIN_IDLE_CONNECTIONS, 0));
        this.setPoolMinIdlePreparedStatements(JdbcUtil.getInt(src, JdbcConstants.JDBC_POOL__MIN_IDLE_PREPARED_STATEMENTS, 0));
        this.setPoolNumberTestsPerEvictionRun(JdbcUtil.getInt(src, JdbcConstants.JDBC_POOL__NUM_TESTS_PER_EVICTION_RUN, 1));
        this.setPoolPreparedStatementsAllowed(JdbcUtil.getBoolean(src, JdbcConstants.JDBC_POOL__PREPARED_STATEMENTS_ALLOWED, false));
        this.setPoolSoftMinEvictableTimeoutMillis(JdbcUtil.getLong(src, JdbcConstants.JDBC_POOL__SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS, -1L));
        this.setPoolTestOnBorrowEnabled(JdbcUtil.getBoolean(src, JdbcConstants.JDBC_POOL__TEST_ON_BORROW, false));
        this.setPoolTestOnReturnEnabled(JdbcUtil.getBoolean(src, JdbcConstants.JDBC_POOL__TEST_ON_RETURN, false));
        this.setPoolTestWhileIdeEnabled(JdbcUtil.getBoolean(src, JdbcConstants.JDBC_POOL__TEST_WHILE_IDLE, true));
        this.setPoolTimeBetweenEvictionCheckMillis(JdbcUtil.getLong(src, JdbcConstants.JDBC_POOL__TIME_BETWEEN_EVICTION_RUNS_MILLIS, 5000L));
        this.setPoolValidationQueryTimeoutSecs(JdbcUtil.getInt(src, JdbcConstants.JDBC_POOL__VALIDATION_QUERY_TIMEOUT_SECS, 10));
    }

    protected JdbcPoolConfig copy() {
        JdbcPoolConfig data = new JdbcPoolConfig();
        data.poolEnabled = this.poolEnabled;
        data.poolConfigUri = this.poolConfigUri;
        data.poolPreparedStatementsAllowed = this.poolPreparedStatementsAllowed;
        data.poolValidationQueryTimeoutSecs = this.poolValidationQueryTimeoutSecs;
        data.poolMaxActiveConnections = this.poolMaxActiveConnections;
        data.poolMaxIdleConnections = this.poolMaxIdleConnections;
        data.poolMinIdleConnections = this.poolMinIdleConnections;
        data.poolMaxWaitForConnection = this.poolMaxWaitForConnection;
        data.poolExhaustedAction = this.poolExhaustedAction;
        data.poolTestOnBorrowEnabled = this.poolTestOnBorrowEnabled;
        data.poolTestOnReturnEnabled = this.poolTestOnReturnEnabled;
        data.poolTestWhileIdeEnabled = this.poolTestWhileIdeEnabled;
        data.poolTimeBetweenEvictionCheckMillis = this.poolTimeBetweenEvictionCheckMillis;
        data.poolNumberTestsPerEvictionRun = this.poolNumberTestsPerEvictionRun;
        data.poolMinEvictableIdleTimeMillis = this.poolMinEvictableIdleTimeMillis;
        data.poolLifo = this.poolLifo;
        data.poolSoftMinEvictableTimeoutMillis = this.poolSoftMinEvictableTimeoutMillis;
        data.poolMaxTotalPreparedStatements = this.poolMaxTotalPreparedStatements;
        data.poolMaxActivePreparedStatements = this.poolMaxActivePreparedStatements;
        data.poolMaxIdlePreparedStatements = this.poolMaxIdlePreparedStatements;
        data.poolMinIdlePreparedStatements = this.poolMinIdlePreparedStatements;
        data.poolMaxWaitPreparedStatements = this.poolMaxWaitPreparedStatements;
        data.poolAbandonedLoggingEnabled = this.poolAbandonedLoggingEnabled;
        data.poolAbandonedRemovalEnabled = this.poolAbandonedRemovalEnabled;
        data.poolAbandonedRemovalTimeout = this.poolAbandonedRemovalTimeout;
        return data;
    }

    protected void copy(JdbcPoolConfig other) {
        this.poolEnabled = other.poolEnabled;
        this.poolConfigUri = other.poolConfigUri;
        this.poolPreparedStatementsAllowed = other.poolPreparedStatementsAllowed;
        this.poolValidationQueryTimeoutSecs = other.poolValidationQueryTimeoutSecs;
        this.poolMaxActiveConnections = other.poolMaxActiveConnections;
        this.poolMaxIdleConnections = other.poolMaxIdleConnections;
        this.poolMinIdleConnections = other.poolMinIdleConnections;
        this.poolMaxWaitForConnection = other.poolMaxWaitForConnection;
        this.poolExhaustedAction = other.poolExhaustedAction;
        this.poolTestOnBorrowEnabled = other.poolTestOnBorrowEnabled;
        this.poolTestOnReturnEnabled = other.poolTestOnReturnEnabled;
        this.poolTestWhileIdeEnabled = other.poolTestWhileIdeEnabled;
        this.poolTimeBetweenEvictionCheckMillis = other.poolTimeBetweenEvictionCheckMillis;
        this.poolNumberTestsPerEvictionRun = other.poolNumberTestsPerEvictionRun;
        this.poolMinEvictableIdleTimeMillis = other.poolMinEvictableIdleTimeMillis;
        this.poolLifo = other.poolLifo;
        this.poolSoftMinEvictableTimeoutMillis = other.poolSoftMinEvictableTimeoutMillis;
        this.poolMaxTotalPreparedStatements = other.poolMaxTotalPreparedStatements;
        this.poolMaxActivePreparedStatements = other.poolMaxActivePreparedStatements;
        this.poolMaxIdlePreparedStatements = other.poolMaxIdlePreparedStatements;
        this.poolMinIdlePreparedStatements = other.poolMinIdlePreparedStatements;
        this.poolMaxWaitPreparedStatements = other.poolMaxWaitPreparedStatements;
        this.poolAbandonedLoggingEnabled = other.poolAbandonedLoggingEnabled;
        this.poolAbandonedRemovalEnabled = other.poolAbandonedRemovalEnabled;
        this.poolAbandonedRemovalTimeout = other.poolAbandonedRemovalTimeout;
    }

    private void readPoolConfig(String configUri) {
        URI uri = null;
        if (Strings.isValid((String)configUri)) {
            if (!configUri.contains("://")) {
                uri = new File(configUri).toURI();
            } else {
                try {
                    uri = new URI(configUri);
                }
                catch (URISyntaxException ex) {
                    throw JdbcException.newJdbcException(ex, "Invalid pool config uri [%s]", configUri);
                }
            }
        }
        this.loadPoolConfig(uri);
    }

    private void loadPoolConfig(URI uri) {
        if (uri != null) {
            BufferedInputStream inputStream = null;
            Properties props = new Properties();
            try {
                try {
                    URL url = uri.toURL();
                    inputStream = new BufferedInputStream(url.openStream());
                    props.loadFromXML(inputStream);
                }
                catch (Exception ex) {
                    throw JdbcException.newJdbcException(ex, "Error reading user specified connection pool config uri [%s]", uri);
                }
            }
            catch (Throwable throwable) {
                Lib.close(inputStream);
                throw throwable;
            }
            Lib.close((Closeable)inputStream);
            this.setPoolAbandonedLoggingEnabled(JdbcPoolConfig.getBooleanObj(props, "logAbandoned", false));
            this.setPoolAbandonedRemovalEnabled(JdbcPoolConfig.getBooleanObj(props, "removeAbandoned", false));
            this.setPoolAbandonedRemovalTimeout(JdbcPoolConfig.getIntObj(props, "removeAbandonedTimeout", 300));
            this.setPoolExhaustedAction(JdbcConstants.PoolExhaustedAction.fromByte(JdbcPoolConfig.getByteObj(props, "whenExhaustedAction", JdbcConstants.DEFAULT_JDBC_POOL__WHEN_EXHAUSTED_ACTION.asByteValue())));
            this.setPoolLifo(JdbcPoolConfig.getBooleanObj(props, "lifo", true));
            this.setPoolMaxActiveConnections(JdbcPoolConfig.getIntObj(props, "maxActive", 10));
            this.setPoolMaxActivePreparedStatements(JdbcPoolConfig.getIntObj(props, "maxActivePreparedStatements", 20));
            this.setPoolMaxIdleConnections(JdbcPoolConfig.getIntObj(props, "maxIdle", 10));
            this.setPoolMaxIdlePreparedStatements(JdbcPoolConfig.getIntObj(props, "maxIdlePreparedStatements", 20));
            this.setPoolMaxTotalPreparedStatements(JdbcPoolConfig.getIntObj(props, "maxTotalPreparedStatements", 20));
            this.setPoolMaxWaitForConnection(JdbcPoolConfig.getLongObj(props, "maxWait", -1L));
            this.setPoolMaxWaitPreparedStatements(JdbcPoolConfig.getLongObj(props, "maxWaitPreparedStatements", -1L));
            this.setPoolMinEvictableIdleTimeMillis(JdbcPoolConfig.getLongObj(props, "minEvictableIdleTimeMillis", 60000L));
            this.setPoolMinIdleConnections(JdbcPoolConfig.getIntObj(props, "minIdle", 0));
            this.setPoolMinIdlePreparedStatements(JdbcPoolConfig.getIntObj(props, "minIdlePreparedStatements", 0));
            this.setPoolNumberTestsPerEvictionRun(JdbcPoolConfig.getIntObj(props, "numTestsPerEvictionRun", 1));
            this.setPoolPreparedStatementsAllowed(JdbcPoolConfig.getBooleanObj(props, "poolPreparedStatements", false));
            this.setPoolSoftMinEvictableTimeoutMillis(JdbcPoolConfig.getLongObj(props, "softMinEvictableIdleTimeMillis", -1L));
            this.setPoolTestOnBorrowEnabled(JdbcPoolConfig.getBooleanObj(props, "testOnBorrow", false));
            this.setPoolTestOnReturnEnabled(JdbcPoolConfig.getBooleanObj(props, "testOnReturn", false));
            this.setPoolTestWhileIdeEnabled(JdbcPoolConfig.getBooleanObj(props, "testWhileIdle", true));
            this.setPoolTimeBetweenEvictionCheckMillis(JdbcPoolConfig.getLongObj(props, "timeBetweenEvictionRunsMillis", 5000L));
            this.setPoolValidationQueryTimeoutSecs(JdbcPoolConfig.getIntObj(props, "validationQueryTimeoutSecs", 10));
        }
    }

    private static String getObj(Properties props, String key, String defaultValue) {
        String value = defaultValue;
        if (props != null) {
            value = props.getProperty(key, defaultValue);
            props.setProperty(key, value);
        }
        return value;
    }

    private static int getIntObj(Properties props, String key, int defaultValue) {
        return Integer.valueOf(JdbcPoolConfig.getObj(props, key, String.valueOf(defaultValue)));
    }

    private static long getLongObj(Properties props, String key, long defaultValue) {
        return Long.valueOf(JdbcPoolConfig.getObj(props, key, String.valueOf(defaultValue)));
    }

    private static boolean getBooleanObj(Properties props, String key, boolean defaultValue) {
        return Boolean.valueOf(JdbcPoolConfig.getObj(props, key, String.valueOf(defaultValue)));
    }

    private static byte getByteObj(Properties props, String key, byte defaultWhenExhaustedAction) {
        return Byte.valueOf(JdbcPoolConfig.getObj(props, key, String.valueOf(defaultWhenExhaustedAction)));
    }
}

