/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.eclipse.osee.framework.jdk.core.type.BaseId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcException;

public class JdbcDbType
extends BaseId {
    public static final JdbcDbType h2 = new JdbcDbType(1);
    public static final JdbcDbType oracle = new JdbcDbType(2);
    public static final JdbcDbType foxpro = new JdbcDbType(3);
    public static final JdbcDbType mysql = new JdbcDbType(4);
    public static final JdbcDbType postgresql = new JdbcDbType(5);
    public static final JdbcDbType hsql = new JdbcDbType(6);
    public static final JdbcDbType sqlite = new JdbcDbType(7);
    private final boolean hintsSupported;

    private JdbcDbType(int id) {
        this(Long.valueOf(id), false);
    }

    private JdbcDbType(Long id, boolean hintsSupported) {
        super(id);
        this.hintsSupported = hintsSupported;
    }

    public static JdbcDbType getDbType(JdbcConnection connection) {
        return JdbcDbType.getDbType(connection.getMetaData());
    }

    public static JdbcDbType getDbType(DatabaseMetaData metaData) {
        try {
            JdbcDbType dbType;
            String dbName = metaData.getDatabaseProductName();
            String lowerCaseName = dbName.toLowerCase();
            if (lowerCaseName.contains("h2")) {
                dbType = h2;
            } else if (lowerCaseName.contains("oracle")) {
                dbType = oracle;
            } else if (lowerCaseName.contains("foxpro")) {
                dbType = foxpro;
            } else if (lowerCaseName.contains("mysql")) {
                dbType = mysql;
            } else if (lowerCaseName.contains("postgresql")) {
                dbType = postgresql;
            } else if (lowerCaseName.contains("hsql")) {
                dbType = hsql;
            } else if (lowerCaseName.contains("sqlite")) {
                dbType = sqlite;
            } else {
                throw JdbcException.newJdbcException("Unsupported database type [%s] ", dbName);
            }
            boolean hintsSupported = dbType.equals((Object)oracle) && metaData.getDatabaseMajorVersion() > 10;
            return new JdbcDbType(dbType.getId(), hintsSupported);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    public boolean areHintsSupported() {
        return this.hintsSupported;
    }

    public String getRegularExpMatchSql() {
        if (this.equals((Object)oracle)) {
            return "REGEXP_LIKE (%s, %s)";
        }
        if (this.matches(new Id[]{postgresql, hsql})) {
            return "REGEXP_MATCHES (%s, %s)";
        }
        if (this.equals((Object)mysql)) {
            return "(%s REGEXP %s)";
        }
        throw JdbcException.newJdbcException("RegExp matching is not supported for db [%s]", new Object[]{this});
    }

    public String getRecursiveWithSql() {
        return this.equals((Object)oracle) ? "" : " RECURSIVE";
    }

    public String getComplementSql() {
        return this.equals((Object)oracle) ? "MINUS" : "EXCEPT";
    }

    public String getValidationSql() {
        if (this.matches(new Id[]{oracle, h2})) {
            return "select 1 from dual";
        }
        if (this.matches(new Id[]{hsql})) {
            return "SELECT 1 FROM INFORMATION_SCHEMA.SYSTEM_USERS";
        }
        return "select 1";
    }

    public String getConstraintCheckingSql(boolean enable) {
        String value;
        String cmd;
        if (this.equals((Object)h2)) {
            cmd = "SET REFERENTIAL_INTEGRITY = %s";
            value = Boolean.toString(enable).toUpperCase();
        } else if (this.equals((Object)hsql)) {
            cmd = "SET DATABASE REFERENTIAL INTEGRITY %s";
            value = Boolean.toString(enable).toUpperCase();
        } else {
            cmd = "SET CONSTRAINTS ALL %s";
            value = enable ? "IMMEDIATE" : "DEFERRED";
        }
        return String.format(cmd, value);
    }

    public String getFunctionCallSql(String function) {
        if (this.equals((Object)oracle)) {
            return String.format("{ ? = call %s }", function);
        }
        return String.format("call %s", function);
    }
}

