/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.app;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;

@Path(value="/api")
public final class OseeAppResource {
    private final OrcsApi orcsApi;

    public OseeAppResource(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    @GET
    @Produces(value={"application/json"})
    public Map<String, Long> getOseeAppListJson() {
        BranchId branchId = (BranchId)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andNameEquals("Common")).getResultsAsId().getExactlyOne();
        ResultSet apps = ((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch(branchId).andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.OseeApp})).getResults();
        HashMap<String, Long> results = new HashMap<String, Long>();
        for (ArtifactReadable art : apps) {
            results.put(art.getName(), art.getUuid());
        }
        return results;
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public String getOseeAppJson(@PathParam(value="id") Long id) {
        BranchId branchId = (BranchId)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andNameEquals("Common")).getResultsAsId().getExactlyOne();
        ArtifactReadable app = (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch(branchId).andId(ArtifactId.valueOf((long)id))).getResults().getExactlyOne();
        return app.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.OseeAppDefinition);
    }
}

