/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.util;

import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class ChangeTypeUtil {
    public static String getChangeTypeStr(ArtifactReadable artifact) throws OseeCoreException {
        ChangeType changeType = ChangeTypeUtil.getChangeType(artifact);
        if (changeType == ChangeType.None) {
            return "";
        }
        return changeType.name();
    }

    public static ChangeType getChangeType(ArtifactReadable artifact) throws OseeCoreException {
        return ChangeType.getChangeType((String)((String)artifact.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.ChangeType, (Object)"")));
    }

    public static ChangeType getChangeType(IAtsObject atsObject) throws OseeCoreException {
        return ChangeTypeUtil.getChangeType((ArtifactReadable)atsObject.getStoreObject());
    }

    public static void setChangeType(IAtsObject artifact, ChangeType changeType, IAtsChangeSet changes) throws OseeCoreException {
        if (changeType == ChangeType.None) {
            changes.deleteAttributes(artifact, (AttributeTypeId)AtsAttributeTypes.ChangeType);
        } else {
            changes.setSoleAttributeValue(artifact, (AttributeTypeId)AtsAttributeTypes.ChangeType, (Object)changeType.name());
        }
    }
}

