/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.util;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.jaxrs.mvc.IdentityView;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public abstract class AbstractConfigResource {
    protected final IAtsServer atsServer;
    private final IArtifactType artifactType;

    public AbstractConfigResource(IArtifactType artifactType, IAtsServer atsServer) {
        this.artifactType = artifactType;
        this.atsServer = atsServer;
    }

    @GET
    @IdentityView
    @Produces(value={"application/json"})
    public List<IAtsConfigObject> get() throws Exception {
        return this.getObjects();
    }

    @GET
    @Path(value="details")
    @Produces(value={"application/json"})
    public List<IAtsConfigObject> getObjectsJson() throws Exception {
        return this.getObjects();
    }

    @GET
    @Path(value="{uuid}")
    @IdentityView
    @Produces(value={"application/json"})
    public IAtsConfigObject getObjectJson(@PathParam(value="uuid") int uuid) throws Exception {
        return this.getObject(uuid);
    }

    @GET
    @Path(value="{uuid}/details")
    @Produces(value={"application/json"})
    public IAtsConfigObject getObjectDetails(@PathParam(value="uuid") int uuid) throws Exception {
        return this.getObject(uuid);
    }

    private IAtsConfigObject getObject(int uuid) {
        ArtifactReadable configArt = (ArtifactReadable)((QueryBuilder)this.atsServer.getQuery().andUuid((long)Integer.valueOf(uuid).intValue())).getResults().getExactlyOne();
        return this.atsServer.getConfigItemFactory().getConfigObject((ArtifactId)configArt);
    }

    private List<IAtsConfigObject> getObjects() {
        ArrayList<IAtsConfigObject> configs = new ArrayList<IAtsConfigObject>();
        for (ArtifactReadable art : ((QueryBuilder)this.atsServer.getQuery().andIsOfType(new ArtifactTypeId[]{this.artifactType})).getResults()) {
            configs.add(this.atsServer.getConfigItemFactory().getConfigObject((ArtifactId)art));
        }
        return configs;
    }
}

