/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.IAtsColumnId;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.column.AtsColumnId;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.data.ArtifactReadable;

@Path(value="world")
public class WorldResource {
    private final IAtsServer atsServer;
    public static final List<String> namespaces = Arrays.asList("org.eclipse.osee.ats.WorldXViewer", "org.eclipse.osee.ats.BacklogXViewer", "org.eclipse.osee.ats.SprintXViewer", "org.eclipse.osee.ats.GoalXViewer", "org.eclipse.osee.ats.TaskXViewer");

    public WorldResource(IAtsServer atsServer) {
        this.atsServer = atsServer;
    }

    @GET
    @Path(value="cust/global")
    @Produces(value={"application/json"})
    public Collection<CustomizeData> getCustomizationsGlobal() throws Exception {
        LinkedList<CustomizeData> datas = new LinkedList<CustomizeData>();
        for (String namespace : namespaces) {
            datas.addAll(this.atsServer.getCustomizationsGlobal(namespace));
        }
        return datas;
    }

    @GET
    @Path(value="cust")
    @Produces(value={"application/json"})
    public Collection<CustomizeData> getCustomizations() throws Exception {
        LinkedList<CustomizeData> datas = new LinkedList<CustomizeData>();
        for (String namespace : namespaces) {
            datas.addAll(this.atsServer.getCustomizations(namespace));
        }
        return datas;
    }

    @GET
    @Path(value="my/{uuid}")
    @Produces(value={"application/json"})
    public Collection<IAtsWorkItem> getMyWorld(@PathParam(value="uuid") int uuid) throws Exception {
        ArtifactReadable userArt = this.atsServer.getArtifact(Long.valueOf(uuid));
        IAtsUser userById = this.atsServer.getUserService().getUserById((String)userArt.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.UserId));
        Collection myWorldItems = this.atsServer.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andAssignee(new IAtsUser[]{userById}).getItems(IAtsWorkItem.class);
        return myWorldItems;
    }

    @GET
    @Path(value="my/{uuid}/ui")
    @Produces(value={"text/html"})
    public String getMyWorldUI(@PathParam(value="uuid") int uuid) throws Exception {
        StringBuilder sb = new StringBuilder();
        ArtifactReadable userArt = this.atsServer.getArtifact(Long.valueOf(uuid));
        IAtsUser userById = this.atsServer.getUserService().getUserById((String)userArt.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.UserId));
        Collection myWorldItems = this.atsServer.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andAssignee(new IAtsUser[]{userById}).getItems(IAtsWorkItem.class);
        this.getDefaultUiTable(uuid, sb, "My World - " + userById.getName(), myWorldItems);
        return sb.toString();
    }

    @GET
    @Path(value="my/{uuid}/ui/{customize_guid}")
    @Produces(value={"text/html"})
    public String getMyWorldUICustomized(@PathParam(value="uuid") int uuid, @PathParam(value="customize_guid") String customize_guid) throws Exception {
        ElapsedTime time = new ElapsedTime("start");
        ArtifactReadable userArt = this.atsServer.getArtifact(Long.valueOf(uuid));
        IAtsUser userById = this.atsServer.getUserService().getUserById((String)userArt.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.UserId));
        Conditions.checkNotNull((Object)userById, (String)("User by Id " + uuid));
        ElapsedTime getCustomization = new ElapsedTime("getCustomizationByGuid");
        CustomizeData customization = this.atsServer.getCustomizationByGuid(customize_guid);
        getCustomization.end();
        ElapsedTime getWorkItems = new ElapsedTime("get work items");
        Collection myWorldItems = this.atsServer.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andAssignee(new IAtsUser[]{userById}).getItems(IAtsWorkItem.class);
        getWorkItems.end();
        String table = WorldResource.getCustomizedTable(this.atsServer, "MY World - " + userById.getName() + " - Customization: " + customization.getName(), customization, myWorldItems);
        time.end();
        return table;
    }

    @GET
    @Path(value="coll/{uuid}")
    @Produces(value={"application/json"})
    public Collection<IAtsWorkItem> getCollection(@PathParam(value="uuid") long uuid) throws Exception {
        ArtifactReadable collectorArt = this.atsServer.getArtifact(uuid);
        return this.getCollection(collectorArt);
    }

    private Collection<IAtsWorkItem> getCollection(ArtifactReadable collectorArt) {
        ArrayList<IAtsWorkItem> myWorldItems = new ArrayList<IAtsWorkItem>();
        if (collectorArt != null) {
            if (collectorArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Goal})) {
                myWorldItems.addAll(this.atsServer.getWorkItemFactory().getWorkItems((Collection)collectorArt.getRelated(AtsRelationTypes.Goal_Member).getList()));
            } else if (collectorArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint})) {
                myWorldItems.addAll(this.atsServer.getWorkItemFactory().getWorkItems((Collection)collectorArt.getRelated(AtsRelationTypes.AgileSprintToItem_AtsItem).getList()));
            }
        }
        return myWorldItems;
    }

    @GET
    @Path(value="coll/{uuid}/ui")
    @Produces(value={"text/html"})
    public String getCollectionUI(@PathParam(value="uuid") long uuid) throws Exception {
        StringBuilder sb = new StringBuilder();
        ArtifactReadable collectorArt = this.atsServer.getArtifact(uuid);
        this.getDefaultUiTable(uuid, sb, "Collection - " + collectorArt.getName(), this.getCollection(uuid));
        return sb.toString();
    }

    @GET
    @Path(value="coll/{uuid}/ui/{customize_guid}")
    @Produces(value={"text/html"})
    public String getCollectionUICustomized(@PathParam(value="uuid") long uuid, @PathParam(value="customize_guid") String customize_guid) throws Exception {
        ElapsedTime time = new ElapsedTime("start");
        ElapsedTime getCustomization = new ElapsedTime("getCustomizationByGuid");
        CustomizeData customization = this.atsServer.getCustomizationByGuid(customize_guid);
        getCustomization.end();
        ElapsedTime getWorkItems = new ElapsedTime("get work items");
        ArtifactReadable collectorArt = this.atsServer.getArtifact(uuid);
        Collection<IAtsWorkItem> collectorItems = this.getCollection(collectorArt);
        getWorkItems.end();
        String table = WorldResource.getCustomizedTable(this.atsServer, "Collector - " + collectorArt.getName() + " - Customization: " + customization.getName(), customization, collectorItems);
        time.end();
        return table;
    }

    public static String getCustomizedTable(IAtsServer atsServer, String title, CustomizeData customization, Collection<IAtsWorkItem> workItems) {
        Conditions.checkNotNull((Object)customization, (String)("Customization " + customization + " "));
        StringBuilder sb = new StringBuilder();
        sb.append(AHTML.heading((int)2, (String)title));
        sb.append(AHTML.beginMultiColumnTable((int)97, (int)1));
        ArrayList<String> headers = new ArrayList<String>();
        for (XViewerColumn col : customization.getColumnData().getColumns()) {
            if (!col.isShow()) continue;
            headers.add(col.getName());
        }
        headers.add("Link");
        sb.append(AHTML.addHeaderRowMultiColumnTable(headers));
        AtsConfigurations configurations = atsServer.getConfigurations();
        for (IAtsWorkItem workItem : workItems) {
            ArrayList<String> rowStrs = new ArrayList<String>();
            ArrayList<String> colOptions = new ArrayList<String>();
            for (XViewerColumn col : customization.getColumnData().getColumns()) {
                if (!col.isShow()) continue;
                String text = "";
                if (Strings.isValid((String)col.getId())) {
                    text = atsServer.getColumnService().getColumnText(configurations, col.getId(), (IAtsObject)workItem);
                }
                rowStrs.add(text);
                colOptions.add("");
            }
            rowStrs.add(AHTML.getHyperlink((String)("/ats/ui/action/" + workItem.getAtsId()), (String)"open"));
            colOptions.add("");
            sb.append(AHTML.addRowMultiColumnTable((String[])rowStrs.toArray(new String[rowStrs.size()]), null));
        }
        sb.append(AHTML.endMultiColumnTable());
        return sb.toString();
    }

    private void getDefaultUiTable(long uuid, StringBuilder sb, String tableName, Collection<IAtsWorkItem> workItems) throws Exception {
        List<IAtsColumnId> columns = Arrays.asList(AtsColumnId.Team, AtsColumnId.State, AtsColumnId.Priority, AtsColumnId.ChangeType, AtsColumnId.Assignees, AtsColumnId.Title, AtsColumnId.ActionableItem, AtsColumnId.CreatedDate, AtsColumnId.TargetedVersion, AtsColumnId.Notes, AtsColumnId.AtsId);
        sb.append(AHTML.heading((int)2, (String)tableName));
        sb.append(AHTML.beginMultiColumnTable((int)97, (int)1));
        sb.append(AHTML.addHeaderRowMultiColumnTable(Arrays.asList("Team", "State", "Priority", "Change Type", "Assignee", "Title", "AI", "Created", "Targted Version", "Notes", "ID")));
        for (IAtsWorkItem workItem : workItems) {
            LinkedList<String> values = new LinkedList<String>();
            for (IAtsColumnId columnId : columns) {
                values.add(this.atsServer.getColumnService().getColumnText(columnId, (IAtsObject)workItem));
            }
            sb.append(AHTML.addRowMultiColumnTable((String[])values.toArray(new String[values.size()])));
        }
        sb.append(AHTML.endMultiColumnTable());
    }
}

