/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem.model;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.workflow.WorkItem;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class TeamWorkflow
extends WorkItem
implements IAtsTeamWorkflow {
    public TeamWorkflow(Log logger, IAtsServer atsServer, ArtifactReadable artifact) {
        super(logger, (IAtsServices)atsServer, (ArtifactToken)artifact);
    }

    public Set<IAtsActionableItem> getActionableItems() throws OseeCoreException {
        HashSet<IAtsActionableItem> ais = new HashSet<IAtsActionableItem>();
        for (Object aiGuidObj : ((ArtifactReadable)this.artifact).getAttributeValues((AttributeTypeId)AtsAttributeTypes.ActionableItem)) {
            String aiGuid = (String)aiGuidObj;
            IAtsActionableItem ai = (IAtsActionableItem)this.services.getConfigItem(aiGuid);
            if (ai == null) {
                ArtifactToken aiArt = this.services.getArtifactByGuid(aiGuid);
                ai = this.services.getConfigItemFactory().getActionableItem((ArtifactId)aiArt);
            }
            ais.add(ai);
        }
        return ais;
    }

    public IAtsTeamDefinition getTeamDefinition() throws OseeCoreException {
        IAtsTeamDefinition teamDef = null;
        String teamDefGuid = (String)((ArtifactReadable)this.artifact).getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.TeamDefinition);
        if (Strings.isValid((String)teamDefGuid)) {
            teamDef = (IAtsTeamDefinition)this.services.getConfigItem(teamDefGuid);
        }
        return teamDef;
    }
}

