/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Date;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsUtilCore;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.config.ConfigJsonWriter;
import org.eclipse.osee.ats.rest.internal.util.ActionPage;
import org.eclipse.osee.ats.rest.util.JsonFactory;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.jaxrs.mvc.IdentityView;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeTypes;

@Provider
public class WorkItemJsonWriter
implements MessageBodyWriter<IAtsWorkItem> {
    private org.codehaus.jackson.JsonFactory jsonFactory;
    private IAtsServer atsServer;
    private static final String ATS_UI_ACTION_PREFIX = "/ats/ui/action/UUID";

    public void setAtsServer(IAtsServer atsServer) {
        this.atsServer = atsServer;
    }

    public void start() {
        this.jsonFactory = JsonFactory.create();
    }

    public void stop() {
        this.jsonFactory = null;
    }

    public long getSize(IAtsWorkItem data, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        boolean assignableFrom = IAtsWorkItem.class.isAssignableFrom(type);
        return assignableFrom && MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType);
    }

    private boolean matches(Class<? extends Annotation> toMatch, Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().isAssignableFrom(toMatch)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private AttributeTypes getAttributeTypes() {
        return this.atsServer.getOrcsApi().getOrcsTypes().getAttributeTypes();
    }

    public void writeTo(IAtsWorkItem config, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JsonGenerator writer = null;
        try {
            writer = this.jsonFactory.createJsonGenerator(entityStream);
            writer.writeStartArray();
            WorkItemJsonWriter.addWorkItem(this.atsServer, config, annotations, writer, this.matches(IdentityView.class, annotations), this.getAttributeTypes());
            writer.writeEndArray();
        }
        finally {
            if (writer != null) {
                writer.flush();
            }
        }
    }

    protected static void addWorkItem(IAtsServer atsServer, IAtsWorkItem config, Annotation[] annotations, JsonGenerator writer, boolean identityView, AttributeTypes attributeTypes) throws IOException, JsonGenerationException, JsonProcessingException {
        ArtifactReadable action = (ArtifactReadable)config.getStoreObject();
        writer.writeStartObject();
        writer.writeNumberField("uuid", ConfigJsonWriter.getUuid((IAtsObject)config, atsServer).longValue());
        writer.writeStringField("Name", config.getName());
        String atsId = (String)action.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.AtsId, (Object)"");
        writer.writeStringField("AtsId", atsId);
        writer.writeStringField("ArtifactType", action.getArtifactType().getName());
        String actionUrl = AtsUtilCore.getActionUrl((String)atsId, (String)ATS_UI_ACTION_PREFIX, (IAtsServices)atsServer);
        writer.writeStringField("actionLocation", actionUrl);
        if (!identityView) {
            ConfigJsonWriter.addAttributeData(writer, attributeTypes, action);
            writer.writeStringField("TeamName", ActionPage.getTeamStr(atsServer, action));
            IAtsWorkItem workItem = atsServer.getWorkItemFactory().getWorkItem((ArtifactId)action);
            writer.writeStringField("Assignees", workItem.getStateMgr().getAssigneesStr());
            writer.writeStringField("ChangeType", action.getSoleAttributeAsString((AttributeTypeId)AtsAttributeTypes.ChangeType, ""));
            writer.writeStringField("Priority", action.getSoleAttributeAsString((AttributeTypeId)AtsAttributeTypes.PriorityType, ""));
            writer.writeStringField("State", workItem.getStateMgr().getCurrentStateName());
            writer.writeStringField("CreatedDate", DateUtil.get((Date)workItem.getCreatedDate(), (String)"MM/dd/yyyy"));
            writer.writeStringField("CreatedBy", workItem.getCreatedBy().getName());
            IAtsTeamWorkflow teamWf = workItem.getParentTeamWorkflow();
            if (teamWf != null) {
                String version = atsServer.getWorkItemService().getTargetedVersionStr(teamWf);
                writer.writeStringField("TargetedVersion", version);
            }
        }
        writer.writeEndObject();
    }
}

