/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.review.DecisionReview;
import org.eclipse.osee.ats.core.review.PeerToPeerReview;
import org.eclipse.osee.ats.core.workflow.AbstractWorkItemFactory;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.workitem.model.Action;
import org.eclipse.osee.ats.rest.internal.workitem.model.Goal;
import org.eclipse.osee.ats.rest.internal.workitem.model.Task;
import org.eclipse.osee.ats.rest.internal.workitem.model.TeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class WorkItemFactory
extends AbstractWorkItemFactory {
    private final IAtsServer atsServer;

    public WorkItemFactory(IAtsServer atsServer) {
        super((IAtsServices)atsServer);
        this.atsServer = atsServer;
    }

    public IAtsTeamWorkflow getTeamWf(ArtifactId artifact) throws OseeCoreException {
        TeamWorkflow team = null;
        if (artifact instanceof ArtifactReadable) {
            ArtifactReadable artRead = (ArtifactReadable)artifact;
            if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
                team = new TeamWorkflow(this.services.getLogger(), this.atsServer, (ArtifactReadable)artifact);
            }
        }
        return team;
    }

    public IAtsGoal getGoal(ArtifactId artifact) throws OseeCoreException {
        Goal goal = null;
        if (artifact instanceof ArtifactReadable) {
            ArtifactReadable artRead = (ArtifactReadable)artifact;
            if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Goal})) {
                goal = new Goal(this.services.getLogger(), this.atsServer, (ArtifactReadable)artifact);
            }
        }
        return goal;
    }

    public IAtsTask getTask(ArtifactId artifact) throws OseeCoreException {
        Task task = null;
        if (artifact instanceof ArtifactReadable) {
            ArtifactReadable artRead = (ArtifactReadable)artifact;
            if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task})) {
                task = new Task(this.services.getLogger(), this.atsServer, (ArtifactReadable)artifact);
            }
        }
        return task;
    }

    public IAtsAbstractReview getReview(ArtifactId artifact) throws OseeCoreException {
        Object review = null;
        if (artifact instanceof ArtifactReadable) {
            ArtifactReadable artRead = (ArtifactReadable)artifact;
            review = artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.PeerToPeerReview}) ? new PeerToPeerReview(this.services.getLogger(), this.services, (ArtifactToken)artRead) : new DecisionReview(this.services.getLogger(), this.services, (ArtifactToken)artRead);
        }
        return review;
    }

    public IAtsAction getAction(ArtifactId artifact) {
        Action action = null;
        if (artifact instanceof ArtifactReadable) {
            ArtifactReadable artRead = (ArtifactReadable)artifact;
            if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                action = new Action(this.atsServer, artRead);
            }
        }
        return action;
    }
}

