/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import java.util.Collection;
import java.util.Collections;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.transition.IAtsTransitionManager;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.workflow.transition.TransitionFactory;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelper;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.util.RestUtil;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;

@Path(value="action/state")
public final class StateResource {
    private final IAtsServer atsServer;
    private static final String ATS_UI_ACTION_PREFIX = "/ui/action/UUID";

    public StateResource(IAtsServer atsServer) {
        this.atsServer = atsServer;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Object addOrUpdateAction(MultivaluedMap<String, String> form, @Context UriInfo uriInfo) throws Exception {
        String id = (String)form.getFirst((Object)"guid");
        if (!Strings.isValid((String)id)) {
            id = (String)form.getFirst((Object)"atsId");
        }
        if (!Strings.isValid((String)id)) {
            return RestUtil.returnBadRequest("id is not valid");
        }
        String operation = (String)form.getFirst((Object)"operation");
        if (!Strings.isValid((String)operation)) {
            return RestUtil.returnBadRequest("operation is not valid");
        }
        String toState = (String)form.getFirst((Object)"toState");
        if (!Strings.isValid((String)toState)) {
            return RestUtil.returnBadRequest("toState is not valid");
        }
        String reason = (String)form.getFirst((Object)"reason");
        String asUserId = (String)form.getFirst((Object)"asUserId");
        if (!Strings.isValid((String)asUserId)) {
            return RestUtil.returnBadRequest("asUserId is not valid");
        }
        IAtsUser transitionUser = this.atsServer.getUserService().getUserById(asUserId);
        if (transitionUser == null) {
            return RestUtil.returnBadRequest(String.format("User by id [%s] does not exist", asUserId));
        }
        if (operation.equals("transition")) {
            ArtifactToken action = null;
            try {
                action = this.atsServer.getArtifactById(id);
            }
            catch (Exception exception) {}
            if (action == null) {
                return RestUtil.returnBadRequest(String.format("Action by id [%s] does not exist", id));
            }
            IAtsWorkItem workItem = this.atsServer.getWorkItemFactory().getWorkItem((ArtifactId)action);
            IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("Transition Action - Server", transitionUser);
            TransitionHelper helper = new TransitionHelper("Transition " + id, Collections.singleton(workItem), toState, (Collection)workItem.getAssignees(), reason, changes, this.atsServer.getServices(), new TransitionOption[]{TransitionOption.None});
            helper.setTransitionUser(transitionUser);
            IAtsTransitionManager mgr = TransitionFactory.getTransitionManager((ITransitionHelper)helper);
            TransitionResults results = mgr.handleAll();
            if (!results.isEmpty()) {
                return RestUtil.returnInternalServerError("Transition Failed: " + results.toString());
            }
            if (!changes.isEmpty()) {
                changes.execute();
            }
            return RestUtil.redirect(workItem, ATS_UI_ACTION_PREFIX, this.atsServer);
        }
        return RestUtil.returnBadRequest(String.format("Unhandled operation [%s]", operation));
    }
}

