/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.JaxAttribute;
import org.eclipse.osee.ats.api.task.JaxRelation;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskDatas;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class CreateTasksOperation {
    private XResultData resultData;
    private final NewTaskDatas newTaskDatas;
    private final IAtsServer atsServer;
    private IAtsUser asUser;
    private final List<JaxAtsTask> tasks = new ArrayList<JaxAtsTask>();
    private Date createdByDate;
    private Map<Long, IAtsTeamWorkflow> uuidToTeamWf;

    public CreateTasksOperation(NewTaskData newTaskData, IAtsServer atsServer, XResultData resultData) {
        this.newTaskDatas = new NewTaskDatas();
        this.newTaskDatas.add(newTaskData);
        this.atsServer = atsServer;
        this.resultData = resultData;
    }

    public CreateTasksOperation(NewTaskDatas newTaskDatas, IAtsServer atsServer, XResultData resultData) {
        this.newTaskDatas = newTaskDatas;
        this.atsServer = atsServer;
        this.resultData = resultData;
    }

    public XResultData validate() {
        if (this.resultData == null) {
            this.resultData = new XResultData(false);
        }
        this.uuidToTeamWf = new HashMap<Long, IAtsTeamWorkflow>();
        for (NewTaskData newTaskData : this.newTaskDatas.getTaskDatas()) {
            String asUserId;
            IAtsTeamWorkflow teamWf;
            Long teamWfUuid = newTaskData.getTeamWfUuid();
            if (teamWfUuid == null) {
                this.resultData.error("Team Workflow uuid not specified");
                continue;
            }
            ArtifactReadable teamWfArt = this.atsServer.getArtifact(teamWfUuid);
            if (teamWfArt == null) {
                this.resultData.errorf("Team Workflow uuid %d does not exist", new Object[]{teamWfUuid});
            }
            if ((teamWf = this.uuidToTeamWf.get(teamWfUuid)) == null) {
                teamWf = this.atsServer.getWorkItemFactory().getTeamWf((ArtifactId)teamWfArt);
                this.uuidToTeamWf.put(teamWfUuid, teamWf);
            }
            if ((asUserId = newTaskData.getAsUserId()) == null) {
                this.resultData.error("As User Id uuid not specified");
            }
            this.asUser = this.atsServer.getUserService().getUserById(asUserId);
            if (this.asUser == null) {
                this.resultData.errorf("As User Id uuid %d does not exist", new Object[]{asUserId});
            }
            if (!Strings.isValid((String)newTaskData.getCommitComment())) {
                this.resultData.errorf("Inavlidate Commit Comment [%s]", new Object[]{newTaskData.getCommitComment()});
            }
            for (JaxAtsTask task : newTaskData.getNewTasks()) {
                List assigneeUserIds;
                IAtsUser createdBy;
                ArtifactReadable taskArt;
                Long taskUuid = task.getUuid();
                if (taskUuid != null && taskUuid > 0L && (taskArt = this.atsServer.getArtifact(taskUuid)) != null) {
                    this.resultData.errorf("Task with uuid %d already exists for %s", new Object[]{taskUuid, task});
                }
                if (!Strings.isValid((String)task.getName())) {
                    this.resultData.errorf("Task name [%s] is invalid for %s", new Object[]{task.getName(), task});
                }
                if ((createdBy = this.atsServer.getUserService().getUserById(task.getCreatedByUserId())) == null) {
                    this.resultData.errorf("Task Created By user id %d does not exist in %s", new Object[]{createdBy, task});
                }
                this.createdByDate = task.getCreatedDate();
                if (this.createdByDate == null) {
                    this.resultData.errorf("Task Created By Date %s does not exist in %s", new Object[]{this.createdByDate, task});
                }
                IAtsTeamWorkflow teamWorkflow = this.atsServer.getWorkItemFactory().getTeamWf((ArtifactId)teamWfArt);
                String relatedToState = task.getRelatedToState();
                if (Strings.isValid((String)relatedToState) && teamWorkflow.getWorkDefinition().getStateByName(relatedToState) == null) {
                    this.resultData.errorf("Task Related To State %s invalid for Team Workflow %d", new Object[]{relatedToState, teamWfUuid});
                }
                if (!(assigneeUserIds = task.getAssigneeUserIds()).isEmpty()) {
                    Collection assignees = this.atsServer.getUserService().getUsersByUserIds((Collection)assigneeUserIds);
                    if (assigneeUserIds.size() != assignees.size()) {
                        this.resultData.errorf("Task Assignees [%s] not all valid in %s", new Object[]{String.valueOf(assigneeUserIds), task});
                    }
                }
                IAtsWorkDefinition workDefinition = null;
                if (Strings.isValid((String)task.getTaskWorkDef())) {
                    try {
                        XResultData rd = new XResultData();
                        workDefinition = this.atsServer.getWorkDefService().getWorkDef(task.getTaskWorkDef(), rd);
                        if (rd.isErrors()) {
                            this.resultData.errorf("Error finding Task Work Def [%s].  Exception: %s", new Object[]{task.getTaskWorkDef(), rd.toString()});
                        }
                    }
                    catch (Exception ex) {
                        this.resultData.errorf("Exception finding Task Work Def [%s].  Exception: %s", new Object[]{task.getTaskWorkDef(), ex.getMessage()});
                    }
                    if (workDefinition == null) {
                        this.resultData.errorf("Task Work Def [%s] does not exist", new Object[]{task.getTaskWorkDef()});
                    }
                }
                for (JaxAttribute attribute : task.getAttributes()) {
                    AttributeTypeToken attrType = CreateTasksOperation.getAttributeType(this.atsServer, attribute.getAttrTypeName());
                    if (attrType != null) continue;
                    this.resultData.errorf("Attribute Type [%s] not valid for Task creation in %s", new Object[]{attribute.getAttrTypeName(), task});
                }
                for (JaxRelation relation : task.getRelations()) {
                    RelationTypeToken relationType = this.getRelationType(this.atsServer, relation.getRelationTypeName());
                    if (relationType == null) {
                        this.resultData.errorf("Relation Type [%s] not valid for Task creation in %s", new Object[]{relation.getRelationTypeName(), task});
                    }
                    if (relation.getRelatedUuids().isEmpty()) {
                        this.resultData.errorf("Relation [%s] Uuids must be suplied Task creation in %s", new Object[]{relation.getRelationTypeName(), task});
                    }
                    Collection foundUuids = this.atsServer.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andUuids(relation.getRelatedUuids().toArray(new Long[relation.getRelatedUuids().size()])).getItemIds();
                    List notFoundUuids = relation.getRelatedUuids();
                    notFoundUuids.removeAll(foundUuids);
                    if (foundUuids.size() == relation.getRelatedUuids().size()) continue;
                    this.resultData.errorf("Relation [%s] Uuids [%s] do not match Work Items in task %s", new Object[]{relation.getRelationTypeName(), notFoundUuids, task});
                }
            }
        }
        return this.resultData;
    }

    private RelationTypeToken getRelationType(IAtsServer atsServer, String relationTypeName) {
        for (RelationTypeToken relation : atsServer.getOrcsApi().getOrcsTypes().getRelationTypes().getAll()) {
            if (!relation.getName().equals(relationTypeName)) continue;
            return relation;
        }
        return RelationTypeToken.SENTINEL;
    }

    private static AttributeTypeToken getAttributeType(IAtsServer atsServer, String attrTypeName) {
        for (AttributeTypeToken attrType : atsServer.getOrcsApi().getOrcsTypes().getArtifactTypes().getAttributeTypes(AtsArtifactTypes.Task, (BranchId)atsServer.getAtsBranch())) {
            if (!attrType.getName().equals(attrTypeName)) continue;
            return attrType;
        }
        return AttributeTypeToken.SENTINEL;
    }

    public List<JaxAtsTask> getTasks() {
        return this.tasks;
    }

    public void run() {
        XResultData results = this.validate();
        if (results.isErrors()) {
            throw new OseeArgumentException(results.toString(), new Object[0]);
        }
        IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet(((NewTaskData)this.newTaskDatas.getTaskDatas().iterator().next()).getCommitComment(), this.asUser);
        this.run(changes);
        changes.execute();
        for (NewTaskData newTaskData : this.newTaskDatas.getTaskDatas()) {
            for (JaxAtsTask jaxTask : newTaskData.getNewTasks()) {
                JaxAtsTask newJaxTask = CreateTasksOperation.createNewJaxTask(jaxTask.getUuid(), this.atsServer);
                if (newJaxTask == null) {
                    throw new OseeStateException("Unable to create return New Task for uuid " + jaxTask.getUuid(), new Object[0]);
                }
                this.tasks.add(newJaxTask);
            }
        }
    }

    public void run(IAtsChangeSet changes) {
        this.createTasks(changes);
        if (changes.isEmpty()) {
            throw new OseeStateException(String.valueOf(this.getClass().getSimpleName()) + " Error - No Tasks to Create", new Object[0]);
        }
    }

    private void createTasks(IAtsChangeSet changes) {
        for (NewTaskData newTaskData : this.newTaskDatas.getTaskDatas()) {
            for (JaxAtsTask jaxTask : newTaskData.getNewTasks()) {
                Long uuid = jaxTask.getUuid();
                if (uuid == null || uuid <= 0L) {
                    uuid = Lib.generateArtifactIdAsInt();
                    jaxTask.setUuid(uuid);
                }
                ArtifactToken taskArt = changes.createArtifact(AtsArtifactTypes.Task, jaxTask.getName(), GUID.create(), uuid);
                IAtsTask task = this.atsServer.getWorkItemFactory().getTask((ArtifactId)taskArt);
                IAtsTeamWorkflow teamWf = this.uuidToTeamWf.get(newTaskData.getTeamWfUuid());
                this.atsServer.getActionFactory().setAtsId((IAtsObject)task, teamWf.getTeamDefinition(), changes);
                changes.relate((Object)teamWf, AtsRelationTypes.TeamWfToTask_Task, (Object)taskArt);
                ArrayList<IAtsUser> assignees = new ArrayList<IAtsUser>();
                if (jaxTask.getAssigneeUserIds() != null) {
                    assignees.addAll(this.atsServer.getUserService().getUsersByUserIds((Collection)jaxTask.getAssigneeUserIds()));
                }
                if (assignees.isEmpty()) {
                    assignees.add(AtsCoreUsers.UNASSIGNED_USER);
                }
                IAtsWorkDefinition workDefinition = null;
                if (Strings.isValid((String)jaxTask.getTaskWorkDef())) {
                    try {
                        workDefinition = this.atsServer.getWorkDefService().getWorkDef(jaxTask.getTaskWorkDef(), new XResultData());
                    }
                    catch (Exception ex) {
                        throw new OseeArgumentException("Exception finding Task Work Def [%s]", new Object[]{jaxTask.getTaskWorkDef(), ex});
                    }
                }
                if (Strings.isValid((String)jaxTask.getDescription())) {
                    changes.setSoleAttributeValue((IAtsWorkItem)task, (AttributeTypeId)AtsAttributeTypes.Description, jaxTask.getDescription());
                }
                IAtsUser createdBy = this.atsServer.getUserService().getUserById(jaxTask.getCreatedByUserId());
                this.atsServer.getActionFactory().initializeNewStateMachine((IAtsWorkItem)task, assignees, this.createdByDate, createdBy, workDefinition, changes);
                if (Strings.isValid((String)jaxTask.getRelatedToState())) {
                    changes.setSoleAttributeValue((IAtsWorkItem)task, (AttributeTypeId)AtsAttributeTypes.RelatedToState, jaxTask.getRelatedToState());
                }
                for (JaxAttribute attribute : jaxTask.getAttributes()) {
                    AttributeTypeToken attrType = CreateTasksOperation.getAttributeType(this.atsServer, attribute.getAttrTypeName());
                    if (attrType.isInvalid()) {
                        this.resultData.errorf("Attribute Type [%s] not valid for Task creation in %s", new Object[]{attribute.getAttrTypeName(), task});
                    }
                    changes.setAttributeValues((IAtsObject)task, (AttributeTypeId)attrType, attribute.getValues());
                }
                for (JaxRelation relation : jaxTask.getRelations()) {
                    RelationTypeToken relationType = this.getRelationType(this.atsServer, relation.getRelationTypeName());
                    if (relationType == null) {
                        this.resultData.errorf("Relation Type [%s] not valid for Task creation in %s", new Object[]{relation.getRelationTypeName(), task});
                    }
                    Collection items = this.atsServer.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andUuids(relation.getRelatedUuids().toArray(new Long[relation.getRelatedUuids().size()])).getItems();
                    RelationTypeSide side = null;
                    side = relation.isSideA() ? new RelationTypeSide(relationType, RelationSide.SIDE_A) : new RelationTypeSide(relationType, RelationSide.SIDE_B);
                    changes.setRelations((Object)task, side, items);
                }
                changes.add((Object)taskArt);
            }
        }
    }

    public static JaxAtsTask createNewJaxTask(Long uuid, IAtsServer atsServer) {
        ArtifactReadable taskArt = atsServer.getArtifact(uuid);
        if (taskArt != null) {
            JaxAtsTask newJaxTask = new JaxAtsTask();
            newJaxTask.setName(taskArt.getName());
            newJaxTask.setDescription((String)taskArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Description, (Object)""));
            newJaxTask.setUuid(taskArt.getId());
            newJaxTask.setActive(true);
            String createdByUserId = (String)taskArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.CreatedBy, null);
            newJaxTask.setCreatedByUserId(createdByUserId);
            newJaxTask.setCreatedDate((Date)taskArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.CreatedDate));
            newJaxTask.setRelatedToState((String)taskArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.RelatedToState, (Object)""));
            IAtsWorkItem workItem = atsServer.getWorkItemFactory().getWorkItem((ArtifactId)taskArt);
            for (IAtsUser user : workItem.getAssignees()) {
                newJaxTask.getAssigneeUserIds().add(user.getUserId());
            }
            for (AttributeTypeToken type : taskArt.getExistingAttributeTypes()) {
                LinkedList attributeValues = new LinkedList();
                for (Object value : taskArt.getAttributeValues((AttributeTypeId)type)) {
                    attributeValues.add(value);
                }
                newJaxTask.addAttributes(type.getName(), attributeValues);
            }
            return newJaxTask;
        }
        return null;
    }
}

