/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.country.IAtsCountry;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.insertion.IAtsInsertion;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.api.insertion.JaxInsertion;
import org.eclipse.osee.ats.api.insertion.JaxInsertionActivity;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.core.config.AbstractConfigItemFactory;
import org.eclipse.osee.ats.core.config.ActionableItem;
import org.eclipse.osee.ats.core.config.Country;
import org.eclipse.osee.ats.core.config.Program;
import org.eclipse.osee.ats.core.config.TeamDefinition;
import org.eclipse.osee.ats.core.config.Version;
import org.eclipse.osee.ats.core.insertion.Insertion;
import org.eclipse.osee.ats.core.insertion.InsertionActivity;
import org.eclipse.osee.ats.core.model.WorkPackage;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class ConfigItemFactory
extends AbstractConfigItemFactory {
    private final Log logger;
    private final IAtsServer atsServer;

    public ConfigItemFactory(Log logger, IAtsServer atsServer) {
        this.logger = logger;
        this.atsServer = atsServer;
    }

    public IAtsConfigObject getConfigObject(ArtifactId artifact) throws OseeCoreException {
        IAtsVersion configObject = null;
        try {
            if (artifact instanceof ArtifactReadable) {
                ArtifactReadable artRead = (ArtifactReadable)artifact;
                if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Version})) {
                    configObject = this.getVersion(artifact);
                } else if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition})) {
                    configObject = this.getTeamDef((ArtifactId)artRead);
                } else if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.ActionableItem})) {
                    configObject = this.getActionableItem((ArtifactId)artRead);
                } else if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Program})) {
                    configObject = this.getProgram((ArtifactId)artRead);
                } else if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileTeam})) {
                    configObject = this.getAgileTeam((ArtifactId)artRead);
                } else if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileFeatureGroup})) {
                    configObject = this.getAgileFeatureGroup((ArtifactId)artRead);
                } else if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Insertion})) {
                    configObject = this.getInsertion((ArtifactId)artRead);
                } else if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.InsertionActivity})) {
                    configObject = this.getInsertionActivity((ArtifactId)artRead);
                } else if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Country})) {
                    configObject = this.getCountry((ArtifactId)artRead);
                } else if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.WorkPackage})) {
                    configObject = this.getWorkPackage((ArtifactId)artRead);
                }
            }
        }
        catch (OseeCoreException ex) {
            this.logger.error((Throwable)ex, "Error getting config object for [%s]", new Object[]{artifact});
        }
        return configObject;
    }

    public IAtsWorkPackage getWorkPackage(ArtifactId artifact) {
        WorkPackage workPackage = null;
        if (artifact instanceof ArtifactReadable) {
            ArtifactReadable art = (ArtifactReadable)artifact;
            if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.WorkPackage})) {
                workPackage = new WorkPackage(this.logger, (ArtifactToken)art, this.atsServer.getServices());
            }
        }
        return workPackage;
    }

    public IAtsVersion getVersion(ArtifactId artifact) {
        Version version = null;
        if (artifact instanceof ArtifactReadable) {
            ArtifactReadable artRead = (ArtifactReadable)artifact;
            if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Version})) {
                version = new Version(this.logger, (IAtsServices)this.atsServer, (ArtifactToken)artRead);
            }
        }
        return version;
    }

    public IAtsTeamDefinition getTeamDef(ArtifactId artifact) throws OseeCoreException {
        TeamDefinition teamDef = null;
        if (artifact instanceof ArtifactReadable) {
            ArtifactReadable artRead = (ArtifactReadable)artifact;
            if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition})) {
                teamDef = new TeamDefinition(this.logger, (IAtsServices)this.atsServer, (ArtifactToken)artRead);
            }
        }
        return teamDef;
    }

    public IAtsActionableItem getActionableItem(ArtifactId artifact) throws OseeCoreException {
        ActionableItem ai = null;
        if (artifact instanceof ArtifactReadable) {
            ArtifactReadable artRead = (ArtifactReadable)artifact;
            if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.ActionableItem})) {
                ai = new ActionableItem(this.logger, (IAtsServices)this.atsServer, (ArtifactToken)artRead);
            }
        }
        return ai;
    }

    public IAtsProgram getProgram(ArtifactId artifact) {
        Program program = null;
        if (artifact instanceof ArtifactReadable) {
            ArtifactReadable artRead = (ArtifactReadable)artifact;
            if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Program})) {
                program = new Program(this.logger, (IAtsServices)this.atsServer, (ArtifactToken)artRead);
            }
        }
        return program;
    }

    public IAgileTeam getAgileTeam(ArtifactId artifact) {
        IAgileTeam agileTeam = null;
        if (artifact instanceof ArtifactReadable) {
            ArtifactReadable artRead = (ArtifactReadable)artifact;
            if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileTeam})) {
                agileTeam = this.atsServer.getAgileService().getAgileTeam((ArtifactId)artRead);
            }
        }
        return agileTeam;
    }

    public IAgileFeatureGroup getAgileFeatureGroup(ArtifactId artifact) {
        IAgileFeatureGroup agileTeam = null;
        if (artifact instanceof ArtifactReadable) {
            ArtifactReadable artRead = (ArtifactReadable)artifact;
            if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileFeatureGroup})) {
                agileTeam = this.atsServer.getAgileService().getAgileFeatureGroup((ArtifactId)artRead);
            }
        }
        return agileTeam;
    }

    public IAtsInsertion getInsertion(ArtifactId artifact) {
        Insertion insertion = null;
        if (artifact instanceof ArtifactReadable) {
            ArtifactReadable artRead = (ArtifactReadable)artifact;
            if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Insertion})) {
                insertion = new Insertion(this.logger, this.atsServer.getServices(), (ArtifactToken)artRead);
                ArtifactReadable programArt = (ArtifactReadable)((ArtifactReadable)artifact).getRelated(AtsRelationTypes.ProgramToInsertion_Program).getOneOrNull();
                if (programArt != null) {
                    insertion.setProgramUuid(programArt.getId().longValue());
                }
            } else {
                throw new OseeCoreException("Requested uuid not Insertion", new Object[0]);
            }
        }
        return insertion;
    }

    public IAtsInsertionActivity getInsertionActivity(ArtifactId artifact) {
        InsertionActivity insertionActivity = null;
        if (artifact instanceof ArtifactReadable) {
            ArtifactReadable artRead = (ArtifactReadable)artifact;
            if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.InsertionActivity})) {
                insertionActivity = new InsertionActivity(this.logger, this.atsServer.getServices(), (ArtifactToken)artRead);
                ArtifactReadable insertionArt = (ArtifactReadable)((ArtifactReadable)artifact).getRelated(AtsRelationTypes.InsertionToInsertionActivity_Insertion).getOneOrNull();
                if (insertionArt != null) {
                    insertionActivity.setInsertionUuid(insertionArt.getId().longValue());
                }
            } else {
                throw new OseeCoreException("Requested uuid not Insertion Activity", new Object[0]);
            }
        }
        return insertionActivity;
    }

    public IAtsInsertion createInsertion(ArtifactId programArtifact, JaxInsertion newInsertion) {
        long uuid = newInsertion.getUuid();
        if (uuid <= 0L) {
            uuid = Lib.generateArtifactIdAsInt();
        }
        IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("Create new Insertion", this.atsServer.getUserService().getCurrentUser());
        ArtifactReadable insertionArt = (ArtifactReadable)changes.createArtifact(AtsArtifactTypes.Insertion, newInsertion.getName(), GUID.create(), Long.valueOf(uuid));
        changes.relate((Object)programArtifact, AtsRelationTypes.ProgramToInsertion_Insertion, (Object)insertionArt);
        changes.execute();
        return this.getInsertion((ArtifactId)insertionArt);
    }

    public IAtsInsertion updateInsertion(JaxInsertion updatedInsertion) {
        IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("Update Insertion", this.atsServer.getUserService().getCurrentUser());
        changes.setSoleAttributeValue(ArtifactId.valueOf((long)updatedInsertion.getUuid()), (AttributeTypeId)CoreAttributeTypes.Name, (Object)updatedInsertion.getName());
        changes.execute();
        return this.getInsertion((ArtifactId)((QueryBuilder)this.atsServer.getQuery().andUuid(updatedInsertion.getUuid().longValue())).getResults().getExactlyOne());
    }

    public void deleteInsertion(ArtifactId artifact) {
        this.deleteConfigObject(artifact.getId(), "Delete Insertion", AtsArtifactTypes.Insertion);
    }

    public IAtsInsertionActivity createInsertionActivity(ArtifactId insertion, JaxInsertionActivity newActivity) {
        long uuid = newActivity.getUuid();
        if (uuid <= 0L) {
            uuid = Lib.generateArtifactIdAsInt();
        }
        IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("Create new Insertion Activity", this.atsServer.getUserService().getCurrentUser());
        ArtifactReadable insertionActivityArt = (ArtifactReadable)changes.createArtifact(AtsArtifactTypes.InsertionActivity, newActivity.getName(), GUID.create(), Long.valueOf(uuid));
        changes.relate((Object)insertion, AtsRelationTypes.InsertionToInsertionActivity_InsertionActivity, (Object)insertionActivityArt);
        changes.execute();
        return this.getInsertionActivity((ArtifactId)insertionActivityArt);
    }

    public IAtsInsertionActivity updateInsertionActivity(JaxInsertionActivity updatedActivity) {
        IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("Update Insertion", this.atsServer.getUserService().getCurrentUser());
        ArtifactReadable insertionActivityArt = (ArtifactReadable)((QueryBuilder)this.atsServer.getQuery().andUuid(updatedActivity.getUuid().longValue())).getResults().getExactlyOne();
        changes.setSoleAttributeValue((ArtifactId)insertionActivityArt, (AttributeTypeId)CoreAttributeTypes.Name, (Object)updatedActivity.getName());
        changes.setSoleAttributeValue(ArtifactId.valueOf((long)updatedActivity.getUuid()), (AttributeTypeId)CoreAttributeTypes.Name, (Object)updatedActivity.getName());
        changes.execute();
        return this.getInsertionActivity((ArtifactId)((QueryBuilder)this.atsServer.getQuery().andUuid(updatedActivity.getUuid().longValue())).getResults().getExactlyOne());
    }

    public void deleteInsertionActivity(ArtifactId artifact) {
        this.deleteConfigObject(artifact.getId(), "Delete Insertion Activity", AtsArtifactTypes.InsertionActivity);
    }

    private void deleteConfigObject(long uuid, String comment, IArtifactType type) {
        ArtifactReadable toDelete = this.atsServer.getArtifact(uuid);
        if (toDelete == null) {
            throw new OseeCoreException("No object found for uuid %d", new Object[]{uuid});
        }
        if (!toDelete.getArtifactType().equals(type)) {
            throw new OseeCoreException("Artifact type does not match for %s", new Object[]{comment});
        }
        TransactionBuilder transaction = this.atsServer.getOrcsApi().getTransactionFactory().createTransaction((BranchId)this.atsServer.getAtsBranch(), (ArtifactId)toDelete, comment);
        transaction.deleteArtifact((ArtifactId)toDelete);
        transaction.commit();
    }

    public boolean isAtsConfigArtifact(ArtifactId artifact) {
        return this.getAtsConfigArtifactTypes().contains(((ArtifactReadable)artifact).getArtifactType());
    }

    public IAtsCountry getCountry(ArtifactId artifact) {
        Country country = null;
        if (artifact instanceof ArtifactReadable) {
            ArtifactReadable artRead = (ArtifactReadable)artifact;
            if (artRead.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Country})) {
                country = new Country(this.logger, this.atsServer.getServices(), (ArtifactToken)artRead);
            } else {
                throw new OseeCoreException("Requested uuid not Country", new Object[0]);
            }
        }
        return country;
    }
}

