/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.ev.AtsWorkPackageEndpointApi;
import org.eclipse.osee.ats.api.ev.JaxWorkPackageData;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.ColorTeam;
import org.eclipse.osee.ats.api.util.ColorTeams;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class AtsWorkPackageEndpointImpl
implements AtsWorkPackageEndpointApi {
    private static final String COLOR_TEAM_KEY = "colorTeam";
    private final IAtsServer atsServer;
    private final Gson gson;
    private final Log logger;

    public AtsWorkPackageEndpointImpl(IAtsServer atsServer, Log logger) {
        this.atsServer = atsServer;
        this.logger = logger;
        this.gson = new GsonBuilder().create();
    }

    @GET
    @Path(value="{workPackageId}/workitem")
    @Produces(value={"application/json"})
    public Collection<IAtsWorkItem> getWorkItems(@PathParam(value="workPackageId") long workPackageId) {
        ArtifactReadable workPackageArt = this.atsServer.getArtifact(workPackageId);
        if (workPackageArt == null) {
            throw new OseeArgumentException("Work Package with id [%s] Not Found", new Object[]{workPackageId});
        }
        return this.atsServer.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andAttr((AttributeTypeId)AtsAttributeTypes.WorkPackageGuid, (String)workPackageArt.getGuid(), new QueryOption[0]).getResults().getList();
    }

    @PUT
    @Path(value="{workPackageId}")
    @Consumes(value={"application/json"})
    public Response setWorkPackage(@PathParam(value="workPackageId") long workPackageId, JaxWorkPackageData workPackageData) {
        ArtifactReadable workPackageArt = this.atsServer.getArtifact(workPackageId);
        if (workPackageArt == null) {
            throw new OseeArgumentException("Work Package with id [%s] Not Found", new Object[]{workPackageId});
        }
        IAtsUser asUser = this.atsServer.getUserService().getUserById(workPackageData.getAsUserId());
        if (asUser == null) {
            throw new OseeArgumentException("Author with id [%s] Not Found", new Object[]{workPackageData.getAsUserId()});
        }
        IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("Set Work Package", asUser);
        for (Long workItemUuid : workPackageData.getWorkItemUuids()) {
            IAtsWorkItem workItem = (IAtsWorkItem)this.atsServer.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andUuids(new Long[]{workItemUuid}).getResults().getAtMostOneOrNull();
            if (workItem == null) {
                throw new OseeArgumentException("Work Item with id [%s] Not Found", new Object[]{workItemUuid});
            }
            if (!workItem.isTask() && !workItem.isTeamWorkflow()) {
                throw new OseeArgumentException("Work Packages can only be set on Team Workflow or Task, not [%s]", new Object[]{workItem.getArtifactTypeName()});
            }
            changes.setSoleAttributeValue(workItem, (AttributeTypeId)AtsAttributeTypes.WorkPackageGuid, (String)workPackageArt.getGuid());
            this.autoAddWorkItemToColorTeamGoals(this.getColorTeams(), workPackageArt, workPackageId, workItem, changes);
        }
        if (!changes.isEmpty()) {
            changes.execute();
        }
        return Response.ok().build();
    }

    private void autoAddWorkItemToColorTeamGoals(ColorTeams colorTeams, ArtifactReadable workPackageArt, long workPackageId, IAtsWorkItem workItem, IAtsChangeSet changes) {
        try {
            String workPackageColorTeam = (String)this.atsServer.getAttributeResolver().getSoleAttributeValue((ArtifactId)workPackageArt, (AttributeTypeId)AtsAttributeTypes.ColorTeam, null);
            if (Strings.isValid((String)workPackageColorTeam)) {
                for (ColorTeam colorTeam : colorTeams.getTeams()) {
                    if (colorTeam.getGoalUuids().isEmpty() || !colorTeam.getName().equals(workPackageColorTeam)) continue;
                    for (Long uuid : colorTeam.getGoalUuids()) {
                        ArtifactReadable goalArt = this.atsServer.getArtifact(uuid);
                        if (goalArt != null) {
                            IAtsWorkItem goalWorkItem = this.atsServer.getWorkItemFactory().getWorkItem((ArtifactId)goalArt);
                            if (this.atsServer.getRelationResolver().areRelated((IAtsObject)goalWorkItem, AtsRelationTypes.Goal_Member, (IAtsObject)workItem)) continue;
                            changes.relate((Object)goalWorkItem, AtsRelationTypes.Goal_Member, (Object)workItem);
                            continue;
                        }
                        this.logger.error("Goal Uuid [%d] invalid in Color Team [%s] for Work Package [%s] Work Item [%s]; Skipping...", new Object[]{uuid, colorTeam, workPackageArt.toStringWithId(), workItem.toStringWithId()});
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, "Error adding Work ITem to Color Team goals. Color Teams [%s] Work Package [%s] Work Item [%s]", new Object[]{colorTeams, workPackageArt.toStringWithId(), workItem.toStringWithId()});
        }
    }

    @GET
    @Path(value="colorteam")
    @Produces(value={"application/json"})
    public ColorTeams getColorTeams() {
        String colorTeamStr = this.atsServer.getConfigValue(COLOR_TEAM_KEY);
        ColorTeams teams = null;
        teams = Strings.isValid((String)colorTeamStr) ? (ColorTeams)this.gson.fromJson(colorTeamStr, ColorTeams.class) : new ColorTeams();
        return teams;
    }

    @DELETE
    @Path(value="{workPackageId}/workitem")
    @Consumes(value={"application/json"})
    public Response deleteWorkPackageItems(@PathParam(value="workPackageId") long workPackageId, JaxWorkPackageData workPackageData) {
        IAtsUser asUser = this.atsServer.getUserService().getUserById(workPackageData.getAsUserId());
        if (asUser == null) {
            throw new OseeArgumentException("Author with id [%s] Not Found", new Object[]{workPackageData.getAsUserId()});
        }
        IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("Remove Work Package", asUser);
        for (Long workItemUuid : workPackageData.getWorkItemUuids()) {
            IAtsWorkItem workItem = (IAtsWorkItem)this.atsServer.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andUuids(new Long[]{workItemUuid}).getResults().getAtMostOneOrNull();
            if (workItem == null) {
                throw new OseeArgumentException("Work Item with id [%s] Not Found", new Object[]{workItemUuid});
            }
            if (this.atsServer.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.WorkPackageGuid, null) == null) continue;
            changes.deleteAttributes((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.WorkPackageGuid);
        }
        if (!changes.isEmpty()) {
            changes.execute();
        }
        return Response.ok().build();
    }
}

