/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.task.AbstractAtsTaskService;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskDatas;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.workitem.CreateTasksOperation;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;

public class AtsTaskService
extends AbstractAtsTaskService {
    private final IAtsServer atsServer;

    public AtsTaskService(IAtsServer atsServer) {
        super(atsServer.getServices());
        this.atsServer = atsServer;
    }

    public Collection<IAtsTask> createTasks(NewTaskData newTaskData) {
        IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet(newTaskData.getCommitComment(), AtsCoreUsers.SYSTEM_USER);
        return this.createTasks(newTaskData, changes);
    }

    public Collection<IAtsTask> createTasks(NewTaskData newTaskData, IAtsChangeSet changes) {
        CreateTasksOperation operation = new CreateTasksOperation(newTaskData, this.atsServer, new XResultData());
        XResultData results = operation.validate();
        operation.run(changes);
        if (results.isErrors()) {
            throw new OseeStateException("Error creating tasks - " + results.toString(), new Object[0]);
        }
        LinkedList<IAtsTask> tasks = new LinkedList<IAtsTask>();
        for (JaxAtsTask task : operation.getTasks()) {
            tasks.add(this.atsServer.getWorkItemFactory().getTask((ArtifactId)this.atsServer.getArtifact(task.getUuid())));
        }
        return tasks;
    }

    public Collection<IAtsTask> createTasks(NewTaskDatas newTaskDatas) {
        CreateTasksOperation operation = new CreateTasksOperation(newTaskDatas, this.atsServer, new XResultData());
        XResultData results = operation.validate();
        if (results.isErrors()) {
            throw new OseeStateException("Error validating task creation - " + results.toString(), new Object[0]);
        }
        operation.run();
        if (results.isErrors()) {
            throw new OseeStateException("Error creating tasks - " + results.toString(), new Object[0]);
        }
        LinkedList<IAtsTask> tasks = new LinkedList<IAtsTask>();
        for (JaxAtsTask task : operation.getTasks()) {
            tasks.add(this.atsServer.getWorkItemFactory().getTask((ArtifactId)this.atsServer.getArtifact(task.getUuid())));
        }
        return tasks;
    }

    public Collection<IAtsTask> createTasks(IAtsTeamWorkflow teamWf, List<String> titles, List<IAtsUser> assignees, Date createdDate, IAtsUser createdBy, String relatedToState, String taskWorkDef, Map<String, List<Object>> attributes, IAtsChangeSet changes) {
        NewTaskData tasks = this.atsServer.getTaskService().getNewTaskData(teamWf, titles, assignees, createdDate, createdBy, relatedToState, taskWorkDef, attributes, changes.getComment());
        return this.createTasks(tasks, changes);
    }
}

