/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.task.AtsTaskEndpointApi;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.JaxAtsTasks;
import org.eclipse.osee.ats.api.task.NewTaskDatas;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.workitem.CreateTasksOperation;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public class AtsTaskEndpointImpl
implements AtsTaskEndpointApi {
    private final IAtsServer atsServer;

    public AtsTaskEndpointImpl(IAtsServer atsServer) {
        this.atsServer = atsServer;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(NewTaskDatas newTaskDatas) {
        CreateTasksOperation operation = new CreateTasksOperation(newTaskDatas, this.atsServer, new XResultData());
        XResultData results = operation.validate();
        if (results.isErrors()) {
            throw new OseeArgumentException(results.toString(), new Object[0]);
        }
        operation.run();
        JaxAtsTasks tasks = new JaxAtsTasks();
        tasks.getTasks().addAll(operation.getTasks());
        return Response.ok().entity((Object)tasks).build();
    }

    @GET
    @Path(value="{taskUuid}")
    public Response get(@PathParam(value="taskUuid") long taskUuid) {
        IAtsWorkItem task = (IAtsWorkItem)this.atsServer.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).isOfType(new WorkItemType[]{WorkItemType.Task}).andUuids(new Long[]{taskUuid}).getResults().getOneOrNull();
        if (task == null) {
            throw new OseeArgumentException("No Task found with id %d", new Object[]{taskUuid});
        }
        JaxAtsTask jaxAtsTask = CreateTasksOperation.createNewJaxTask(task.getId(), this.atsServer);
        return Response.ok().entity((Object)jaxAtsTask).build();
    }

    @DELETE
    @Path(value="{taskUuid}")
    public void delete(@PathParam(value="taskUuid") long taskUuid) {
        IAtsWorkItem task = (IAtsWorkItem)this.atsServer.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).isOfType(new WorkItemType[]{WorkItemType.Task}).andUuids(new Long[]{taskUuid}).getResults().getOneOrNull();
        if (task != null) {
            IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("Delete Task", AtsCoreUsers.SYSTEM_USER);
            changes.deleteArtifact(task);
            changes.execute();
        }
    }
}

