/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.rule.JaxRuleDefinitions;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.AddRuleData;
import org.eclipse.osee.ats.api.workdef.IAtsRuleDefinition;
import org.eclipse.osee.ats.api.workdef.RunRuleData;
import org.eclipse.osee.ats.api.workdef.RunRuleResults;
import org.eclipse.osee.ats.api.workflow.AtsRuleEndpointApi;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.util.WorkflowRuleRunner;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class AtsRuleEndpointImpl
implements AtsRuleEndpointApi {
    private final IAtsServer atsServer;

    public AtsRuleEndpointImpl(IAtsServer atsServer) {
        this.atsServer = atsServer;
    }

    @GET
    @Path(value="rule")
    @Produces(value={"application/json"})
    public JaxRuleDefinitions get() throws Exception {
        JaxRuleDefinitions rules = new JaxRuleDefinitions();
        for (IAtsRuleDefinition rule : this.atsServer.getWorkDefAdmin().getAllRuleDefinitions()) {
            rules.getRules().add(rule);
        }
        return rules;
    }

    @POST
    @Path(value="rulerun")
    public RunRuleResults runWorkflowRules(RunRuleData runRuleData) {
        RunRuleResults ruleResults = new RunRuleResults();
        LinkedList<IAtsWorkItem> workItemsCreated = new LinkedList<IAtsWorkItem>();
        Iterator iterator = runRuleData.getWorkItemUuids().iterator();
        while (iterator.hasNext()) {
            long workflowUuid = (Long)iterator.next();
            ArtifactReadable artifact = this.atsServer.getArtifact(workflowUuid);
            IAtsWorkItem workItem = this.atsServer.getWorkItemFactory().getWorkItem((ArtifactId)artifact);
            if (workItem == null) {
                throw new OseeArgumentException("Workflow of uuid [%d] does not exist", new Object[]{workflowUuid});
            }
            if (!workItem.isTeamWorkflow()) {
                throw new OseeArgumentException("Workflow of uuid [%d] is not a Team Workflow", new Object[]{workflowUuid});
            }
            workItemsCreated.add(workItem);
        }
        if (!workItemsCreated.isEmpty()) {
            WorkflowRuleRunner runner = new WorkflowRuleRunner(runRuleData.getRuleEventType(), workItemsCreated, this.atsServer, ruleResults);
            runner.run();
        }
        return ruleResults;
    }

    @POST
    @Path(value="rule")
    public Response addRuleToConfig(AddRuleData setRuleData) {
        ArtifactReadable artifact = this.atsServer.getArtifact(setRuleData.getConfigItemUuid());
        List ruleList = artifact.getAttributeValues((AttributeTypeId)AtsAttributeTypes.RuleDefinition);
        if (!ruleList.contains(setRuleData.getRuleName())) {
            IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("Update artifact with Rule", AtsCoreUsers.SYSTEM_USER);
            changes.addAttribute((IAtsObject)this.atsServer.getConfigItemFactory().getConfigObject((ArtifactId)artifact), (AttributeTypeId)AtsAttributeTypes.RuleDefinition, (Object)setRuleData.getRuleName());
            changes.execute();
            IAtsConfigObject atsObject = (IAtsConfigObject)this.atsServer.getCache().getAtsObject(setRuleData.getConfigItemUuid());
            this.atsServer.getCache().deCacheAtsObject((IAtsObject)atsObject);
        }
        return Response.ok().build();
    }
}

