/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.AtsActionEndpointApi;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.util.RestUtil;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.mvc.IdentityView;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

@Path(value="action")
public final class AtsActionEndpointImpl
implements AtsActionEndpointApi {
    private final IAtsServer atsServer;
    private final OrcsApi orcsApi;
    private static final String ATS_UI_ACTION_PREFIX = "/ui/action/UUID";

    public AtsActionEndpointImpl(IAtsServer atsServer, OrcsApi orcsApi) {
        this.atsServer = atsServer;
        this.orcsApi = orcsApi;
    }

    @GET
    @Produces(value={"text/html"})
    public String get() throws Exception {
        return RestUtil.simplePageHtml("Action Resource");
    }

    @Path(value="{ids}")
    @IdentityView
    @GET
    public List<IAtsWorkItem> getAction(@PathParam(value="ids") String ids) throws Exception {
        List<IAtsWorkItem> workItems = this.atsServer.getWorkItemListByIds(ids);
        return workItems;
    }

    @Path(value="{ids}/details")
    @GET
    @Produces(value={"application/json"})
    public List<IAtsWorkItem> getActionDetails(@PathParam(value="ids") String ids) throws Exception {
        List<IAtsWorkItem> workItems = this.atsServer.getWorkItemListByIds(ids);
        return workItems;
    }

    @Path(value="query")
    @GET
    @Produces(value={"application/json"})
    public Set<IAtsWorkItem> query(@Context UriInfo uriInfo) throws Exception {
        MultivaluedMap queryParameters = uriInfo.getQueryParameters(true);
        HashSet<IAtsWorkItem> workItems = new HashSet<IAtsWorkItem>();
        for (String key : queryParameters.keySet()) {
            AttributeTypeToken attrType = null;
            Long attrTypeId = Strings.isNumeric((String)key) ? Long.valueOf(key) : null;
            for (AttributeTypeToken type : this.atsServer.getOrcsApi().getOrcsTypes().getAttributeTypes().getAll()) {
                if (attrTypeId != null && type.equals(attrTypeId)) {
                    attrType = type;
                    break;
                }
                if (!type.getName().equals(key)) continue;
                attrType = type;
                break;
            }
            if (attrType == null) continue;
            for (String value : (List)queryParameters.get((Object)key)) {
                for (ArtifactReadable artifactReadable : ((QueryBuilder)this.atsServer.getOrcsApi().getQueryFactory().fromBranch((BranchId)this.atsServer.getAtsBranch()).and((AttributeTypeId)attrType, value, new QueryOption[0])).getResults()) {
                    IAtsWorkItem workItem;
                    if (!artifactReadable.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact}) || (workItem = this.atsServer.getWorkItemFactory().getWorkItem((ArtifactId)artifactReadable)) == null) continue;
                    workItems.add(workItem);
                }
            }
        }
        return workItems;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response createAction(MultivaluedMap<String, String> form) throws Exception {
        String title = (String)form.getFirst((Object)"ats_title");
        if (!Strings.isValid((String)title)) {
            return RestUtil.returnBadRequest("title is not valid");
        }
        String description = (String)form.getFirst((Object)"desc");
        String actionableItems = (String)form.getFirst((Object)"actionableItems");
        if (!Strings.isValid((String)actionableItems)) {
            return RestUtil.returnBadRequest("actionableItems is not valid");
        }
        ArrayList<IAtsActionableItem> aias = new ArrayList<IAtsActionableItem>();
        ArtifactReadable aiArt = (ArtifactReadable)((QueryBuilder)((QueryBuilder)this.atsServer.getQuery().andTypeEquals(new ArtifactTypeId[]{AtsArtifactTypes.ActionableItem})).andNameEquals(actionableItems)).getResults().getOneOrNull();
        if (aiArt == null) {
            return RestUtil.returnBadRequest(String.format("actionableItems [%s] is not valid", actionableItems));
        }
        IAtsActionableItem aia = (IAtsActionableItem)this.atsServer.getCache().getAtsObject(aiArt.getId());
        aias.add(aia);
        String userId = (String)form.getFirst((Object)"userId");
        if (!Strings.isValid((String)userId)) {
            return RestUtil.returnBadRequest("userId is not valid");
        }
        IAtsUser atsUser = this.atsServer.getUserService().getUserById(userId);
        if (atsUser == null) {
            return RestUtil.returnBadRequest(String.format("userId [%s] is not valid", userId));
        }
        String changeTypeStr = (String)form.getFirst((Object)"changeType");
        if (!Strings.isValid((String)changeTypeStr)) {
            return RestUtil.returnBadRequest("changeType is not valid");
        }
        IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("Create Action - Server", atsUser);
        this.orcsApi.getTransactionFactory().createTransaction((BranchId)this.atsServer.getAtsBranch(), (ArtifactId)atsUser.getStoreObject(), "Create Action - Server");
        ChangeType changeType = null;
        try {
            changeType = ChangeType.valueOf((String)changeTypeStr);
        }
        catch (Exception exception) {
            return RestUtil.returnBadRequest(String.format("changeType [%s] is not valid", changeTypeStr));
        }
        String priority = (String)form.getFirst((Object)"priority");
        if (!Strings.isValid((String)priority)) {
            return RestUtil.returnBadRequest("priority is not valid");
        }
        if (!priority.matches("[0-5]{1}")) {
            return RestUtil.returnBadRequest(String.format("priority [%s] is not valid", priority));
        }
        ActionResult action = this.atsServer.getActionFactory().createAction(atsUser, title, description, changeType, priority, false, null, aias, new Date(), atsUser, null, changes);
        changes.execute();
        return RestUtil.redirect(action.getTeamWfs(), ATS_UI_ACTION_PREFIX, this.atsServer);
    }
}

