/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.util.ActionPage;
import org.eclipse.osee.ats.rest.internal.util.RestUtil;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ViewModel;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

@Path(value="/ui/action")
public final class ActionUiResource {
    private final IAtsServer atsServer;
    private final Log logger;

    public ActionUiResource(IAtsServer atsServer, Log logger) {
        this.atsServer = atsServer;
        this.logger = logger;
    }

    @GET
    @Produces(value={"text/html"})
    public String get() throws Exception {
        return RestUtil.simplePageHtml("ATS UI Resource");
    }

    @Path(value="{ids}")
    @GET
    @Produces(value={"text/html"})
    public ViewModel getAction(@PathParam(value="ids") String ids) throws Exception {
        List<IAtsWorkItem> workItems = this.atsServer.getWorkItemListByIds(ids);
        if (workItems.isEmpty()) {
            return RestUtil.simplePage(String.format("Action with id(s) [%s] can not be found", ids));
        }
        if (workItems.size() == 1) {
            ActionPage page = new ActionPage(this.logger, this.atsServer, (ArtifactReadable)workItems.iterator().next().getStoreObject(), false);
            return page.generate();
        }
        String idStr = "";
        for (IAtsWorkItem workItem : workItems) {
            idStr = String.valueOf(idStr) + workItem.getAtsId() + ",";
        }
        idStr = idStr.replaceFirst(",$", "");
        String url = "/ats/action/" + idStr + "/details";
        return new ViewModel("templates/world.html").param("PUT_ACTION_JSON_URL_HERE", (Object)url);
    }

    @Path(value="{id}/details")
    @GET
    @Produces(value={"text/html"})
    public ViewModel getActionWithDetails(@PathParam(value="id") String id) throws Exception {
        ArtifactReadable action = (ArtifactReadable)this.atsServer.getArtifactById(id);
        if (action == null) {
            return RestUtil.simplePage(String.format("Action with id [%s] can not be found", id));
        }
        ActionPage page = new ActionPage(this.logger, this.atsServer, action, true);
        return page.generate();
    }

    @Path(value="NewAction")
    @GET
    @Produces(value={"text/html"})
    public ViewModel getNewSource() throws Exception {
        ArrayList<ArtifactReadable> sortedAis = new ArrayList<ArtifactReadable>();
        for (ArtifactReadable ai : this.getAis()) {
            sortedAis.add(ai);
        }
        Collections.sort(sortedAis, new IdComparator());
        return new ViewModel("newAction.html").param("ActionableItemDataList", (Object)this.getAiDataList(sortedAis));
    }

    private String getAiDataList(List<ArtifactReadable> sortedAis) {
        StringBuilder sb = new StringBuilder("<datalist id=\"actionableItemList\">");
        for (ArtifactReadable art : sortedAis) {
            sb.append("<option value=\"");
            sb.append(art.getName());
            sb.append("\" guid=\"");
            sb.append((String)art.getGuid());
            sb.append("\">");
        }
        sb.append("</datalist>");
        return sb.toString();
    }

    private ResultSet<ArtifactReadable> getAis() throws OseeCoreException {
        return ((QueryBuilder)this.atsServer.getQuery().andIsOfType(new ArtifactTypeId[]{AtsArtifactTypes.ActionableItem})).getResults();
    }

    @Path(value="Search")
    @GET
    @Produces(value={"text/html"})
    public ViewModel getSearch() throws Exception {
        return new ViewModel("search.html");
    }

    @Path(value="{id}/Transition")
    @GET
    @Produces(value={"text/html"})
    public ViewModel getTransition(@PathParam(value="id") String id) throws Exception {
        ArtifactReadable action = (ArtifactReadable)this.atsServer.getArtifactById(id);
        if (action == null) {
            return RestUtil.simplePage(String.format("Action with id [%s] can not be found", id));
        }
        IAtsWorkItem workItem = this.atsServer.getWorkItemFactory().getWorkItem((ArtifactId)action);
        ActionPage page = new ActionPage(this.logger, this.atsServer, workItem, false);
        page.setAddTransition(true);
        return page.generate();
    }

    private static final class IdComparator
    implements Comparator<ArtifactReadable> {
        private IdComparator() {
        }

        @Override
        public int compare(ArtifactReadable arg0, ArtifactReadable arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    }
}

