/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workdef;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinitionStore;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class AtsWorkDefinitionStoreImpl
implements IAtsWorkDefinitionStore {
    private static OrcsApi orcsApi;

    public static void setOrcsApi(OrcsApi orcsApi) {
        AtsWorkDefinitionStoreImpl.orcsApi = orcsApi;
    }

    public void start() throws OseeCoreException {
        Conditions.checkNotNull((Object)orcsApi, (String)"OrcsApi");
        System.out.println("ATS - AtsWorkDefinitionStoreImpl started");
    }

    public List<Pair<String, String>> getWorkDefinitionStrings() throws OseeCoreException {
        ArrayList<Pair<String, String>> nameToWorkDefStr = new ArrayList<Pair<String, String>>(15);
        for (ArtifactReadable workDefArt : ((QueryBuilder)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andTypeEquals(new ArtifactTypeId[]{AtsArtifactTypes.WorkDefinition})).getResults()) {
            nameToWorkDefStr.add((Pair<String, String>)new Pair((Object)workDefArt.getName(), (Object)this.loadWorkDefinitionFromArtifact(workDefArt)));
        }
        return nameToWorkDefStr;
    }

    public String loadWorkDefinitionString(String workDefId) throws OseeCoreException {
        return this.loadWorkDefinitionFromArtifact(workDefId);
    }

    public boolean isWorkDefinitionExists(String workDefId) throws OseeCoreException {
        return this.loadWorkDefinitionString(workDefId) != null;
    }

    private String loadWorkDefinitionFromArtifact(String name) throws OseeCoreException {
        ArtifactReadable artifact = (ArtifactReadable)((QueryBuilder)((QueryBuilder)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andTypeEquals(new ArtifactTypeId[]{AtsArtifactTypes.WorkDefinition})).and((AttributeTypeId)CoreAttributeTypes.Name, name, QueryOption.EXACT_MATCH_OPTIONS)).getResults().getExactlyOne();
        return this.loadWorkDefinitionFromArtifact(artifact);
    }

    private String loadWorkDefinitionFromArtifact(ArtifactReadable artifact) throws OseeCoreException {
        String modelText = null;
        if (artifact != null) {
            modelText = artifact.getSoleAttributeAsString((AttributeTypeId)AtsAttributeTypes.DslSheet);
        }
        return modelText;
    }

    public String loadRuleDefinitionString() throws OseeCoreException {
        ArtifactReadable artifact = (ArtifactReadable)((QueryBuilder)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIds((ArtifactId)AtsArtifactToken.RuleDefinitions)).getResults().getOneOrNull();
        if (artifact != null) {
            return (String)artifact.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.DslSheet, null);
        }
        return null;
    }
}

