/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsRuleDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workdef.IExecutableRule;
import org.eclipse.osee.ats.api.workdef.RuleEventType;
import org.eclipse.osee.ats.api.workdef.RunRuleResults;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.framework.logging.OseeLog;

public class WorkflowRuleRunner {
    private final RuleEventType eventType;
    private final IAtsServer atsServer;
    private final List<IAtsWorkItem> workflowsCreated;
    private final RunRuleResults ruleResults;

    public WorkflowRuleRunner(RuleEventType eventType, List<IAtsWorkItem> workflowsCreated, IAtsServer atsServer) {
        this(eventType, workflowsCreated, atsServer, new RunRuleResults());
    }

    public WorkflowRuleRunner(RuleEventType eventType, List<IAtsWorkItem> workflowsCreated, IAtsServer atsServer, RunRuleResults ruleResults) {
        this.eventType = eventType;
        this.workflowsCreated = workflowsCreated;
        this.atsServer = atsServer;
        this.ruleResults = ruleResults;
    }

    public RunRuleResults run() {
        IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("ATS Rule Runner", AtsCoreUsers.SYSTEM_USER);
        if (this.eventType == RuleEventType.CreateWorkflow) {
            for (IAtsWorkItem workItem : this.workflowsCreated) {
                IAtsRuleDefinition ruleDefinition;
                if (!workItem.isTeamWorkflow()) continue;
                try {
                    if (workItem.getParentTeamWorkflow() != null && workItem.getParentTeamWorkflow().getTeamDefinition() != null) {
                        for (String teamDefRule : workItem.getParentTeamWorkflow().getTeamDefinition().getRules()) {
                            IAtsRuleDefinition ruleDefinition2 = this.atsServer.getWorkDefAdmin().getRuleDefinition(teamDefRule);
                            if (ruleDefinition2 == null || !ruleDefinition2.getRuleEvents().contains(this.eventType) || !(ruleDefinition2 instanceof IExecutableRule)) continue;
                            ((IExecutableRule)ruleDefinition2).execute(workItem, this.atsServer.getServices(), changes, this.ruleResults);
                        }
                    }
                }
                catch (Exception ex) {
                    OseeLog.log(WorkflowRuleRunner.class, (Level)Level.SEVERE, (Throwable)ex);
                }
                try {
                    if (workItem.getParentTeamWorkflow() != null && workItem.getParentTeamWorkflow().getTeamDefinition() != null) {
                        for (IAtsActionableItem ai : workItem.getParentTeamWorkflow().getActionableItems()) {
                            for (String aiRule : ai.getRules()) {
                                ruleDefinition = this.atsServer.getWorkDefAdmin().getRuleDefinition(aiRule);
                                if (ruleDefinition == null || !ruleDefinition.getRuleEvents().contains(this.eventType) || !(ruleDefinition instanceof IExecutableRule)) continue;
                                ((IExecutableRule)ruleDefinition).execute(workItem, this.atsServer.getServices(), changes, this.ruleResults);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    OseeLog.log(WorkflowRuleRunner.class, (Level)Level.SEVERE, (Throwable)ex);
                }
                try {
                    IAtsWorkDefinition workDef = workItem.getWorkDefinition();
                    if (workDef == null) continue;
                    IAtsStateDefinition stateDef = workDef.getStateByName(workItem.getStateMgr().getCurrentStateName());
                    for (String teamDefRule : stateDef.getRules()) {
                        ruleDefinition = this.atsServer.getWorkDefAdmin().getRuleDefinition(teamDefRule);
                        if (!ruleDefinition.getRuleEvents().contains(this.eventType) || !(ruleDefinition instanceof IExecutableRule)) continue;
                        ((IExecutableRule)ruleDefinition).execute(workItem, this.atsServer.getServices(), changes, this.ruleResults);
                    }
                }
                catch (Exception ex) {
                    OseeLog.log(WorkflowRuleRunner.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        }
        if (!changes.isEmpty()) {
            changes.execute();
        }
        return this.ruleResults;
    }

    public RunRuleResults getRuleResults() {
        return this.ruleResults;
    }
}

