/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.core.util.AtsUtilCore;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.AtsApplication;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ViewModel;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class RestUtil {
    public static String getResource(String path) throws Exception {
        Bundle bundle = FrameworkUtil.getBundle(AtsApplication.class);
        URL url = bundle.getEntry("OSEE-INF/" + path);
        return Lib.inputStreamToString((InputStream)url.openStream());
    }

    public static File getResourceAsFile(String path) {
        Bundle bundle = FrameworkUtil.getBundle(AtsApplication.class);
        URL url = bundle.getEntry("OSEE-INF/" + path);
        try {
            URL fileUrl = FileLocator.toFileURL((URL)url);
            return new File(fileUrl.toURI().getPath());
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex, "Error getting resource [%s] as file", new Object[]{path});
        }
    }

    public static String simplePageHtml(String title, String message) throws Exception {
        String html = RestUtil.getResource("templates/simple.html");
        html = html.replaceFirst("<\\?PUT_MESSAGE_HERE\\?>", message);
        html = html.replaceFirst("<\\?PUT_TITLE_HERE\\?>", title);
        return html;
    }

    public static String simplePageHtml(String message) throws Exception {
        return RestUtil.simplePageHtml("ATS", message);
    }

    public static Response simplePageResponse(String message) throws Exception {
        return RestUtil.simplePageResponse("ATS", message);
    }

    public static Response simplePageResponse(String title, String message) throws Exception {
        return Response.status((int)200).entity((Object)RestUtil.simplePageHtml(title, message)).build();
    }

    public static ViewModel simplePage(String message) {
        return RestUtil.simplePage("ATS", message);
    }

    public static ViewModel simplePage(String title, String message) {
        return new ViewModel("simple.html").param("PUT_MESSAGE_HERE", (Object)message).param("PUT_TITLE_HERE", (Object)title);
    }

    public static Response redirect(IAtsWorkItem workItem, String defaultUrl, IAtsServer atsServer) {
        return RestUtil.redirect(Arrays.asList(workItem), defaultUrl, atsServer);
    }

    public static Response redirect(Collection<? extends IAtsWorkItem> workItems, String defaultUrl, IAtsServer atsServer) {
        String actionUrl = AtsUtilCore.getBaseActionUiUrl((String)defaultUrl, (IAtsServices)atsServer);
        String uuids = "";
        for (IAtsWorkItem iAtsWorkItem : workItems) {
            uuids = String.valueOf(uuids) + iAtsWorkItem.getAtsId() + ",";
        }
        uuids = uuids.replaceFirst(",$", "");
        actionUrl = actionUrl.replaceFirst("UUID", uuids);
        URI uRI = UriBuilder.fromUri((String)actionUrl).build(new Object[0]);
        return Response.seeOther((URI)uRI).build();
    }

    public static Response returnBadRequest(String message) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
    }

    public static Response returnInternalServerError(String message) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).build();
    }
}

