/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.notify.IAtsNotifier;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IAtsStoreService;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogFactory;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateFactory;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.core.workflow.WorkItem;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.util.AtsChangeSet;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class AtsStoreServiceImpl
implements IAtsStoreService {
    private final IAttributeResolver attributeResolver;
    private final IAtsStateFactory stateFactory;
    private final IAtsLogFactory logFactory;
    private final IAtsNotifier notifier;
    private final IAtsServer atsServer;
    private final JdbcService jdbcService;

    public AtsStoreServiceImpl(IAttributeResolver attributeResolver, IAtsServer atsServer, IAtsStateFactory stateFactory, IAtsLogFactory logFactory, IAtsNotifier notifier, JdbcService jdbcService) {
        this.atsServer = atsServer;
        this.attributeResolver = attributeResolver;
        this.logFactory = logFactory;
        this.stateFactory = stateFactory;
        this.notifier = notifier;
        this.jdbcService = jdbcService;
    }

    public IAtsChangeSet createAtsChangeSet(String comment, IAtsUser asUser) {
        return new AtsChangeSet(this.atsServer, this.attributeResolver, this.atsServer.getOrcsApi(), this.stateFactory, this.logFactory, comment, asUser, this.notifier);
    }

    public List<IAtsWorkItem> reload(Collection<IAtsWorkItem> inWorkWorkflows) {
        ArrayList<IAtsWorkItem> workItems = new ArrayList<IAtsWorkItem>(inWorkWorkflows.size());
        List guids = AtsObjects.toGuids(inWorkWorkflows);
        Iterator arts = ((QueryBuilder)this.atsServer.getOrcsApi().getQueryFactory().fromBranch((BranchId)this.atsServer.getAtsBranch()).andGuids((Collection)guids)).getResults().iterator();
        while (arts.hasNext()) {
            workItems.add(this.atsServer.getWorkItemFactory().getWorkItem((ArtifactId)arts.next()));
        }
        return workItems;
    }

    public boolean isDeleted(IAtsObject atsObject) {
        return this.atsServer.getArtifact(atsObject).isDeleted();
    }

    public String getGuid(IAtsObject atsObject) {
        return (String)this.atsServer.getArtifact(atsObject).getGuid();
    }

    public Set<IArtifactType> getTeamWorkflowArtifactTypes() throws OseeCoreException {
        HashSet<IArtifactType> artifactTypes = new HashSet<IArtifactType>();
        artifactTypes.addAll(this.atsServer.getOrcsApi().getOrcsTypes().getArtifactTypes().getAllDescendantTypes((ArtifactTypeId)AtsArtifactTypes.TeamWorkflow));
        return artifactTypes;
    }

    public boolean isAttributeTypeValid(IAtsObject atsObject, AttributeTypeId attributeType) {
        return this.isAttributeTypeValid((ArtifactId)atsObject.getStoreObject(), attributeType);
    }

    public boolean isAttributeTypeValid(ArtifactId artifact, AttributeTypeId attributeType) {
        return ((ArtifactReadable)artifact).isAttributeTypeValid(attributeType);
    }

    public AttributeTypeId getAttributeType(String attrTypeName) {
        return this.atsServer.getOrcsApi().getOrcsTypes().getAttributeTypes().getByName(attrTypeName);
    }

    public IArtifactType getArtifactType(ArtifactId artifact) {
        return ((ArtifactReadable)artifact).getArtifactType();
    }

    public boolean isDateType(AttributeTypeId attributeType) {
        return this.atsServer.getOrcsApi().getOrcsTypes().getAttributeTypes().isDateType(attributeType);
    }

    public boolean isOfType(ArtifactId artifact, ArtifactTypeId ... artifactType) {
        return this.atsServer.getArtifact(artifact).isOfType(artifactType);
    }

    public void executeChangeSet(String comment, IAtsObject atsObject) {
        this.executeChangeSet(comment, Collections.singleton(atsObject));
    }

    public void executeChangeSet(String comment, Collection<? extends IAtsObject> atsObjects) {
        IAtsChangeSet changes = this.createAtsChangeSet(comment, this.atsServer.getUserService().getCurrentUser());
        for (IAtsObject iAtsObject : atsObjects) {
            changes.add((Object)iAtsObject);
        }
        changes.execute();
    }

    public IArtifactType getArtifactType(Long artTypeId) {
        return (IArtifactType)this.atsServer.getOrcsApi().getOrcsTypes().getArtifactTypes().get(artTypeId);
    }

    public Map<Long, IArtifactType> getArtifactTypes(Collection<Long> artIds) {
        HashMap<Long, IArtifactType> artIdToType = new HashMap<Long, IArtifactType>();
        this.jdbcService.getClient().runQuery(stmt -> {
            IArtifactType iArtifactType = artIdToType.put(stmt.getLong("art_id"), this.getArtifactType(stmt.getLong("art_type_id")));
        }, String.format("select art_id, art_type_id from osee_artifact where art_id in (%s)", org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",", artIds)), new Object[0]);
        return artIdToType;
    }

    public Collection<AttributeTypeToken> getAttributeTypes() {
        return this.atsServer.getOrcsApi().getOrcsTypes().getAttributeTypes().getAll();
    }

    public boolean isChangedInDb(IAtsWorkItem workItem) {
        return false;
    }

    public IArtifactType getArtifactType(IAtsObject atsObject) {
        return this.getArtifactType((ArtifactId)this.atsServer.getArtifact((ArtifactId)atsObject.getStoreObject()));
    }

    public boolean isOfType(IAtsObject atsObject, IArtifactType artifactType) {
        return this.isOfType((ArtifactId)atsObject.getStoreObject(), new ArtifactTypeId[]{artifactType});
    }

    public void clearCaches(IAtsWorkItem workItem) {
        ((WorkItem)workItem).clearCaches();
    }
}

