/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.core.util.AbstractRelationResolverServiceImpl;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class AtsRelationResolverServiceImpl
extends AbstractRelationResolverServiceImpl {
    private final IAtsServer atsServer;

    public AtsRelationResolverServiceImpl(IAtsServer atsServer) {
        this.atsServer = atsServer;
    }

    public Collection<ArtifactToken> getRelated(ArtifactId artifact, RelationTypeSide relationType) {
        ArrayList<ArtifactToken> results;
        block3: {
            block2: {
                results = new ArrayList<ArtifactToken>();
                if (!(artifact instanceof ArtifactReadable)) break block2;
                for (ArtifactReadable art : ((ArtifactReadable)artifact).getRelated(relationType)) {
                    results.add((ArtifactToken)art);
                }
                break block3;
            }
            if (!(artifact instanceof IAtsObject)) break block3;
            IAtsObject iAtsObject = (IAtsObject)artifact;
            for (ArtifactReadable art : ((ArtifactReadable)iAtsObject.getStoreObject()).getRelated(relationType)) {
                results.add((ArtifactToken)art);
            }
        }
        return results;
    }

    public <T extends IAtsObject> Collection<T> getRelated(IAtsObject atsObject, RelationTypeSide relationType, Class<T> clazz) {
        return this.getRelated(atsObject, relationType, DeletionFlag.EXCLUDE_DELETED, clazz);
    }

    public <T extends IAtsObject> Collection<T> getRelated(IAtsObject atsObject, RelationTypeSide relationType, DeletionFlag flag, Class<T> clazz) {
        ArrayList<IAtsObject> results = new ArrayList<IAtsObject>();
        ArtifactReadable useArt = this.getArtifact(atsObject);
        if (useArt != null) {
            for (ArtifactReadable art : useArt.getRelated(relationType, flag)) {
                IAtsObject object = this.getAtsObject(art);
                if (object == null) continue;
                results.add(object);
            }
        }
        return results;
    }

    public boolean areRelated(ArtifactId artifact1, RelationTypeSide relationType, ArtifactId artifact2) {
        boolean related = false;
        if (artifact1 instanceof ArtifactReadable && artifact2 instanceof ArtifactReadable) {
            related = ((ArtifactReadable)artifact1).areRelated(relationType, (ArtifactReadable)artifact2);
        }
        return related;
    }

    public ArtifactToken getRelatedOrNull(ArtifactId artifact, RelationTypeSide relationType) {
        ArtifactToken related = null;
        try {
            related = (ArtifactToken)((ArtifactReadable)artifact).getRelated(relationType).getAtMostOneOrNull();
        }
        catch (ArtifactDoesNotExist artifactDoesNotExist) {}
        return related;
    }

    public boolean areRelated(IAtsObject atsObject1, RelationTypeSide relationType, IAtsObject atsObject2) {
        boolean related = false;
        ArtifactReadable useArt1 = this.getArtifact(atsObject1);
        ArtifactReadable useArt2 = this.getArtifact(atsObject2);
        if (useArt1 != null && useArt2 != null) {
            related = useArt1.areRelated(relationType, useArt2);
        }
        return related;
    }

    public <T> T getRelatedOrNull(IAtsObject atsObject, RelationTypeSide relationType, Class<T> clazz) {
        IAtsObject related = null;
        ArtifactReadable art = this.getArtifact(atsObject);
        if (art != null) {
            try {
                IAtsObject object;
                ArtifactReadable artifact = (ArtifactReadable)art.getRelated(relationType).getOneOrNull();
                if (artifact != null && (object = this.getAtsObject(artifact)) != null) {
                    related = object;
                }
            }
            catch (ArtifactDoesNotExist artifactDoesNotExist) {}
        }
        return (T)related;
    }

    private IAtsObject getAtsObject(ArtifactReadable artifact) {
        IAtsWorkItem result = null;
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) {
            result = this.atsServer.getWorkItemFactory().getWorkItem((ArtifactId)artifact);
        } else if (this.atsServer.getConfigItemFactory().isAtsConfigArtifact((ArtifactId)artifact)) {
            result = this.atsServer.getConfigItemFactory().getConfigObject((ArtifactId)artifact);
        } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
            result = this.atsServer.getWorkItemFactory().getAction((ArtifactId)artifact);
        }
        return result;
    }

    public ArtifactReadable getArtifact(Object object) {
        ArtifactReadable useArt = null;
        if (object instanceof ArtifactReadable) {
            useArt = (ArtifactReadable)object;
        } else if (object instanceof IAtsObject) {
            IAtsObject atsObject = (IAtsObject)object;
            if (atsObject.getStoreObject() instanceof ArtifactReadable) {
                useArt = (ArtifactReadable)atsObject.getStoreObject();
            }
        } else if (object instanceof ArtifactId) {
            useArt = this.atsServer.getArtifact(((ArtifactId)object).getId());
        }
        return useArt;
    }

    public int getRelatedCount(IAtsWorkItem workItem, RelationTypeSide relationType) {
        ArtifactReadable artifact = this.getArtifact(workItem);
        int count = 0;
        if (artifact != null) {
            count = artifact.getRelatedCount(relationType);
        }
        return count;
    }

    public ArtifactToken getRelatedOrNull(IAtsObject atsObject, RelationTypeSide relationSide) {
        ArtifactReadable art = this.getArtifact(atsObject);
        if (art != null) {
            return (ArtifactToken)art.getRelated(relationSide).getAtMostOneOrNull();
        }
        return null;
    }

    public Collection<ArtifactToken> getRelatedArtifacts(IAtsWorkItem workItem, RelationTypeSide relationTypeSide) {
        ArtifactReadable artifact = this.getArtifact(workItem);
        return Collections.castAll(this.getRelated((ArtifactId)artifact, relationTypeSide));
    }

    public Collection<ArtifactToken> getRelated(ArtifactId artifact, RelationTypeSide relationType, IArtifactType artifactType) {
        LinkedList<ArtifactToken> results = new LinkedList<ArtifactToken>();
        ArtifactReadable art = this.getArtifact(artifact);
        for (ArtifactToken related : art.getRelated(relationType)) {
            if (!((ArtifactReadable)related).isOfType(new ArtifactTypeId[]{artifactType})) continue;
            results.add(related);
        }
        return results;
    }

    public Collection<ArtifactToken> getRelatedArtifacts(ArtifactId artifact, RelationTypeSide relationTypeSide) {
        return this.getRelated(artifact, relationTypeSide);
    }

    public int getRelatedCount(ArtifactToken artifact, RelationTypeSide relationTypeSide) {
        ArtifactReadable art = this.getArtifact(artifact);
        return art.getRelatedCount(relationTypeSide);
    }

    public Collection<Long> getRelatedIds(ArtifactId artifact, RelationTypeSide relationTypeSide) {
        LinkedList<Long> related = new LinkedList<Long>();
        ArtifactReadable art = this.getArtifact(artifact);
        for (ArtifactReadable rel : art.getRelated(relationTypeSide)) {
            related.add(rel.getId());
        }
        return related;
    }
}

