/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.notify.IAtsNotifier;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IExecuteListener;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workflow.IAttribute;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogFactory;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateFactory;
import org.eclipse.osee.ats.core.util.AbstractAtsChangeSet;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.util.AttributeIdWrapper;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class AtsChangeSet
extends AbstractAtsChangeSet {
    private TransactionBuilder transaction;
    private final OrcsApi orcsApi;
    private final IAtsNotifier notifier;
    private final IAtsServer atsServer;

    public AtsChangeSet(IAtsServer atsServer, IAttributeResolver attributeResolver, OrcsApi orcsApi, IAtsStateFactory stateFactory, IAtsLogFactory logFactory, String comment, IAtsUser user, IAtsNotifier notifier) {
        super(comment, user);
        this.atsServer = atsServer;
        this.orcsApi = orcsApi;
        this.notifier = notifier;
    }

    public TransactionBuilder getTransaction() throws OseeCoreException {
        if (this.transaction == null) {
            this.transaction = this.orcsApi.getTransactionFactory().createTransaction((BranchId)this.atsServer.getAtsBranch(), (ArtifactId)this.getUser(this.asUser), this.comment);
        }
        return this.transaction;
    }

    private ArtifactReadable getUser(IAtsUser user) {
        if (user.getStoreObject() instanceof ArtifactReadable) {
            return (ArtifactReadable)user.getStoreObject();
        }
        return (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)this.atsServer.getAtsBranch()).andUuid(user.getId().longValue())).getResults().getExactlyOne();
    }

    public TransactionId execute() throws OseeCoreException {
        Conditions.checkNotNull((Object)this.comment, (String)"comment");
        if (this.isEmpty() && this.execptionIfEmpty) {
            throw new OseeArgumentException("objects/deleteObjects cannot be empty", new Object[0]);
        }
        for (IAtsObject atsObject : new ArrayList(this.atsObjects)) {
            if (!(atsObject instanceof IAtsWorkItem)) continue;
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            if (workItem.getStateMgr().isDirty()) {
                this.atsServer.getStateFactory().writeToStore(this.asUser, workItem, (IAtsChangeSet)this);
            }
            if (!workItem.getLog().isDirty()) continue;
            this.atsServer.getLogFactory().writeToStore(workItem, this.atsServer.getAttributeResolver(), (IAtsChangeSet)this);
        }
        TransactionReadable transactionReadable = this.getTransaction().commit();
        for (IExecuteListener listener : this.listeners) {
            listener.changesStored((IAtsChangeSet)this);
        }
        this.notifier.sendNotifications(this.getNotifications());
        for (IAtsObject atsObject : new ArrayList(this.atsObjects)) {
            if (!(atsObject instanceof IAtsWorkItem)) continue;
            this.atsServer.getStoreService().clearCaches((IAtsWorkItem)atsObject);
        }
        return transactionReadable;
    }

    public void deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType) throws OseeCoreException {
        this.getTransaction().deleteSoleAttribute((ArtifactId)this.getArtifact(workItem), attributeType);
        this.add(workItem);
    }

    public void setSoleAttributeValue(IAtsWorkItem workItem, AttributeTypeId attributeType, String value) throws OseeCoreException {
        ArtifactReadable artifact = this.getArtifact(workItem);
        this.setSoleAttributeValue((ArtifactId)artifact, attributeType, (Object)value);
    }

    public void setSoleAttributeValue(IAtsObject atsObject, AttributeTypeId attributeType, Object value) throws OseeCoreException {
        this.getTransaction().setSoleAttributeValue((ArtifactId)this.getArtifact(atsObject), attributeType, value);
        this.add(atsObject);
    }

    public void deleteAttribute(IAtsObject atsObject, AttributeTypeId attributeType, Object value) throws OseeCoreException {
        this.getTransaction().deleteAttributesWithValue((ArtifactId)this.getArtifact(atsObject), attributeType, value);
        this.add(atsObject);
    }

    public <T> void setValue(IAtsWorkItem workItem, IAttribute<String> attr, AttributeTypeId attributeType, T value) throws OseeCoreException {
        ArtifactReadable artifactId = this.getArtifact(workItem);
        this.getTransaction().setAttributeById((ArtifactId)artifactId, (AttributeId)new AttributeIdWrapper(attr), value);
        this.add(workItem);
    }

    public <T> void deleteAttribute(IAtsWorkItem workItem, IAttribute<T> attr) throws OseeCoreException {
        this.getTransaction().deleteByAttributeId((ArtifactId)this.getArtifact(workItem), (AttributeId)new AttributeIdWrapper(attr));
        this.add(workItem);
    }

    public boolean isAttributeTypeValid(IAtsWorkItem workItem, AttributeTypeId attributeType) {
        ArtifactReadable artifact = this.getArtifact(workItem);
        return artifact.getValidAttributeTypes().contains(attributeType);
    }

    public void addAttribute(IAtsObject atsObject, AttributeTypeId attributeType, Object value) throws OseeCoreException {
        ArtifactReadable artifact = this.getArtifact(atsObject);
        this.getTransaction().createAttributeFromString((ArtifactId)artifact, attributeType, String.valueOf(value));
        this.add(atsObject);
    }

    public ArtifactId createArtifact(IArtifactType artifactType, String name) {
        ArtifactToken artifact = this.getTransaction().createArtifact(artifactType, name);
        this.add(artifact);
        return artifact;
    }

    public void deleteAttributes(IAtsObject atsObject, AttributeTypeId attributeType) {
        ArtifactReadable artifact = this.getArtifact(atsObject);
        this.getTransaction().deleteAttributes((ArtifactId)artifact, attributeType);
        this.add(atsObject);
    }

    public ArtifactToken createArtifact(IArtifactType artifactType, String name, String guid) {
        ArtifactToken artifact = this.getTransaction().createArtifact(artifactType, name, guid);
        this.add(artifact);
        return artifact;
    }

    public ArtifactToken createArtifact(IArtifactType artifactType, String name, String guid, Long uuid) {
        ArtifactToken artifact = this.getTransaction().createArtifact(artifactType, name, guid, uuid.longValue());
        this.add(artifact);
        return artifact;
    }

    public void relate(Object object1, RelationTypeSide relationSide, Object object2) {
        ArtifactReadable artifact = this.getArtifact(object1);
        ArtifactReadable artifact2 = this.getArtifact(object2);
        if (relationSide.getSide().isSideA()) {
            this.getTransaction().relate((ArtifactId)artifact2, (IRelationType)relationSide, (ArtifactId)artifact);
        } else {
            this.getTransaction().relate((ArtifactId)artifact, (IRelationType)relationSide, (ArtifactId)artifact2);
        }
        this.add(artifact);
        this.add(artifact2);
    }

    private ArtifactReadable getArtifact(Object object) {
        ArtifactReadable artifact = null;
        if (object instanceof ArtifactReadable) {
            artifact = (ArtifactReadable)object;
        } else if (object instanceof IAtsObject) {
            IAtsObject atsObject = (IAtsObject)object;
            artifact = atsObject.getStoreObject() instanceof ArtifactReadable ? (ArtifactReadable)atsObject.getStoreObject() : this.atsServer.getArtifact(atsObject.getId());
        }
        return artifact;
    }

    public void unrelateAll(Object object, RelationTypeSide relationType) {
        ArtifactReadable artifact = this.getArtifact(object);
        this.add(artifact);
        for (ArtifactReadable otherArt : artifact.getRelated(relationType)) {
            if (relationType.getSide().isSideA()) {
                this.getTransaction().unrelate((ArtifactId)otherArt, (IRelationType)relationType, (ArtifactId)artifact);
            } else {
                this.getTransaction().unrelate((ArtifactId)artifact, (IRelationType)relationType, (ArtifactId)otherArt);
            }
            this.add(otherArt);
        }
    }

    public void setRelations(Object object, RelationTypeSide relationSide, Collection<? extends Object> objects) {
        ArtifactReadable art;
        ArtifactReadable artifact = this.getArtifact(object);
        LinkedList<ArtifactReadable> artifacts = new LinkedList<ArtifactReadable>();
        for (Object object2 : objects) {
            art = this.getArtifact(object2);
            if (art == null) continue;
            artifacts.add(art);
        }
        for (ArtifactReadable artifactReadable : artifact.getRelated(relationSide)) {
            if (artifacts.contains(artifactReadable)) continue;
            this.unrelate((ArtifactId)artifact, relationSide, (ArtifactId)artifactReadable);
        }
        for (Object object3 : objects) {
            art = this.getArtifact(object3);
            if (art.areRelated(relationSide, art)) continue;
            this.relate(object, relationSide, object3);
        }
    }

    public void unrelate(Object object1, RelationTypeSide relationType, Object object2) {
        this.getTransaction().unrelate((ArtifactId)this.getArtifact(object1), (IRelationType)relationType, (ArtifactId)this.getArtifact(object2));
        this.add(object1);
    }

    public <T> void setAttribute(IAtsWorkItem workItem, int attributeId, T value) {
        Conditions.checkExpressionFailOnTrue((attributeId <= 0 ? 1 : 0) != 0, (String)"Can not set attribute by id that has not be persisted.  Atrribute Id [%s] Work Item [%s]", (Object[])new Object[]{attributeId, workItem.toStringWithId()});
        ArtifactReadable artifact = this.getArtifact(workItem);
        boolean found = false;
        for (AttributeReadable attribute : artifact.getAttributes()) {
            if (attribute.getGammaId() != (long)attributeId) continue;
            this.getTransaction().setAttributeById((ArtifactId)artifact, (AttributeId)attribute, value);
            found = true;
            break;
        }
        if (!found) {
            throw new OseeStateException("Attribute Id %d does not exist on Artifact %s", new Object[]{attributeId, workItem});
        }
        this.add(workItem);
    }

    public void deleteArtifact(ArtifactId artifact) {
        this.getTransaction().deleteArtifact(artifact);
        this.add(artifact);
    }

    public void setAttributeValues(IAtsObject atsObject, AttributeTypeId attrType, List<Object> values) {
        ArtifactReadable artifact = this.getArtifact(atsObject);
        this.getTransaction().setAttributesFromValues((ArtifactId)artifact, attrType, values);
        this.add(artifact);
    }

    public <T> void setAttribute(ArtifactId artifact, AttributeId attrId, T value) {
        Conditions.checkExpressionFailOnTrue((boolean)attrId.isInvalid(), (String)"Can not set attribute by id that has not been persisted.  Atrribute Id [%s] ArtifactId [%s]", (Object[])new Object[]{attrId, artifact.toString()});
        for (AttributeReadable attribute : this.getArtifact(artifact).getAttributes()) {
            if (!attrId.equals(attribute)) continue;
            this.getTransaction().setAttributeById((ArtifactId)this.getArtifact(artifact), (AttributeId)attribute, value);
        }
    }

    public void setSoleAttributeValue(ArtifactId artifact, AttributeTypeId attrType, Object value) {
        ArtifactReadable art = this.getArtifact(artifact);
        this.getTransaction().setSoleAttributeValue((ArtifactId)art, attrType, value);
        this.add(art);
    }

    public void deleteAttribute(ArtifactId artifact, IAttribute<?> attr) {
        AttributeReadable attribute = ((ArtifactReadable)artifact).getAttributeById(attr);
        this.getTransaction().deleteByAttributeId(artifact, (AttributeId)attribute);
        this.add(artifact);
    }

    public void unrelate(ArtifactId artifact, RelationTypeSide relationSide, ArtifactId artifact2) {
        ArtifactReadable art = this.getArtifact(artifact);
        ArtifactReadable art2 = this.getArtifact(artifact2);
        if (relationSide.getSide().isSideA()) {
            this.getTransaction().unrelate((ArtifactId)art2, (IRelationType)relationSide, (ArtifactId)art);
        } else {
            this.getTransaction().unrelate((ArtifactId)art, (IRelationType)relationSide, (ArtifactId)art2);
        }
        this.add(art);
        this.add(art2);
    }

    public void addAttribute(ArtifactId artifact, AttributeTypeId attrType, Object value) {
        ArtifactReadable art = this.getArtifact(artifact);
        this.getTransaction().createAttribute(artifact, attrType, value);
        this.add(art);
    }

    public void setSoleAttributeFromString(ArtifactId artifact, AttributeTypeId attrType, String value) {
        ArtifactReadable art = this.getArtifact(artifact);
        this.getTransaction().setSoleAttributeFromString(artifact, attrType, value);
        this.add(art);
    }

    public void setSoleAttributeFromStream(ArtifactId artifact, AttributeTypeId attributeType, InputStream inputStream) {
        ArtifactReadable art = this.getArtifact(artifact);
        this.getTransaction().setSoleAttributeFromStream((ArtifactId)art, attributeType, inputStream);
        this.add(art);
    }

    public void unrelateFromAll(RelationTypeSide relationSide, ArtifactId artifact) {
        ArtifactReadable art = this.getArtifact(artifact);
        this.getTransaction().unrelateFromAll(relationSide, (ArtifactId)art);
        this.add(art);
    }

    public void addArtifactReferencedAttribute(ArtifactId artifact, AttributeTypeId attributeType, ArtifactId artifactRef) {
        this.addAttribute(artifact, attributeType, (Object)artifactRef.getId().toString());
    }
}

