/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.ITeamWorkflowProvidersLazy;
import org.eclipse.osee.ats.core.util.AbstractAtsBranchService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.TransactionQuery;

public class AtsBranchServiceImpl
extends AbstractAtsBranchService {
    private final OrcsApi orcsApi;
    private final TransactionQuery txQuery;
    private final HashCollection<ArtifactId, TransactionRecord> commitArtifactIdMap = new HashCollection(true, HashSet.class);

    public AtsBranchServiceImpl(IAtsServices atsServices, OrcsApi orcsApi, ITeamWorkflowProvidersLazy teamWorkflowProvidersLazy) {
        super(atsServices, teamWorkflowProvidersLazy);
        this.orcsApi = orcsApi;
        this.txQuery = orcsApi.getQueryFactory().transactionQuery();
    }

    public IOseeBranch getCommittedWorkingBranch(IAtsTeamWorkflow teamWf) {
        BranchQuery query = this.orcsApi.getQueryFactory().branchQuery();
        ArtifactId artId = ArtifactId.valueOf((long)teamWf.getId());
        return (IOseeBranch)((BranchQuery)((BranchQuery)((BranchQuery)((BranchQuery)query.andIsOfType(new BranchType[]{BranchType.WORKING})).andStateIs(new BranchState[]{BranchState.COMMITTED})).excludeArchived()).andAssociatedArtId(artId)).getResults().getOneOrNull();
    }

    public IOseeBranch getWorkingBranchExcludeStates(IAtsTeamWorkflow teamWf, BranchState ... negatedBranchStates) {
        BranchQuery branchQuery = this.orcsApi.getQueryFactory().branchQuery();
        if (negatedBranchStates.length > 0) {
            LinkedList<BranchState> statesToSearch = new LinkedList<BranchState>(Arrays.asList(BranchState.values()));
            statesToSearch.removeAll(Arrays.asList(negatedBranchStates));
            branchQuery.andStateIs(statesToSearch.toArray(new BranchState[statesToSearch.size()]));
        }
        branchQuery.andIsOfType(new BranchType[]{BranchType.WORKING});
        ArtifactId artId = ArtifactId.valueOf((long)teamWf.getId());
        branchQuery.andAssociatedArtId(artId);
        return (IOseeBranch)branchQuery.getResultsAsId().getOneOrNull();
    }

    public BranchType getBranchType(BranchId branch) {
        return this.getBranch(branch).getBranchType();
    }

    public BranchState getBranchState(BranchId branch) {
        BranchQuery query = this.orcsApi.getQueryFactory().branchQuery();
        BranchReadable fullBranch = (BranchReadable)((BranchQuery)query.andId(branch)).getResults().getExactlyOne();
        return fullBranch.getBranchState();
    }

    public boolean isMergeBranchExists(IAtsTeamWorkflow teamWf, BranchId destinationBranch) throws OseeCoreException {
        return this.isMergeBranchExists(teamWf, (BranchId)this.getWorkingBranch(teamWf), destinationBranch);
    }

    public boolean isMergeBranchExists(IAtsTeamWorkflow teamWf, BranchId workingBranch, BranchId destinationBranch) throws OseeCoreException {
        if (workingBranch.isInvalid()) {
            return false;
        }
        BranchQuery query = this.orcsApi.getQueryFactory().branchQuery();
        return (query = (BranchQuery)query.andIsMergeFor(workingBranch, destinationBranch)).getCount() > 0;
    }

    private BranchReadable getBranch(BranchId branch) {
        return (BranchReadable)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branch)).getResults().getExactlyOne();
    }

    public boolean branchExists(BranchId branch) {
        BranchQuery query = this.orcsApi.getQueryFactory().branchQuery();
        return ((BranchQuery)query.andId(branch)).getCount() > 0;
    }

    public boolean isArchived(BranchId branch) {
        return this.getBranch(branch).getArchiveState().isArchived();
    }

    public Collection<TransactionRecord> getCommittedArtifactTransactionIds(IAtsTeamWorkflow teamWf) {
        Collection transactions;
        ArtifactId artId = ArtifactId.valueOf((long)teamWf.getId());
        if (!this.commitArtifactIdMap.containsKey((Object)artId)) {
            this.txQuery.andCommitIds(new Integer[]{teamWf.getId().intValue()});
            this.txQuery.getResults().forEach(tx -> {
                Collection collection = this.commitArtifactIdMap.put((Object)artId, (Object)new TransactionRecord(tx.getId(), tx.getBranch(), tx.getComment(), tx.getDate(), tx.getAuthor().getId().intValue(), tx.getCommitArt().getId().intValue(), tx.getTxType(), tx.getBuildId()));
            });
        }
        return (transactions = this.commitArtifactIdMap.getValues((Object)artId)) == null ? Collections.emptyList() : transactions;
    }

    public BranchId getParentBranch(BranchId branch) {
        BranchQuery query = this.orcsApi.getQueryFactory().branchQuery();
        BranchReadable fullBranch = (BranchReadable)((BranchQuery)query.andId(branch)).getResults().getExactlyOne();
        return fullBranch.getParentBranch();
    }

    public TransactionToken getBaseTransaction(BranchId branch) {
        TransactionQuery txQuery = this.orcsApi.getQueryFactory().transactionQuery();
        return (TransactionToken)((TransactionQuery)((TransactionQuery)txQuery.andBranch(new BranchId[]{branch})).andIs(new TransactionDetailsType[]{TransactionDetailsType.Baselined})).getResults().getExactlyOne();
    }

    public void setBranchName(IOseeBranch branch, String name) {
        this.orcsApi.getBranchOps().changeBranchName((BranchId)branch, name);
    }

    public String getBranchName(BranchId branchId) {
        return this.getBranch(branchId).getName();
    }

    public Result moveWorkingBranch(IAtsTeamWorkflow fromTeamWf, IAtsTeamWorkflow toTeamWf, String newBranchName) {
        throw new UnsupportedOperationException("Not yet supported on server");
    }

    public Collection<BranchId> getBranches(BranchArchivedState archivedState, BranchType branchTypes) {
        LinkedList<BranchId> branches = new LinkedList<BranchId>();
        for (BranchReadable branch : ((BranchQuery)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andIsOfType(new BranchType[]{branchTypes})).excludeArchived()).getResults()) {
            branches.add((BranchId)branch);
        }
        return branches;
    }

    public ArtifactId getAssociatedArtifactId(BranchId branch) {
        throw new UnsupportedOperationException("Not yet supported on server");
    }
}

