/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsWidgetDefinition;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workflow.IAttribute;
import org.eclipse.osee.ats.rest.internal.util.AttributeReadableWrapper;
import org.eclipse.osee.ats.rest.internal.util.AttributeTypeToXWidgetName;
import org.eclipse.osee.ats.rest.internal.util.AttributeWrapper;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;

public class AtsAttributeResolverServiceImpl
implements IAttributeResolver {
    private OrcsApi orcsApi;
    private Log logger;
    private IAtsServices services;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    private ArtifactReadable getArtifact(IAtsObject atsObject) {
        return (ArtifactReadable)this.services.getArtifact(atsObject);
    }

    private ArtifactReadable getArtifact(ArtifactId artifact) {
        return (ArtifactReadable)this.services.getArtifact(artifact);
    }

    public void start() throws OseeCoreException {
        Conditions.checkNotNull((Object)this.orcsApi, (String)"OrcsApi");
        this.logger.info("AtsAttributeResolverServiceImpl started", new Object[0]);
    }

    public void stop() {
    }

    public boolean isAttributeNamed(String attributeName) {
        return this.getAttributeType(attributeName) != null;
    }

    public String getUnqualifiedName(String attributeName) {
        return this.getAttributeType(attributeName).getUnqualifiedName();
    }

    public void setXWidgetNameBasedOnAttributeName(String attributeName, IAtsWidgetDefinition widgetDef) {
        try {
            if (!Strings.isValid((String)widgetDef.getXWidgetName())) {
                widgetDef.setXWidgetName(AttributeTypeToXWidgetName.getXWidgetName(this.orcsApi, (AttributeTypeId)this.getAttributeType(attributeName)));
            }
        }
        catch (OseeCoreException ex) {
            this.logger.error((Throwable)ex, "Error setXWidgetNameBasedOnAttributeName - attributeName [%s] widgetDef[%s]", new Object[]{attributeName, widgetDef});
        }
    }

    public String getDescription(String attributeName) {
        return this.getAttributeType(attributeName).getDescription();
    }

    public AttributeTypeToken getAttributeType(String attributeName) {
        AttributeTypeToken attrType = null;
        try {
            for (AttributeTypeToken type : this.orcsApi.getOrcsTypes().getAttributeTypes().getAll()) {
                if (!type.getName().equals(attributeName)) continue;
                attrType = type;
            }
        }
        catch (OseeCoreException ex) {
            this.logger.error((Throwable)ex, "Error getting attribute type with name [%s]", new Object[]{attributeName});
        }
        return attrType;
    }

    public <T> T getSoleAttributeValue(IAtsObject atsObject, AttributeTypeId attributeType, T defaultReturnValue) throws OseeCoreException {
        return (T)this.getArtifact(atsObject).getSoleAttributeValue(attributeType, defaultReturnValue);
    }

    public Collection<String> getAttributesToStringList(IAtsObject atsObject, AttributeTypeId attributeType) throws OseeCoreException {
        return this.getArtifact(atsObject).getAttributeValues(attributeType);
    }

    public boolean isAttributeTypeValid(IAtsWorkItem workItem, AttributeTypeId attributeType) throws OseeCoreException {
        return this.getArtifact((IAtsObject)workItem).isAttributeTypeValid(attributeType);
    }

    public String getSoleAttributeValueAsString(IAtsObject atsObject, AttributeTypeId attributeType, String defaultValue) throws OseeCoreException {
        return (String)this.getArtifact(atsObject).getSoleAttributeValue(attributeType, (Object)defaultValue);
    }

    public String getSoleAttributeValueAsString(ArtifactId artifact, AttributeTypeId attributeType, String defaultValue) {
        return (String)this.getArtifact(artifact).getSoleAttributeValue(attributeType, (Object)defaultValue);
    }

    public void setSoleAttributeValue(IAtsObject atsObject, AttributeTypeId attributeType, Object value) throws OseeCoreException {
        throw new OseeStateException("Invalid: Must use setSoleAttributeValue(IAtsWorkItem workItem, AttributeTypeId attributeType, Object value, IAtsChangeSet changes)", new Object[0]);
    }

    public int getAttributeCount(IAtsWorkItem workItem, AttributeTypeId attributeType) throws OseeCoreException {
        return this.getArtifact((IAtsObject)workItem).getAttributeCount(attributeType);
    }

    public int getAttributeCount(IAtsObject atsObject, AttributeTypeId attributeType) throws OseeCoreException {
        return this.getArtifact(atsObject).getAttributeCount(attributeType);
    }

    public int getAttributeCount(ArtifactId artifact, AttributeTypeId attributeType) throws OseeCoreException {
        return this.getArtifact(artifact).getAttributeCount(attributeType);
    }

    public void addAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType, Object value) throws OseeCoreException {
        throw new OseeStateException("Not Implemented", new Object[0]);
    }

    public <T> Collection<IAttribute<T>> getAttributes(IAtsWorkItem workItem, AttributeTypeId attributeType) throws OseeCoreException {
        ArrayList<IAttribute<T>> attrs = new ArrayList<IAttribute<T>>();
        for (AttributeReadable attr : this.getArtifact((IAtsObject)workItem).getAttributes(attributeType)) {
            attrs.add(new AttributeWrapper(attr));
        }
        return attrs;
    }

    public void deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType) throws OseeCoreException {
        throw new OseeStateException("Invalid: Must use deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType, IAtsChangeSet changes)", new Object[0]);
    }

    public void deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType, IAtsChangeSet changes) throws OseeCoreException {
        changes.deleteSoleAttribute(workItem, attributeType);
    }

    public void setSoleAttributeValue(IAtsObject atsObject, AttributeTypeId attributeType, Object value, IAtsChangeSet changes) throws OseeCoreException {
        changes.setSoleAttributeValue(atsObject, attributeType, value);
    }

    public void addAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType, Object value, IAtsChangeSet changes) throws OseeCoreException {
        changes.addAttribute((IAtsObject)workItem, attributeType, value);
    }

    public void deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType, Object value, IAtsChangeSet changes) throws OseeCoreException {
        changes.deleteAttribute((IAtsObject)workItem, attributeType, value);
    }

    public <T> void setValue(IAtsWorkItem workItem, IAttribute<String> attr, AttributeTypeId attributeType, T value, IAtsChangeSet changes) throws OseeCoreException {
        changes.setValue(workItem, attr, attributeType, value);
    }

    public <T> void deleteAttribute(IAtsWorkItem workItem, IAttribute<T> attr, IAtsChangeSet changes) throws OseeCoreException {
        changes.deleteAttribute(workItem, attr);
    }

    public <T> void deleteAttribute(IAtsWorkItem workItem, IAttribute<T> attr) throws OseeCoreException {
        throw new OseeStateException("Invalid: Must use deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType, IAtsChangeSet changes)", new Object[0]);
    }

    public <T> void setValue(IAtsWorkItem workItem, IAttribute<String> attr, AttributeTypeId attributeType, T value) throws OseeCoreException {
        throw new OseeStateException("Invalid: Must use deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType, IAtsChangeSet changes)", new Object[0]);
    }

    public <T> T getSoleAttributeValue(ArtifactId artifact, AttributeTypeId attributeType, T defaultValue) {
        return (T)this.getArtifact(artifact).getSoleAttributeValue(attributeType, defaultValue);
    }

    public <T> Collection<T> getAttributeValues(ArtifactId artifact, AttributeTypeId attributeType) {
        return this.getArtifact(artifact).getAttributeValues(attributeType);
    }

    public Collection<Object> getAttributeValues(IAtsObject atsObject, AttributeTypeId attributeType) {
        return this.getAttributeValues((ArtifactId)atsObject.getStoreObject(), attributeType);
    }

    public <T> Collection<IAttribute<T>> getAttributes(ArtifactId artifact, AttributeTypeId attributeType) throws OseeCoreException {
        Assert.isNotNull((Object)artifact, (String)"Artifact can not be null");
        Assert.isNotNull((Object)attributeType, (String)"Attribute Type can not be null");
        LinkedList<IAttribute<T>> attributes = new LinkedList<IAttribute<T>>();
        for (AttributeReadable attr : ((ArtifactReadable)artifact).getAttributes(attributeType)) {
            attributes.add(new AttributeReadableWrapper(attr));
        }
        return attributes;
    }

    public Collection<String> getAttributesToStringList(ArtifactId artifact, AttributeTypeId attributeType) {
        return ((ArtifactReadable)artifact).getAttributeValues(attributeType);
    }

    public <T> Collection<IAttribute<T>> getAttributes(ArtifactId artifact) {
        LinkedList<IAttribute<T>> attributes = new LinkedList<IAttribute<T>>();
        for (AttributeReadable attr : this.getArtifact(artifact).getAttributes()) {
            attributes.add(new AttributeWrapper(attr));
        }
        return attributes;
    }

    public <T> Collection<IAttribute<T>> getAttributes(IAtsWorkItem workItem) throws OseeCoreException {
        return this.getAttributes((ArtifactId)workItem.getStoreObject());
    }

    public void setServices(IAtsServices services) {
        this.services = services;
    }
}

