/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IArtifactResolver;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class ArtifactResolverImpl
implements IArtifactResolver {
    private final IAtsServices services;
    private final OrcsApi orcsApi;

    public ArtifactResolverImpl(IAtsServices services, OrcsApi orcsApi) {
        this.services = services;
        this.orcsApi = orcsApi;
    }

    public ArtifactId get(IAtsObject atsObject) throws OseeCoreException {
        if (atsObject.getStoreObject() instanceof ArtifactReadable) {
            return atsObject.getStoreObject();
        }
        ArtifactReadable artifact = (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)this.services.getAtsBranch()).andUuid(atsObject.getId().longValue())).getResults().getAtMostOneOrNull();
        return artifact;
    }

    public <A extends ArtifactId> A get(IAtsWorkItem workItem, Class<?> clazz) throws OseeCoreException {
        Assert.isNotNull((Object)workItem, (String)"Work Item can not be null");
        ArtifactId artifact = this.get((IAtsObject)workItem);
        if (clazz.isInstance(artifact)) {
            return (A)artifact;
        }
        return null;
    }

    public <A extends ArtifactId> List<A> get(Collection<? extends IAtsWorkItem> workItems, Class<?> clazz) throws OseeCoreException {
        Assert.isNotNull(workItems, (String)"Work Items can not be null");
        ArrayList<ArtifactReadable> arts = new ArrayList<ArtifactReadable>();
        for (IAtsWorkItem iAtsWorkItem : workItems) {
            ArtifactReadable artifact = (ArtifactReadable)this.get(iAtsWorkItem, clazz);
            if (artifact == null) continue;
            arts.add(artifact);
        }
        return arts;
    }

    public IArtifactType getArtifactType(IAtsWorkItem workItem) {
        Assert.isNotNull((Object)workItem, (String)"Work Item can not be null");
        return ((ArtifactReadable)workItem.getStoreObject()).getArtifactType();
    }

    public boolean isOfType(ArtifactId artifact, IArtifactType artifactType) {
        Assert.isNotNull((Object)artifact, (String)"Artifact can not be null");
        Assert.isNotNull((Object)artifactType, (String)"Artifact Type can not be null");
        return ((ArtifactReadable)this.services.getArtifact(artifact)).isOfType(new ArtifactTypeId[]{artifactType});
    }

    public boolean isOfType(IAtsObject atsObject, IArtifactType artifactType) {
        Assert.isNotNull((Object)atsObject, (String)"ATS Object can not be null");
        Assert.isNotNull((Object)artifactType, (String)"Artifact Type can not be null");
        return this.isOfType((ArtifactId)this.services.getArtifact(atsObject), artifactType);
    }

    public boolean inheritsFrom(IArtifactType artType, IArtifactType parentArtType) {
        return this.orcsApi.getOrcsTypes().getArtifactTypes().inheritsFrom((ArtifactTypeId)artType, new ArtifactTypeId[]{parentArtType});
    }
}

