/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.workdef.IAtsCompositeLayoutItem;
import org.eclipse.osee.ats.api.workdef.IAtsLayoutItem;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWidgetDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.util.RestUtil;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.exception.OseeWrappedException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ViewModel;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.AXml;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;

public class ActionPage {
    private static final String DEFECT_TABLE_HEADER = "<table border=\"1\" align=\"center\" width=\"98%\"><tr><th>Severity</th><th>Disposition</th><th>Closed</th><th>User</th><th>Created</th><th>Injected</th><th>Description</th><th>Location</th><th>Resolution</th></tr>";
    private static final String ROLE_TABLE_HEADER = "<table border=\"1\" align=\"center\" width=\"90%\"><tr><th>Role</th><th>User</th><th>Completed</th><th>Hours Spent</th></tr>";
    private static final String COMMIT_MANAGER_WIDGET_NAME = "Commit Manager";
    private static final String REVIEW_DEFECT_WIDGET_NAME = "Review Defect";
    private static final String ROLE_WIDGET_NAME = "Role";
    private String pageTemplate;
    private IAtsWorkItem workItem;
    private final ArtifactReadable action;
    private final IAtsServer atsServer;
    private final Log logger;
    private boolean addTransition = false;
    private static final List<String> roleKeys = Arrays.asList("role", "userId", "completed", "hoursSpent");
    private static final List<String> defectKeys = Arrays.asList("severity", "disposition", "closed", "user", "date", "injectionActivity", "description", "location", "resolution");
    private static List<String> ignoredWidgets;
    private final boolean details;
    private boolean inComposite = false;

    public ActionPage(Log logger, IAtsServer atsServer, IAtsWorkItem workItem, boolean details) {
        this(logger, atsServer, (ArtifactReadable)workItem.getStoreObject(), details);
        this.workItem = workItem;
    }

    public ActionPage(Log logger, IAtsServer atsServer, ArtifactReadable action, boolean details) {
        this.logger = logger;
        this.atsServer = atsServer;
        this.action = action;
        this.details = details;
    }

    private IAtsWorkItem getWorkItem() {
        if (this.workItem == null) {
            this.workItem = this.atsServer.getWorkItemFactory().getWorkItem((ArtifactId)this.action);
        }
        return this.workItem;
    }

    public ViewModel generate() throws Exception {
        IAtsWorkItem workItem = this.getWorkItem();
        Conditions.checkNotNull((Object)workItem, (String)"workItem");
        ViewModel page = new ViewModel("action.html");
        page.param("title", (Object)this.action.getSoleAttributeAsString((AttributeTypeId)AtsAttributeTypes.Title, ""));
        page.param("team", (Object)ActionPage.getTeamStr(this.atsServer, this.action));
        page.param("ais", (Object)this.getAIStr(this.action));
        page.param("state", (Object)workItem.getStateMgr().getCurrentStateName());
        page.param("assignees", (Object)ActionPage.getAssigneesStr(workItem, this.action));
        page.param("id", (Object)workItem.getId());
        page.param("atsId", (Object)workItem.getAtsId());
        page.param("originator", (Object)ActionPage.getCreatedByStr(workItem, this.action));
        page.param("priority", (Object)this.action.getSoleAttributeAsString((AttributeTypeId)AtsAttributeTypes.PriorityType, ""));
        page.param("changeType", (Object)this.action.getSoleAttributeAsString((AttributeTypeId)AtsAttributeTypes.ChangeType, ""));
        page.param("needBy", (Object)this.action.getSoleAttributeAsString((AttributeTypeId)AtsAttributeTypes.NeedBy, ""));
        page.param("workflow", (Object)this.action.getArtifactType().toString());
        page.param("createdDate", (Object)workItem.getCreatedDate().toString());
        page.param("version", (Object)this.getVersion(workItem));
        page.param("workDef", (Object)this.getWorkDefStr(workItem));
        page.param("guid", (Object)workItem.getId());
        if (!this.addTransition) {
            page.param("transition", (Object)"");
        } else {
            this.addTransitionStates(page);
        }
        this.addStates(page, workItem, this.action);
        this.addDetails(page, workItem, this.action);
        return page;
    }

    private String getWorkDefStr(IAtsWorkItem workItem) {
        return workItem.getWorkDefinition().getName();
    }

    public static String getAssigneesStr(IAtsWorkItem workItem, ArtifactReadable action) {
        return workItem.getStateMgr().getAssigneesStr();
    }

    public static String getTeamStr(IAtsServer atsServer, ArtifactReadable action) {
        String results = action.getSoleAttributeAsString((AttributeTypeId)AtsAttributeTypes.TeamDefinition, "");
        if (Strings.isValid((String)results)) {
            results = atsServer.getArtifactByGuid(results).getName();
        } else {
            ArtifactReadable teamWf = ActionPage.getParentTeamWf(action);
            if (teamWf != null) {
                results = ActionPage.getTeamStr(atsServer, teamWf);
            }
        }
        return results;
    }

    private static ArtifactReadable getParentTeamWf(ArtifactReadable action) {
        ArtifactReadable teamWf = null;
        if (action.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            teamWf = action;
        } else if (action.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.ReviewArtifact})) {
            teamWf = (ArtifactReadable)action.getRelated(AtsRelationTypes.TeamWorkflowToReview_Team).getOneOrNull();
        } else if (action.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task})) {
            teamWf = (ArtifactReadable)action.getRelated(AtsRelationTypes.TeamWfToTask_TeamWf).getOneOrNull();
        }
        return teamWf;
    }

    private String getAIStr(ArtifactReadable action) {
        StringBuilder sb = new StringBuilder();
        ArtifactReadable teamWf = ActionPage.getParentTeamWf(action);
        if (teamWf != null) {
            for (AttributeReadable aiGuid : teamWf.getAttributes((AttributeTypeId)AtsAttributeTypes.ActionableItem)) {
                sb.append(this.atsServer.getArtifactByGuid(aiGuid.toString()).getName());
                sb.append(", ");
            }
        }
        return sb.toString().replaceFirst(", $", "");
    }

    public static String getCreatedByStr(IAtsWorkItem workItem, ArtifactReadable action) {
        String results = action.getSoleAttributeAsString((AttributeTypeId)AtsAttributeTypes.CreatedBy);
        results = workItem.getCreatedBy().getName();
        return results;
    }

    public void addTransitionStates(ViewModel page) throws OseeCoreException {
        try {
            IAtsWorkItem workItem = this.getWorkItem();
            String html = RestUtil.getResource("templates/transition.html");
            html = html.replaceAll("PUT_POST_URL_HERE", "/ats/action/state");
            html = html.replaceAll("PUT_ATS_ID_HERE", workItem.getAtsId());
            html = html.replaceFirst("PUT_TO_STATE_LIST_HERE", this.getToStateList());
            String defaultToStateValue = "";
            IAtsStateDefinition defaultToState = workItem.getStateDefinition().getDefaultToState();
            if (defaultToState != null) {
                defaultToStateValue = "value=\"" + defaultToState.getName() + "\"";
            }
            html = html.replaceAll("PUT_DEFAULT_TO_STATE_VALUE_HERE", defaultToStateValue);
            page.param("transition", (Object)html);
        }
        catch (Exception ex) {
            throw new OseeWrappedException((Throwable)ex);
        }
    }

    private String getToStateList() {
        StringBuilder sb = new StringBuilder("<datalist id=\"ToStateList\">\n");
        for (IAtsStateDefinition state : this.workItem.getStateDefinition().getToStates()) {
            sb.append("<option value=\"");
            sb.append(state.getName());
            sb.append("\" guid=\"");
            sb.append(state.getName());
            sb.append("\">\n");
        }
        sb.append("</datalist>");
        return sb.toString();
    }

    private String getVersion(IAtsWorkItem workItem) {
        String version = "<on full load>";
        try {
            IAtsTeamWorkflow teamWf = workItem.getParentTeamWorkflow();
            String str = this.atsServer.getWorkItemService().getTargetedVersionStr(teamWf);
            if (Strings.isValid((String)str)) {
                version = str;
            }
        }
        catch (OseeCoreException ex) {
            this.logger.error((Throwable)ex, "Error getting version for [%s]", new Object[]{workItem});
            version = "exception: " + ex.getLocalizedMessage();
        }
        return version;
    }

    private void addStates(ViewModel page, IAtsWorkItem workItem, ArtifactReadable action) throws Exception {
        StringBuilder statesSb = new StringBuilder();
        IAtsWorkDefinition workDefinition = workItem.getWorkDefinition();
        IAtsStateManager stateMgr = workItem.getStateMgr();
        List visitedStates = stateMgr.getVisitedStateNames();
        List statesOrderedByOrdinal = this.atsServer.getWorkDefService().getStatesOrderedByOrdinal(workDefinition);
        int index = statesOrderedByOrdinal.size() - 1;
        while (index >= 0) {
            IAtsStateDefinition state = (IAtsStateDefinition)statesOrderedByOrdinal.get(index);
            if (visitedStates.contains(state.getName())) {
                String stateHtmlTemplate = this.getStateHtmlTemplate();
                String stateName = state.getName();
                if (stateName.equals(stateMgr.getCurrentStateName())) {
                    stateName = String.format("CURRENT STATE => <b>%s</b>", stateName);
                    if (stateMgr.getStateType().isCompleted()) {
                        stateName = String.format("%s - on <b>%s</b> - by <b>%s</b>", stateName, DateUtil.getMMDDYYHHMM((Date)workItem.getCompletedDate()), workItem.getCompletedBy().getName());
                    } else if (stateMgr.getStateType().isCancelled()) {
                        stateName = String.format("%s - on <b>%s</b> - by <b>%s</b><br/>from <b>%s</b> - reason <b>[%s]</b>", stateName, DateUtil.getMMDDYYHHMM((Date)workItem.getCancelledDate()), workItem.getCancelledBy().getName(), workItem.getCancelledFromState(), workItem.getCancelledReason());
                    }
                }
                stateHtmlTemplate = stateHtmlTemplate.replace("TITLE", stateName);
                StringBuilder widgets = new StringBuilder();
                this.addWidgets(widgets, workItem, state.getLayoutItems());
                stateHtmlTemplate = stateHtmlTemplate.replace("WIDGETS", widgets.toString());
                statesSb.append(stateHtmlTemplate);
            }
            --index;
        }
        page.param("states", (Object)statesSb.toString());
    }

    private void addWidgets(StringBuilder sb, IAtsWorkItem workItem, Collection<IAtsLayoutItem> items) {
        this.addLayoutItems(sb, workItem, items);
    }

    private void addLayoutItems(StringBuilder sb, IAtsWorkItem workItem, Collection<IAtsLayoutItem> items) {
        for (IAtsLayoutItem layout : items) {
            if (layout instanceof IAtsCompositeLayoutItem) {
                this.inComposite = true;
                sb.append("<tr><td><table width=\"100%\"><tr>");
                this.addWidgets(sb, workItem, ((IAtsCompositeLayoutItem)layout).getaLayoutItems());
                sb.append("</tr></table></td></tr>");
                this.inComposite = false;
                continue;
            }
            IAtsWidgetDefinition widget = (IAtsWidgetDefinition)layout;
            if (this.getIgnoreWidgetNames().contains(widget.getName())) continue;
            if (!this.inComposite) {
                sb.append("<tr><td>");
            } else {
                sb.append("<td>");
            }
            this.addWidget(sb, workItem, widget);
            if (!this.inComposite) {
                sb.append("</td></tr>");
                continue;
            }
            sb.append("</td>");
        }
    }

    private void addWidget(StringBuilder sb, IAtsWorkItem workItem, IAtsWidgetDefinition widget) {
        if (widget.getName().equals(ROLE_WIDGET_NAME)) {
            this.addRoleWidget(sb, workItem, widget);
        } else if (widget.getName().equals(REVIEW_DEFECT_WIDGET_NAME)) {
            this.addDefectWidget(sb, workItem, widget);
        } else if (widget.getName().equals(COMMIT_MANAGER_WIDGET_NAME)) {
            this.addCommitManager(sb, workItem, widget);
        } else {
            this.addWidgetDefault(sb, workItem, widget);
        }
    }

    private void addCommitManager(StringBuilder sb, IAtsWorkItem workItem2, IAtsWidgetDefinition widget) {
        sb.append("Commit Manager: ");
        IOseeBranch branch = this.atsServer.getBranchService().getBranch((IAtsTeamWorkflow)this.workItem);
        if (branch.isValid()) {
            sb.append(branch.getName());
        }
    }

    private List<String> getIgnoreWidgetNames() {
        if (ignoredWidgets == null) {
            ignoredWidgets = new ArrayList<String>();
            String configValue = this.atsServer.getConfigValue("IgnoredWidgetNames");
            if (Strings.isValid((String)configValue)) {
                String[] stringArray = configValue.split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String widgetName = stringArray[n2];
                    ignoredWidgets.add(widgetName);
                    ++n2;
                }
            }
        }
        return ignoredWidgets;
    }

    private void addRoleWidget(StringBuilder sb, IAtsWorkItem workItem, IAtsWidgetDefinition widget) {
        sb.append("Roles: ");
        Collection roles = this.atsServer.getAttributeResolver().getAttributesToStringList((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.Role);
        if (!roles.isEmpty()) {
            sb.append(ROLE_TABLE_HEADER);
            for (String xml : roles) {
                sb.append("<tr>");
                for (String key : roleKeys) {
                    sb.append("<td>");
                    String data = AXml.getTagData((String)xml, (String)key);
                    if (key.equals("userId")) {
                        data = this.atsServer.getUserService().getUserById(data).getName();
                    }
                    sb.append(data);
                    sb.append("</td>");
                }
                sb.append("</tr>");
            }
            sb.append("</table>");
        }
    }

    private void addDefectWidget(StringBuilder sb, IAtsWorkItem workItem, IAtsWidgetDefinition widget) {
        sb.append("Defects: ");
        Collection defects = this.atsServer.getAttributeResolver().getAttributesToStringList((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.ReviewDefect);
        if (!defects.isEmpty()) {
            sb.append(DEFECT_TABLE_HEADER);
            for (String xml : defects) {
                sb.append("<tr>");
                for (String key : defectKeys) {
                    sb.append("<td>");
                    String data = AXml.getTagData((String)xml, (String)key);
                    if (key.equals("user")) {
                        data = this.atsServer.getUserService().getUserById(data).getName();
                    } else if (key.equals("date")) {
                        data = DateUtil.getDateStr((Date)new Date(Long.valueOf(data)), (String)"MM/dd/yyyy hh:mm a");
                    }
                    sb.append(data);
                    sb.append("</td>");
                }
                sb.append("</tr>");
            }
            sb.append("</table>");
        }
    }

    private void addWidgetDefault(StringBuilder sb, IAtsWorkItem workItem, IAtsWidgetDefinition widget) {
        sb.append(widget.getName());
        sb.append(": <b>");
        try {
            AttributeTypeToken attributeType = this.atsServer.getAttributeResolver().getAttributeType(widget.getAtrributeName());
            Collection attributesToStringList = this.atsServer.getAttributeResolver().getAttributesToStringList((IAtsObject)workItem, (AttributeTypeId)attributeType);
            if (attributesToStringList.size() > 1) {
                sb.append(attributesToStringList.toString());
            } else if (attributesToStringList.size() == 1) {
                sb.append(AHTML.textToHtml((String)String.valueOf(attributesToStringList.iterator().next())));
            }
        }
        catch (OseeCoreException ex) {
            sb.append("exception: " + ex.getLocalizedMessage());
        }
        sb.append("</b>");
    }

    private String getStateHtmlTemplate() throws Exception {
        if (this.pageTemplate == null) {
            this.pageTemplate = RestUtil.getResource("templates/state.html");
        }
        return this.pageTemplate;
    }

    private void addDetails(ViewModel page, IAtsWorkItem workItem, ArtifactReadable artifact) {
        StringBuilder sb = new StringBuilder();
        if (this.details) {
            try {
                ActionPage.addDetail(sb, "Guid", (String)artifact.getGuid());
                ActionPage.addDetail(sb, "Artifact Type", artifact.getArtifactType().getName());
                sb.append("</br><b>Attribute Raw Data:</b></br>");
                for (AttributeReadable attr : artifact.getAttributes()) {
                    ActionPage.addDetail(sb, attr.getAttributeType().getName(), AHTML.textToHtml((String)String.valueOf(attr.getValue())));
                }
            }
            catch (OseeCoreException ex) {
                sb.append("exception: " + ex.getLocalizedMessage());
            }
        }
        page.param("details", (Object)sb.toString());
    }

    private static void addDetail(StringBuilder sb, String key, String value) {
        sb.append(key);
        sb.append(": <b>");
        sb.append(value);
        sb.append("</b></br>");
    }

    public boolean isAddTransition() {
        return this.addTransition;
    }

    public void setAddTransition(boolean addTransition) {
        this.addTransition = addTransition;
    }
}

