/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.user;

import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.data.ArtifactReadable;

@XmlRootElement
public class AtsUser
implements IAtsUser {
    private ArtifactReadable user;

    public AtsUser(ArtifactReadable user) {
        this.user = user;
    }

    public String getName() {
        return this.user.getName();
    }

    public int hashCode() {
        int result = 0;
        int userIdHashCode = 0;
        try {
            userIdHashCode = this.getUserId() == null ? 0 : this.getUserId().hashCode();
        }
        catch (OseeCoreException oseeCoreException) {}
        result = 31 * result + userIdHashCode;
        return result;
    }

    public boolean equals(Object obj) {
        String thisUserId;
        String objUserId;
        block9: {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            try {
                objUserId = null;
                if (!(obj instanceof IAtsUser)) {
                    return false;
                }
                objUserId = ((IAtsUser)obj).getUserId();
            }
            catch (OseeCoreException oseeCoreException) {
                return false;
            }
            thisUserId = this.getUserId();
            if (thisUserId != null) break block9;
            if (objUserId != null) {
                return false;
            }
        }
        if (!thisUserId.equals(objUserId)) {
            return false;
        }
        return true;
    }

    public String getUserId() throws OseeCoreException {
        return this.user.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.UserId);
    }

    public String getEmail() throws OseeCoreException {
        return this.user.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.Email, "");
    }

    public boolean isActive() throws OseeCoreException {
        return (Boolean)this.user.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Active, (Object)false);
    }

    public String toString() {
        try {
            return String.format("%s (%s)", this.getName(), this.getUserId());
        }
        catch (Exception ex) {
            return "Exception: " + ex.getLocalizedMessage();
        }
    }

    @JsonIgnore
    public ArtifactToken getStoreObject() {
        return this.user;
    }

    public void setStoreObject(ArtifactToken artifact) {
        if (artifact instanceof ArtifactReadable) {
            this.user = (ArtifactReadable)artifact;
        }
    }

    public Long getId() {
        return this.user.getId();
    }

    public IArtifactType getArtifactType() {
        return this.user.getArtifactType();
    }

    public boolean isOfType(ArtifactTypeId ... artifactTypes) {
        return this.user.isOfType(artifactTypes);
    }
}

