/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.query.IAtsConfigQuery;
import org.eclipse.osee.ats.api.query.IAtsOrcsScriptQuery;
import org.eclipse.osee.ats.api.query.IAtsQuery;
import org.eclipse.osee.ats.api.query.IAtsWorkItemFilter;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.query.AbstractAtsQueryService;
import org.eclipse.osee.ats.core.query.AtsWorkItemFilter;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.query.AtsConfigQueryImpl;
import org.eclipse.osee.ats.rest.internal.query.AtsOrcsScriptQuery;
import org.eclipse.osee.ats.rest.internal.query.AtsQueryImpl;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class AtsQueryServiceImpl
extends AbstractAtsQueryService {
    private final IAtsServer atsServer;

    public AtsQueryServiceImpl(IAtsServer atsServer, JdbcService jdbcService) {
        super(jdbcService, atsServer.getServices());
        this.atsServer = atsServer;
    }

    public IAtsQuery createQuery(WorkItemType workItemType, WorkItemType ... workItemTypes) {
        AtsQueryImpl query = new AtsQueryImpl(this.atsServer);
        query.isOfType(new WorkItemType[]{workItemType});
        WorkItemType[] workItemTypeArray = workItemTypes;
        int n = workItemTypes.length;
        int n2 = 0;
        while (n2 < n) {
            WorkItemType type = workItemTypeArray[n2];
            query.isOfType(new WorkItemType[]{type});
            ++n2;
        }
        return query;
    }

    public IAtsConfigQuery createQuery(IArtifactType ... artifactType) {
        AtsConfigQueryImpl query = new AtsConfigQueryImpl(this.atsServer);
        query.isOfType(artifactType);
        return query;
    }

    public IAtsWorkItemFilter createFilter(Collection<? extends IAtsWorkItem> workItems) {
        return new AtsWorkItemFilter(workItems, this.atsServer.getServices());
    }

    public ArrayList<AtsSearchData> getSavedSearches(IAtsUser atsUser, String namespace) {
        throw new UnsupportedOperationException("Unsupported on the server");
    }

    public void saveSearch(IAtsUser atsUser, AtsSearchData data) {
        throw new UnsupportedOperationException("Unsupported on the server");
    }

    public void removeSearch(IAtsUser atsUser, AtsSearchData data) {
        throw new UnsupportedOperationException("Unsupported on the server");
    }

    public AtsSearchData getSearch(IAtsUser atsUser, Long uuid) {
        throw new UnsupportedOperationException("Unsupported on the server");
    }

    public AtsSearchData getSearch(String jsonStr) {
        throw new UnsupportedOperationException("Unsupported on the server");
    }

    public AtsSearchData createSearchData(String namespace, String searchName) {
        throw new UnsupportedOperationException("Unsupported on the server");
    }

    public Collection<ArtifactId> getArtifacts(List<Integer> ids, BranchId branch) {
        LinkedList<Long> uuids = new LinkedList<Long>();
        for (Integer id : ids) {
            uuids.add(Long.valueOf(id.intValue()));
        }
        return Collections.castAll((Collection)((QueryBuilder)this.atsServer.getOrcsApi().getQueryFactory().fromBranch(branch).andUuids(uuids)).getResults().getList());
    }

    public IAtsOrcsScriptQuery createOrcsScriptQuery(String query, Object ... data) {
        return new AtsOrcsScriptQuery(String.format(query, data), this.atsServer);
    }
}

