/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.query.IAtsQuery;
import org.eclipse.osee.ats.core.query.AbstractAtsQueryImpl;
import org.eclipse.osee.ats.core.query.AtsAttributeQuery;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class AtsQueryImpl
extends AbstractAtsQueryImpl {
    private final IAtsServer atsServer;
    private QueryBuilder query;

    public AtsQueryImpl(IAtsServer atsServer) {
        super(atsServer.getServices());
        this.atsServer = atsServer;
    }

    public Collection<ArtifactId> runQuery() {
        ArrayList<ArtifactId> results = new ArrayList<ArtifactId>();
        Iterator iterator = this.query.getResults().iterator();
        while (iterator.hasNext()) {
            results.add((ArtifactId)iterator.next());
        }
        return results;
    }

    public void createQueryBuilder() {
        this.query = this.atsServer.getOrcsApi().getQueryFactory().fromBranch((BranchId)this.atsServer.getAtsBranch());
    }

    public void queryAnd(AttributeTypeId attrType, Collection<String> values) {
        this.query.and(attrType, values, new QueryOption[0]);
    }

    public void queryAndIsOfType(IArtifactType artifactType) {
        this.query.andIsOfType(new ArtifactTypeId[]{artifactType});
    }

    public List<ArtifactId> queryGetIds() {
        LinkedList<ArtifactId> results = new LinkedList<ArtifactId>();
        Iterator iterator = this.query.getResultsAsLocalIds().iterator();
        while (iterator.hasNext()) {
            results.add((ArtifactId)iterator.next());
        }
        return results;
    }

    public void queryAndIsOfType(Collection<IArtifactType> artTypes) {
        this.query.andIsOfType(artTypes);
    }

    public void queryAnd(AttributeTypeId attrType, String value) {
        this.query.and(attrType, value, new QueryOption[0]);
    }

    public void queryAndRelatedToLocalIds(RelationTypeSide relationTypeSide, ArtifactId artId) {
        this.query.andRelatedTo(relationTypeSide, artId);
    }

    public void queryAndRelatedTo(RelationTypeSide relationTypeSide, List<ArtifactId> artifacts) {
        this.query.andRelatedTo(relationTypeSide, artifacts);
    }

    public void queryAnd(AttributeTypeId attrType, Collection<String> values, QueryOption[] queryOption) {
        this.query.and(attrType, values, queryOption);
    }

    public void queryAnd(AttributeTypeId attrType, String value, QueryOption[] queryOption) {
        this.query.and(attrType, value, queryOption);
    }

    public void queryAndLocalIds(List<Integer> artIds) {
        LinkedList<Long> results = new LinkedList<Long>();
        for (Integer artId : artIds) {
            results.add(new Long(artId.intValue()));
        }
        this.query.andUuids(results);
    }

    public void queryAndNotExists(RelationTypeSide relationTypeSide) {
        this.query.andNotExists(relationTypeSide);
    }

    public void queryAndExists(RelationTypeSide relationTypeSide) {
        this.query.andExists(relationTypeSide);
    }

    public List<String> getWorkPackagesForColorTeam(String colorTeam) {
        LinkedList<String> workPackageGuids = new LinkedList<String>();
        for (ArtifactReadable workPackageArt : ((QueryBuilder)((QueryBuilder)this.atsServer.getOrcsApi().getQueryFactory().fromBranch((BranchId)this.atsServer.getAtsBranch()).andIsOfType(new ArtifactTypeId[]{AtsArtifactTypes.WorkPackage})).and((AttributeTypeId)AtsAttributeTypes.ColorTeam, colorTeam, new QueryOption[0])).getResults()) {
            workPackageGuids.add((String)workPackageArt.getGuid());
        }
        return workPackageGuids;
    }

    public List<ArtifactId> getRelatedTeamWorkflowUuidsBasedOnTeamDefsAisAndVersions(List<AtsAttributeQuery> teamWorkflowAttr) {
        AtsQueryImpl search = new AtsQueryImpl(this.atsServer);
        search.isOfType(new IArtifactType[]{AtsArtifactTypes.TeamWorkflow});
        if (this.teamDefUuids != null && !this.teamDefUuids.isEmpty()) {
            search.andTeam(new ArrayList(this.teamDefUuids));
        }
        if (this.aiUuids != null && !this.aiUuids.isEmpty()) {
            search.andActionableItem(new ArrayList(this.aiUuids));
        }
        if (this.versionUuid != null && this.versionUuid > 0L) {
            search.andVersion(this.versionUuid);
        }
        return new ArrayList<ArtifactId>(search.getItemIds());
    }

    public IAtsQuery andNotExists(AttributeTypeId attributeType) {
        this.query.andNotExists(attributeType);
        return this;
    }
}

