/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.core.query.AbstractAtsConfigQueryImpl;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class AtsConfigQueryImpl
extends AbstractAtsConfigQueryImpl {
    private final IAtsServer atsServer;
    private QueryBuilder query;

    public AtsConfigQueryImpl(IAtsServer atsServer) {
        super(atsServer.getServices());
        this.atsServer = atsServer;
    }

    public Collection<ArtifactId> runQuery() {
        ArrayList<ArtifactId> results = new ArrayList<ArtifactId>();
        Iterator iterator = this.query.getResults().iterator();
        while (iterator.hasNext()) {
            results.add((ArtifactId)iterator.next());
        }
        return results;
    }

    public void createQueryBuilder() {
        this.query = this.atsServer.getOrcsApi().getQueryFactory().fromBranch((BranchId)this.atsServer.getAtsBranch());
    }

    private QueryBuilder getQuery() {
        Conditions.checkNotNull((Object)this.query, (String)"Query builder not created");
        return this.query;
    }

    public void queryAnd(AttributeTypeId attrType, Collection<String> values) {
        this.getQuery().and(attrType, values, new QueryOption[0]);
    }

    public void queryAndIsOfType(IArtifactType artifactType) {
        this.getQuery().andIsOfType(new ArtifactTypeId[]{artifactType});
    }

    public List<? extends ArtifactId> queryGetIds() {
        return this.getQuery().getResultsAsLocalIds().getList();
    }

    public void queryAndIsOfType(List<IArtifactType> artTypes) {
        this.getQuery().andIsOfType(artTypes);
    }

    public void queryAnd(AttributeTypeId attrType, String value) {
        this.getQuery().and(attrType, value, new QueryOption[0]);
    }

    public void queryAnd(AttributeTypeId attrType, Collection<String> values, QueryOption[] queryOption) {
        this.getQuery().and(attrType, values, queryOption);
    }

    public void queryAnd(AttributeTypeId attrType, String value, QueryOption[] queryOption) {
        this.getQuery().and(attrType, value, queryOption);
    }

    public void queryAndLocalIds(List<Integer> artIds) {
        LinkedList<Long> results = new LinkedList<Long>();
        for (Integer artId : artIds) {
            results.add(new Long(artId.intValue()));
        }
        this.getQuery().andUuids(results);
    }

    public void queryAndNotExists(RelationTypeSide relationTypeSide) {
        this.getQuery().andNotExists(relationTypeSide);
    }

    public void queryAndExists(RelationTypeSide relationTypeSide) {
        this.getQuery().andExists(relationTypeSide);
    }
}

