/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.notify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.notify.AtsNotificationCollector;
import org.eclipse.osee.ats.api.notify.AtsNotificationEventFactory;
import org.eclipse.osee.ats.api.notify.AtsNotifyType;
import org.eclipse.osee.ats.api.notify.AtsWorkItemNotificationEvent;
import org.eclipse.osee.ats.api.review.IAtsPeerReviewRoleManager;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.review.Role;
import org.eclipse.osee.ats.api.review.UserRole;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.team.IAtsWorkItemFactory;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.core.users.AtsUsersUtility;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.EmailUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class WorkItemNotificationProcessor {
    private final Log logger;
    private final IAtsUserService userService;
    private final IAttributeResolver attrResolver;
    private final IAtsWorkItemFactory workItemFactory;
    private final IAtsServer atsServer;
    private static String actionUrl;

    public WorkItemNotificationProcessor(Log logger, IAtsServer atsServer, IAtsWorkItemFactory workItemFactory, IAtsUserService userService, IAttributeResolver attrResolver) throws OseeCoreException {
        this.logger = logger;
        this.atsServer = atsServer;
        this.workItemFactory = workItemFactory;
        this.userService = userService;
        this.attrResolver = attrResolver;
    }

    public void run(AtsNotificationCollector notifications, AtsWorkItemNotificationEvent event) throws OseeCoreException {
        Set types = event.getNotifyTypes();
        ArrayList<IAtsUser> notifyUsers = new ArrayList<IAtsUser>();
        IAtsUser fromUser = AtsCoreUsers.SYSTEM_USER;
        if (Strings.isValid((String)event.getFromUserId())) {
            fromUser = this.userService.getUserById(event.getFromUserId());
        }
        for (String userId : event.getUserIds()) {
            notifyUsers.add(this.userService.getUserById(userId));
        }
        for (String atsId : event.getAtsIds()) {
            IAtsWorkItem workItem = this.workItemFactory.getWorkItemByAtsId(atsId);
            if (types.contains(AtsNotifyType.Originator)) {
                try {
                    IAtsUser originator = workItem.getCreatedBy();
                    if (originator.isActive()) {
                        if (!EmailUtil.isEmailValid((String)originator.getEmail()) && !AtsCoreUsers.isAtsCoreUser((IAtsUser)originator)) {
                            this.logger.info("Email [%s] invalid for user [%s]", new Object[]{originator.getEmail(), originator.getName()});
                        } else if (!fromUser.equals(originator)) {
                            notifications.addNotificationEvent(AtsNotificationEventFactory.getNotificationEvent((IAtsUser)this.getFromUser(event), Arrays.asList(originator), (String)this.getIdString(workItem), (String)AtsNotifyType.Originator.name(), (String)this.getUrl(workItem), (String)String.format("You have been set as the originator of [%s] state [%s] titled [%s]", workItem.getArtifactTypeName(), workItem.getStateMgr().getCurrentStateName(), workItem.getName())));
                        }
                    }
                }
                catch (OseeCoreException ex) {
                    this.logger.error((Throwable)ex, "Error processing Originator for workItem [%s] and event [%s]", new Object[]{workItem.toStringWithId(), event.toString()});
                }
            }
            if (types.contains(AtsNotifyType.Assigned)) {
                try {
                    Collection assignees = new HashSet<IAtsUser>();
                    if (!notifyUsers.isEmpty()) {
                        assignees.addAll(notifyUsers);
                    } else {
                        assignees.addAll(workItem.getStateMgr().getAssignees());
                    }
                    assignees.remove(fromUser);
                    assignees = AtsUsersUtility.getValidEmailUsers(assignees);
                    assignees = AtsUsersUtility.getActiveEmailUsers(assignees);
                    if (assignees.size() > 0) {
                        notifications.addNotificationEvent(AtsNotificationEventFactory.getNotificationEvent((IAtsUser)this.getFromUser(event), assignees, (String)this.getIdString(workItem), (String)AtsNotifyType.Assigned.name(), (String)this.getUrl(workItem), (String)String.format("You have been set as the assignee of [%s] in state [%s] titled [%s]", workItem.getArtifactTypeName(), workItem.getStateMgr().getCurrentStateName(), workItem.getName())));
                    }
                }
                catch (OseeCoreException ex) {
                    this.logger.error((Throwable)ex, "Error processing Assigned for workItem [%s] and event [%s]", new Object[]{workItem.toStringWithId(), event.toString()});
                }
            }
            if (types.contains(AtsNotifyType.Subscribed)) {
                try {
                    Collection subscribed = new HashSet<IAtsUser>();
                    subscribed.addAll(this.getSubscribed(workItem));
                    subscribed = AtsUsersUtility.getValidEmailUsers(subscribed);
                    subscribed = AtsUsersUtility.getActiveEmailUsers(subscribed);
                    if (subscribed.size() > 0) {
                        notifications.addNotificationEvent(AtsNotificationEventFactory.getNotificationEvent((IAtsUser)this.getFromUser(event), subscribed, (String)this.getIdString(workItem), (String)AtsNotifyType.Subscribed.name(), (String)this.getUrl(workItem), (String)String.format("[%s] titled [%s] transitioned to [%s] and you subscribed for notification.", workItem.getArtifactTypeName(), workItem.getName(), workItem.getStateMgr().getCurrentStateName())));
                    }
                }
                catch (OseeCoreException ex) {
                    this.logger.error((Throwable)ex, "Error processing Subscribed for workItem [%s] and event [%s]", new Object[]{workItem.toStringWithId(), event.toString()});
                }
            }
            try {
                IAtsUser originator;
                boolean stateTypeIsCompletedOrCancelled;
                IAtsStateDefinition stateDefinition = workItem.getStateDefinition();
                StateType stateType = stateDefinition.getStateType();
                boolean notificationTypeIsCompletedOrCancelled = types.contains(AtsNotifyType.Cancelled) || types.contains(AtsNotifyType.Completed);
                boolean bl = stateTypeIsCompletedOrCancelled = stateType.isCompleted() || stateType.isCancelled();
                if (notificationTypeIsCompletedOrCancelled && !workItem.isTask() && stateTypeIsCompletedOrCancelled && (originator = workItem.getCreatedBy()).isActive()) {
                    if (!EmailUtil.isEmailValid((String)originator.getEmail())) {
                        this.logger.info("Email [%s] invalid for user [%s]", new Object[]{originator.getEmail(), originator.getName()});
                    } else if (this.isOriginatorDifferentThanCancelledOrCompletedBy(workItem, fromUser, originator)) {
                        if (stateType.isCompleted()) {
                            notifications.addNotificationEvent(AtsNotificationEventFactory.getNotificationEvent((IAtsUser)this.getFromUser(event), Arrays.asList(originator), (String)this.getIdString(workItem), (String)workItem.getStateMgr().getCurrentStateName(), (String)this.getUrl(workItem), (String)String.format("[%s] titled [%s] is [%s]", workItem.getArtifactTypeName(), workItem.getName(), workItem.getStateMgr().getCurrentStateName())));
                        }
                        if (stateType.isCancelled()) {
                            notifications.addNotificationEvent(AtsNotificationEventFactory.getNotificationEvent((IAtsUser)this.getFromUser(event), Arrays.asList(originator), (String)this.getIdString(workItem), (String)workItem.getStateMgr().getCurrentStateName(), (String)this.getUrl(workItem), (String)String.format("[%s] titled [%s] was [%s] from the [%s] state on [%s].<br>Reason: [%s]", workItem.getArtifactTypeName(), workItem.getName(), workItem.getStateMgr().getCurrentStateName(), workItem.getCancelledFromState(), DateUtil.getMMDDYYHHMM((Date)workItem.getCancelledDate()), workItem.getCancelledReason())));
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.logger.error((Throwable)ex, "Error processing Completed or Cancelled for workItem [%s] and event [%s]", new Object[]{workItem.toStringWithId(), event.toString()});
            }
            if (types.contains(AtsNotifyType.Peer_Reviewers_Completed) && workItem instanceof IAtsPeerToPeerReview) {
                try {
                    IAtsPeerReviewRoleManager roleMgr = ((IAtsPeerToPeerReview)workItem).getRoleManager();
                    Collection<IAtsUser> authorModerator = new ArrayList();
                    for (UserRole role : roleMgr.getUserRoles()) {
                        if (role.getRole() != Role.Author && role.getRole() != Role.Moderator) continue;
                        authorModerator.add(this.userService.getUserById(role.getUserId()));
                    }
                    authorModerator = AtsUsersUtility.getValidEmailUsers(authorModerator);
                    if ((authorModerator = AtsUsersUtility.getActiveEmailUsers(authorModerator)).size() > 0) {
                        notifications.addNotificationEvent(AtsNotificationEventFactory.getNotificationEvent((IAtsUser)this.getFromUser(event), authorModerator, (String)this.getIdString(workItem), (String)AtsNotifyType.Peer_Reviewers_Completed.name(), (String)String.format("You are Author/Moderator of [%s] titled [%s] which has been reviewed by all reviewers", workItem.getArtifactTypeName(), workItem.getName())));
                    }
                }
                catch (OseeCoreException ex) {
                    this.logger.error((Throwable)ex, "Error processing Peer_Reviewers_Completed for workItem [%s] and event [%s]", new Object[]{workItem.toStringWithId(), event.toString()});
                }
            }
            if (!types.contains(AtsNotifyType.SubscribedTeamOrAi) || !workItem.isTeamWorkflow()) continue;
            IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)workItem;
            try {
                Collection subscribedUsers = new HashSet();
                IAtsTeamDefinition teamDef = teamWf.getTeamDefinition();
                subscribedUsers.addAll(teamDef.getSubscribed());
                if (subscribedUsers.size() > 0) {
                    notifications.addNotificationEvent(AtsNotificationEventFactory.getNotificationEvent((IAtsUser)AtsCoreUsers.SYSTEM_USER, subscribedUsers, (String)this.getIdString((IAtsWorkItem)teamWf), (String)"Workflow Creation", (String)this.getUrl(workItem), (String)("You have subscribed for email notification for Team \"" + teamWf.getTeamDefinition().getName() + "\"; New Team Workflow created with title \"" + teamWf.getName() + "\"")));
                }
                for (IAtsActionableItem aia : teamWf.getActionableItems()) {
                    subscribedUsers = aia.getSubscribed();
                    if (subscribedUsers.size() <= 0) continue;
                    notifications.addNotificationEvent(AtsNotificationEventFactory.getNotificationEvent((IAtsUser)AtsCoreUsers.SYSTEM_USER, subscribedUsers, (String)this.getIdString((IAtsWorkItem)teamWf), (String)"Workflow Creation", (String)this.getUrl(workItem), (String)("You have subscribed for email notification for Actionable Item \"" + teamWf.getTeamDefinition().getName() + "\"; New Team Workflow created with title \"" + teamWf.getName() + "\"")));
                }
            }
            catch (OseeCoreException ex) {
                this.logger.error((Throwable)ex, "Error processing SubscribedTeamOrAi for workItem [%s] and event [%s]", new Object[]{workItem.toStringWithId(), event.toString()});
            }
        }
    }

    public List<IAtsUser> getSubscribed(IAtsWorkItem workItem) throws OseeCoreException {
        ArrayList<IAtsUser> arts = new ArrayList<IAtsUser>();
        for (ArtifactId art : this.atsServer.getRelationResolver().getRelated((ArtifactId)workItem.getStoreObject(), AtsRelationTypes.SubscribedUser_User)) {
            arts.add(this.userService.getUserById((String)this.atsServer.getAttributeResolver().getSoleAttributeValue(art, (AttributeTypeId)CoreAttributeTypes.UserId, null)));
        }
        return arts;
    }

    private boolean isOriginatorDifferentThanCancelledOrCompletedBy(IAtsWorkItem workItem, IAtsUser fromUser, IAtsUser originator) {
        boolean different = true;
        if (fromUser.equals(originator)) {
            different = false;
        } else if (workItem.getCancelledBy() != null && originator.equals(workItem.getCancelledBy())) {
            different = false;
        } else if (workItem.getCompletedBy() != null && originator.equals(workItem.getCompletedBy())) {
            different = false;
        }
        return different;
    }

    private String getUrl(IAtsWorkItem workItem) {
        if (actionUrl == null) {
            actionUrl = this.atsServer.getConfigValue("ActionUrl");
        }
        if (Strings.isValid((String)actionUrl)) {
            return actionUrl.replaceFirst("UUID", String.valueOf(workItem.getId()));
        }
        return "Not Configured";
    }

    private IAtsUser getFromUser(AtsWorkItemNotificationEvent event) {
        IAtsUser fromUser = AtsCoreUsers.SYSTEM_USER;
        if (Strings.isValid((String)event.getFromUserId())) {
            fromUser = this.userService.getUserById(event.getFromUserId());
        }
        return fromUser;
    }

    private String getIdString(IAtsWorkItem workItem) {
        try {
            String legacyPcrId = (String)this.attrResolver.getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.LegacyPcrId, (Object)"");
            if (!legacyPcrId.equals("")) {
                return "ID: " + workItem.getAtsId() + " / LegacyId: " + legacyPcrId;
            }
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, "Error getting legacyId pcr for workItem [%s]", new Object[]{workItem});
        }
        return "ID: " + workItem.getAtsId();
    }
}

