/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.cpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.cpa.DecisionUpdate;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.transition.IAtsTransitionManager;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.core.workflow.transition.TransitionFactory;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelper;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class DecisionUpdater {
    private final DecisionUpdate update;
    private final IAtsServer atsServer;

    public DecisionUpdater(DecisionUpdate update, IAtsServer atsServer) {
        this.update = update;
        this.atsServer = atsServer;
    }

    public XResultData update() {
        XResultData rd = new XResultData(false);
        ResultSet results = ((QueryBuilder)this.atsServer.getQuery().and((AttributeTypeId)AtsAttributeTypes.AtsId, (Collection)this.update.getUuids(), new QueryOption[0])).getResults();
        IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("Update CPA Decision", AtsCoreUsers.SYSTEM_USER);
        for (ArtifactReadable art : results) {
            IAtsTeamWorkflow teamWf = this.atsServer.getWorkItemFactory().getTeamWf((ArtifactId)art);
            if (!rd.isErrors()) {
                this.updateRationale(this.update, changes, teamWf, rd);
            }
            if (!rd.isErrors()) {
                this.updateDuplicatedPcrId(this.update, changes, teamWf, rd);
            }
            if (!rd.isErrors()) {
                this.updateApplicability(this.update, changes, teamWf, rd);
            }
            if (rd.isErrors()) continue;
            this.updateAssignees(this.update, changes, teamWf, rd);
        }
        if (!rd.isErrors() && !changes.isEmpty()) {
            changes.execute();
        }
        return rd;
    }

    private void updateApplicability(DecisionUpdate update, IAtsChangeSet changes, IAtsTeamWorkflow teamWf, XResultData rd) {
        if (update.getApplicability() != null) {
            String appl = update.getApplicability();
            if (appl.isEmpty()) {
                changes.deleteAttributes((IAtsObject)teamWf, (AttributeTypeId)AtsAttributeTypes.ApplicableToProgram);
                TransitionHelper helper = new TransitionHelper("Transition " + teamWf.getAtsId(), Arrays.asList(teamWf), TeamState.Analyze.getName(), (Collection)teamWf.getAssignees(), "", changes, this.atsServer.getServices(), new TransitionOption[]{TransitionOption.OverrideAssigneeCheck});
                helper.setTransitionUser(AtsCoreUsers.SYSTEM_USER);
                IAtsTransitionManager mgr = TransitionFactory.getTransitionManager((ITransitionHelper)helper);
                TransitionResults results = mgr.handleAll();
                if (!results.isEmpty()) {
                    rd.error(results.toString());
                }
            } else {
                changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeId)AtsAttributeTypes.ApplicableToProgram, appl);
                TransitionHelper helper = new TransitionHelper("Transition " + teamWf.getAtsId(), Arrays.asList(teamWf), TeamState.Completed.getName(), null, "", changes, this.atsServer.getServices(), new TransitionOption[]{TransitionOption.OverrideAssigneeCheck});
                helper.setTransitionUser(AtsCoreUsers.SYSTEM_USER);
                IAtsTransitionManager mgr = TransitionFactory.getTransitionManager((ITransitionHelper)helper);
                TransitionResults results = mgr.handleAll();
                if (!results.isEmpty()) {
                    rd.error(results.toString());
                }
            }
        }
    }

    private void updateAssignees(DecisionUpdate update, IAtsChangeSet changes, IAtsTeamWorkflow teamWf, XResultData rd) {
        if (update.getAssignees() != null) {
            ArrayList<IAtsUser> assignees = new ArrayList<IAtsUser>();
            for (String userId : update.getAssignees()) {
                IAtsUser user = this.atsServer.getUserService().getUserById(userId);
                if (user == null) {
                    rd.errorf("Invalid userId [%s]", new Object[]{userId});
                }
                assignees.add(user);
            }
            List currentAssignees = teamWf.getAssignees();
            if (assignees.isEmpty()) {
                assignees.add(AtsCoreUsers.UNASSIGNED_USER);
            } else if (assignees.size() > 1 && assignees.contains(AtsCoreUsers.UNASSIGNED_USER)) {
                assignees.remove(AtsCoreUsers.UNASSIGNED_USER);
            }
            if (!Collections.isEqual((Collection)currentAssignees, assignees)) {
                teamWf.getStateMgr().setAssignees(assignees);
                changes.add((Object)teamWf);
            }
        }
    }

    private void updateRationale(DecisionUpdate update, IAtsChangeSet changes, IAtsTeamWorkflow teamWf, XResultData rd) {
        if (update.getRationale() != null) {
            if (update.getRationale().equals("")) {
                changes.deleteAttributes((IAtsObject)teamWf, (AttributeTypeId)AtsAttributeTypes.Rationale);
            } else {
                changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeId)AtsAttributeTypes.Rationale, update.getRationale());
            }
        }
    }

    private void updateDuplicatedPcrId(DecisionUpdate update, IAtsChangeSet changes, IAtsTeamWorkflow teamWf, XResultData rd) {
        if (update.getDuplicatedPcrId() != null) {
            if (update.getDuplicatedPcrId().equals("")) {
                changes.deleteAttributes((IAtsObject)teamWf, (AttributeTypeId)AtsAttributeTypes.DuplicatedPcrId);
            } else {
                changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeId)AtsAttributeTypes.DuplicatedPcrId, update.getDuplicatedPcrId());
            }
        }
    }
}

