/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.cpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.cpa.CpaDecision;
import org.eclipse.osee.ats.api.cpa.CpaPcr;
import org.eclipse.osee.ats.api.cpa.IAtsCpaService;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.cpa.CpaFactory;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.cpa.CpaServiceRegistry;
import org.eclipse.osee.ats.rest.internal.cpa.CpaUtil;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class DecisionLoader {
    private String programUuid;
    private Boolean open;
    private final IAtsServer atsServer;
    private final CpaServiceRegistry cpaRegistry;
    private Collection<String> uuids;

    public static DecisionLoader createLoader(CpaServiceRegistry cpaRegistry, IAtsServer atsServer) {
        return new DecisionLoader(cpaRegistry, atsServer);
    }

    public DecisionLoader andProgramUuid(String programUuid) {
        this.programUuid = programUuid;
        return this;
    }

    public DecisionLoader andCpaIds(Collection<String> uuids) {
        this.uuids = uuids;
        return this;
    }

    public DecisionLoader andOpen(Boolean open) {
        this.open = open;
        return this;
    }

    private DecisionLoader(CpaServiceRegistry cpaRegistry, IAtsServer atsServer) {
        this.cpaRegistry = cpaRegistry;
        this.atsServer = atsServer;
    }

    public List<CpaDecision> load() {
        ArrayList<CpaDecision> decisions = new ArrayList<CpaDecision>();
        QueryBuilder queryBuilder = (QueryBuilder)((QueryBuilder)this.atsServer.getQuery().andTypeEquals(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})).and((AttributeTypeId)AtsAttributeTypes.ApplicabilityWorkflow, "true", new QueryOption[0]);
        if (Strings.isValid((String)this.programUuid)) {
            queryBuilder.and((AttributeTypeId)AtsAttributeTypes.ProgramUuid, this.programUuid, new QueryOption[0]);
        }
        if (Conditions.hasValues(this.uuids)) {
            queryBuilder.and((AttributeTypeId)AtsAttributeTypes.AtsId, this.uuids, new QueryOption[0]);
        }
        if (this.open != null) {
            queryBuilder.and((AttributeTypeId)AtsAttributeTypes.CurrentStateType, this.open != false ? StateType.Working.name() : StateType.Completed.name(), new QueryOption[0]);
        }
        HashCollection origPcrIdToDecision = new HashCollection();
        String pcrToolId = null;
        ElapsedTime time = new ElapsedTime("load cpa workflows");
        ResultSet results = queryBuilder.getResults();
        time.end(ElapsedTime.Units.SEC);
        time = new ElapsedTime("process cpa workflows");
        for (ArtifactReadable art : results) {
            IAtsTeamWorkflow teamWf = this.atsServer.getWorkItemFactory().getTeamWf((ArtifactId)art);
            CpaDecision decision = CpaFactory.getDecision((IAtsTeamWorkflow)teamWf, null);
            decision.setApplicability((String)art.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.ApplicableToProgram, (Object)""));
            decision.setRationale((String)art.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Rationale, (Object)""));
            String pcrToolIdValue = (String)art.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.PcrToolId, (Object)"");
            if (pcrToolId == null) {
                pcrToolId = pcrToolIdValue;
            }
            decision.setPcrSystem(pcrToolIdValue);
            boolean completed = ((String)art.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.CurrentStateType, (Object)"")).equals(StateType.Completed.name());
            decision.setComplete(Boolean.valueOf(completed));
            decision.setAssignees(teamWf.getStateMgr().getAssigneesStr());
            if (completed) {
                decision.setCompletedBy(teamWf.getCompletedBy().getName());
                decision.setCompletedDate(DateUtil.getMMDDYY((Date)teamWf.getCompletedDate()));
            }
            decision.setDecisionLocation(CpaUtil.getCpaPath(this.atsServer).path(teamWf.getAtsId()).build(new Object[0]).toString());
            String origPcrId = (String)art.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OriginatingPcrId);
            origPcrIdToDecision.put((Object)origPcrId, (Object)decision);
            decision.setOrigPcrLocation(CpaUtil.getCpaPath(this.atsServer).path(origPcrId).queryParam("pcrSystem", new Object[]{decision.getPcrSystem()}).build(new Object[0]).toString());
            String duplicatedPcrId = (String)art.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.DuplicatedPcrId, null);
            if (Strings.isValid((String)duplicatedPcrId)) {
                String duplicatedLocation = CpaUtil.getCpaPath(this.atsServer).path(duplicatedPcrId).queryParam("pcrSystem", new Object[]{decision.getPcrSystem()}).build(new Object[0]).toString();
                decision.setDuplicatedPcrLocation(duplicatedLocation);
                decision.setDuplicatedPcrId(duplicatedPcrId);
            }
            decisions.add(decision);
        }
        time.end();
        time = new ElapsedTime("load issues");
        IAtsCpaService service = this.cpaRegistry.getServiceById(pcrToolId);
        for (Map.Entry entry : service.getPcrsByIds((Collection)origPcrIdToDecision.keySet()).entrySet()) {
            for (CpaDecision decision : origPcrIdToDecision.getValues((Object)((String)entry.getKey()))) {
                decision.setOriginatingPcr((CpaPcr)entry.getValue());
            }
        }
        time.end();
        return decisions;
    }
}

