/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.cpa;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.cpa.AtsCpaEndpointApi;
import org.eclipse.osee.ats.api.cpa.CpaBuild;
import org.eclipse.osee.ats.api.cpa.CpaConfig;
import org.eclipse.osee.ats.api.cpa.CpaConfigTool;
import org.eclipse.osee.ats.api.cpa.CpaDecision;
import org.eclipse.osee.ats.api.cpa.CpaProgram;
import org.eclipse.osee.ats.api.cpa.DecisionUpdate;
import org.eclipse.osee.ats.api.cpa.DuplicateCpa;
import org.eclipse.osee.ats.api.cpa.IAtsCpaService;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.core.util.AtsUtilCore;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.cpa.CpaDuplicator;
import org.eclipse.osee.ats.rest.internal.cpa.CpaServiceRegistry;
import org.eclipse.osee.ats.rest.internal.cpa.CpaUtil;
import org.eclipse.osee.ats.rest.internal.cpa.DecisionLoader;
import org.eclipse.osee.ats.rest.internal.cpa.DecisionUpdater;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.EnumEntry;

public final class CpaResource
implements AtsCpaEndpointApi {
    private final OrcsApi orcsApi;
    private final IAtsServer atsServer;
    private final CpaServiceRegistry cpaRegistry;

    public CpaResource(OrcsApi orcsApi, IAtsServer atsServer, CpaServiceRegistry cpaRegistry) {
        this.orcsApi = orcsApi;
        this.atsServer = atsServer;
        this.cpaRegistry = cpaRegistry;
    }

    @GET
    @Produces(value={"text/html"})
    public String get() throws Exception {
        return AHTML.simplePage((String)"ATS CPA Resource");
    }

    @GET
    @Path(value="program")
    @Produces(value={"application/json"})
    public List<CpaProgram> getPrograms() throws Exception {
        ArrayList<CpaProgram> programs = new ArrayList<CpaProgram>();
        for (IAtsCpaService service : this.cpaRegistry.getServices()) {
            programs.addAll(service.getPrograms());
        }
        return programs;
    }

    @GET
    @Path(value="program/{uuid}")
    @Produces(value={"application/json"})
    public List<CpaDecision> getDecisionByProgram(@PathParam(value="uuid") String uuid, @QueryParam(value="open") Boolean open) throws Exception {
        return DecisionLoader.createLoader(this.cpaRegistry, this.atsServer).andOpen(open).andProgramUuid(uuid).load();
    }

    @GET
    @Path(value="program/{uuid}/build")
    @Produces(value={"application/json"})
    public List<CpaBuild> getBuildsByProgram(@PathParam(value="uuid") String programUuid) throws Exception {
        ArrayList<CpaBuild> builds = new ArrayList<CpaBuild>();
        for (IAtsCpaService service : this.cpaRegistry.getServices()) {
            builds.addAll(service.getBuilds(programUuid));
        }
        return builds;
    }

    @GET
    @Path(value="decision/{uuid}")
    @Produces(value={"application/json"})
    public Response getDecision(@PathParam(value="uuid") String uuid, @QueryParam(value="pcrSystem") String pcrSystem) throws Exception {
        URI uri = null;
        if (pcrSystem == null) {
            String actionUrl = AtsUtilCore.getActionUrl((String)uuid, (IAtsServices)this.atsServer);
            uri = UriBuilder.fromUri((String)actionUrl).build(new Object[0]);
        } else {
            IAtsCpaService service = this.cpaRegistry.getServiceById(pcrSystem);
            uri = service.getLocation(UriBuilder.fromUri((String)CpaUtil.getCpaBasePath(this.atsServer)).build(new Object[0]), uuid);
        }
        return Response.seeOther((URI)uri).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="decision")
    public List<CpaDecision> putDecision(DecisionUpdate update) throws Exception {
        new DecisionUpdater(update, this.atsServer).update();
        return DecisionLoader.createLoader(this.cpaRegistry, this.atsServer).andCpaIds(update.getUuids()).load();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="duplicate")
    public Response putDuplicate(DuplicateCpa duplicate) throws Exception {
        XResultData rd = new CpaDuplicator(duplicate, this.atsServer, this.cpaRegistry).duplicate();
        if (rd.isErrors()) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)rd.toString()).build();
        }
        CpaDecision decision = DecisionLoader.createLoader(this.cpaRegistry, this.atsServer).andCpaIds(Collections.singleton(duplicate.getCpaUuid())).load().iterator().next();
        return Response.ok().entity((Object)decision).build();
    }

    @GET
    @Path(value="config")
    @Produces(value={"application/json"})
    public CpaConfig getConfigs() throws Exception {
        CpaConfig config = new CpaConfig();
        EnumEntry[] enumEntryArray = this.orcsApi.getOrcsTypes().getAttributeTypes().getEnumType((AttributeTypeId)AtsAttributeTypes.ApplicableToProgram).values();
        int n = enumEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumEntry entry = enumEntryArray[n2];
            config.getApplicabilityOptions().add(entry.getName());
            ++n2;
        }
        for (IAtsCpaService service : this.cpaRegistry.getServices()) {
            config.getTools().add(new CpaConfigTool(service.getId()));
        }
        return config;
    }

    @GET
    @Path(value="config/tool/{id}")
    @Produces(value={"application/json"})
    public String getConfig(@PathParam(value="id") String id) throws Exception {
        for (IAtsCpaService service : this.cpaRegistry.getServices()) {
            if (!service.getId().equals(id)) continue;
            return service.getConfigJson();
        }
        throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, String.format("Unknown CPA configuration [%s]", id), new Object[0]);
    }
}

