/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.cpa;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.cpa.DuplicateCpa;
import org.eclipse.osee.ats.api.cpa.IAtsCpaService;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelper;
import org.eclipse.osee.ats.core.workflow.transition.TransitionManager;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.cpa.CpaServiceRegistry;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class CpaDuplicator {
    private final IAtsServer atsServer;
    private final DuplicateCpa duplicate;
    private final CpaServiceRegistry cpaRegistry;

    public CpaDuplicator(DuplicateCpa duplicate, IAtsServer atsServer, CpaServiceRegistry cpaRegistry) {
        this.duplicate = duplicate;
        this.atsServer = atsServer;
        this.cpaRegistry = cpaRegistry;
    }

    public XResultData duplicate() {
        XResultData rd = new XResultData(false);
        ArtifactReadable cpaArt = (ArtifactReadable)this.atsServer.getArtifactById(this.duplicate.getCpaUuid());
        String atsId = (String)cpaArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.AtsId, null);
        String duplicatePcrId = "";
        if (!Strings.isValid((String)atsId)) {
            rd.errorf("AtsId %s is not valid.  Skipping.", new Object[]{atsId});
        } else if (((Boolean)cpaArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.ApplicabilityWorkflow, (Object)false)).booleanValue()) {
            String toolId = (String)cpaArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.PcrToolId);
            IAtsCpaService cpaService = this.cpaRegistry.getServiceById(toolId);
            if (cpaService == null) {
                rd.errorf("CPA Tool not configured for Tool Id [%s].  Skipping.", new Object[]{cpaService});
            } else {
                IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("Duplicate for CPA " + this.duplicate.getCpaUuid(), AtsCoreUsers.SYSTEM_USER);
                IAtsTeamWorkflow cpaWf = this.atsServer.getWorkItemFactory().getTeamWf((ArtifactId)cpaArt);
                duplicatePcrId = (String)cpaArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.DuplicatedPcrId, null);
                if (Strings.isValid((String)duplicatePcrId)) {
                    rd.errorf("CPA already has duplicate pcr id set as [%s].  Skipping.", new Object[]{duplicatePcrId});
                } else {
                    String originatingPcrId = (String)cpaArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OriginatingPcrId);
                    duplicatePcrId = cpaService.duplicate(cpaWf, this.duplicate.getProgramUuid(), this.duplicate.getVersionUuid(), originatingPcrId, rd);
                    if (Strings.isValid((String)duplicatePcrId)) {
                        changes.setSoleAttributeValue((IAtsWorkItem)cpaWf, (AttributeTypeId)AtsAttributeTypes.DuplicatedPcrId, duplicatePcrId);
                        changes.setSoleAttributeValue((IAtsWorkItem)cpaWf, (AttributeTypeId)AtsAttributeTypes.ApplicableToProgram, "Yes");
                    }
                    if (this.duplicate.isCompleteCpa()) {
                        TransitionHelper helper = new TransitionHelper("Complete Applicability Workflow", Arrays.asList(cpaWf), "Completed", new ArrayList(), "", changes, this.atsServer.getServices(), new TransitionOption[]{TransitionOption.OverrideAssigneeCheck});
                        IAtsUser asUser = this.atsServer.getUserService().getUserById(this.duplicate.getUserId());
                        if (asUser == null) {
                            rd.errorf("Invalid userId [%s].  Skipping.", new Object[]{asUser});
                        }
                        helper.setTransitionUser(asUser);
                        TransitionManager mgr = new TransitionManager((ITransitionHelper)helper);
                        mgr.handleAll();
                    }
                    if (!changes.isEmpty()) {
                        changes.execute();
                    }
                }
            }
        } else {
            rd.errorf("Workflow %s is not an applicability workflow.  Skipping.", new Object[]{atsId});
        }
        return rd;
    }
}

