/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.convert;

import java.util.List;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.convert.AbstractConvertGuidToUuid;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class ConvertBaselineGuidToBaselineUuid
extends AbstractConvertGuidToUuid {
    private static final AttributeTypeToken BaselineBranchGuid = AttributeTypeToken.valueOf((long)1152921504606847145L, (String)"ats.Baseline Branch Guid");

    public ConvertBaselineGuidToBaselineUuid(Log logger, JdbcClient jdbcClient, OrcsApi orcsApi, IAtsServer atsServer) {
        super(logger, jdbcClient, orcsApi, atsServer);
    }

    public void run(XResultData data, boolean reportOnly, IAtsServices services) {
        if (reportOnly) {
            data.log("REPORT ONLY - Changes not persisted\n");
        }
        if (!this.getOrcsApi().getOrcsTypes().getAttributeTypes().exists((Id)AtsAttributeTypes.BaselineBranchUuid)) {
            data.error("ats.BaselineBranchUuid is not configured for this database");
            return;
        }
        TransactionBuilder tx = this.createTransactionBuilder();
        int numChanges = 0;
        for (ArtifactReadable art : ((QueryBuilder)((QueryBuilder)this.getOrcsApi().getQueryFactory().fromBranch((BranchId)this.atsServer.getAtsBranch()).andTypeEquals(new ArtifactTypeId[]{AtsArtifactTypes.Version, AtsArtifactTypes.TeamDefinition})).andExists(new AttributeTypeId[]{BaselineBranchGuid})).getResults()) {
            List attributeValues = art.getAttributeValues((AttributeTypeId)BaselineBranchGuid);
            for (String guid : attributeValues) {
                if (guid.isEmpty()) continue;
                BranchReadable branch = null;
                try {
                    branch = this.getBranch(guid);
                }
                catch (Exception exception) {}
                if (branch == null) {
                    data.errorf("Branch with guid %s can't be found", new Object[]{guid});
                    continue;
                }
                long branchUuid = branch.getUuid();
                String uuid = art.getSoleAttributeAsString((AttributeTypeId)AtsAttributeTypes.BaselineBranchUuid, null);
                if (Strings.isValid((String)uuid) && !this.isUuidDifferent(uuid, branchUuid)) continue;
                if (!Strings.isValid((String)uuid)) {
                    data.logf("Adding uuid attribute of value %d to artifact type [%s] name [%s] id [%s]\n", new Object[]{branchUuid, art.getArtifactType(), art.getName(), art.getGuid()});
                } else if (this.isUuidDifferent(uuid, branchUuid)) {
                    data.logf("Updating uuid attribute of value %d to artifact type [%s] name [%s] id [%s]\n", new Object[]{branchUuid, art.getArtifactType(), art.getName(), art.getGuid()});
                }
                ++numChanges;
                if (reportOnly) continue;
                tx.setSoleAttributeValue((ArtifactId)art, (AttributeTypeId)AtsAttributeTypes.BaselineBranchUuid, (Object)String.valueOf(branchUuid));
            }
        }
        if (!reportOnly) {
            data.log("\n" + numChanges + " Changes Persisted");
            tx.commit();
        } else {
            data.log("\n" + numChanges + " Need to be Changed");
        }
    }

    public String getDescription() {
        StringBuffer data = new StringBuffer();
        data.append("ConvertBaselineGuidToBaselineUuid (required conversion)\n\n");
        data.append("Necessary for upgrading from OSEE 0.16.2 to 0.17.0");
        data.append("- Verify that ats.BaselineBranchUuid is a valid attribute type\n");
        data.append("- Verify Add uuid attribute for every ats.BaselineBranchGuid attribute on Version artifacts\n");
        data.append("- Verify Add uuid attribute for every ats.BaselineBranchGuid attribute on Team Definition artifacts\n\n");
        data.append("NOTE: This operation can be run multiple times\n");
        data.append("Manual Cleanup (optional): Use Purge Attribute Type BLAM to remove the ats.BaselineBranchGuid attributes.");
        return data.toString();
    }

    public String getName() {
        return "ConvertBaselineGuidToBaselineUuid";
    }

    private boolean isUuidDifferent(String uuid, long branchUuid) {
        return Strings.isValid((String)uuid) && !Long.valueOf(uuid).equals(branchUuid);
    }
}

