/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.config.AtsAttributeValueColumn;
import org.eclipse.osee.ats.api.config.AtsViews;
import org.eclipse.osee.ats.api.config.IAtsConfigurationViewsProvider;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.ColorColumns;
import org.eclipse.osee.ats.core.column.ColorTeamColumn;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.config.AtsConfigurationViewsService;
import org.eclipse.osee.ats.rest.internal.util.RestUtil;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class UpdateAtsConfiguration {
    private final Gson gson;
    private final IAtsServer atsServer;
    private static final String VIEWS_KEY = "views";
    private static final String VIEWS_EQUAL_KEY = "views=";
    private static final String COLOR_COLUMN_KEY = "colorColumns";
    public static final String VALID_STATE_NAMES_KEY = "validStateNames";

    public UpdateAtsConfiguration(IAtsServer atsServer) {
        this.atsServer = atsServer;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public XResultData createUpdateConfig(XResultData rd) {
        ArtifactReadable userArt = this.atsServer.getArtifact((IAtsObject)AtsCoreUsers.SYSTEM_USER);
        ArtifactId configFolder = this.getOrCreateConfigFolder((ArtifactId)userArt, rd);
        ArtifactReadable atsConfigArt = (ArtifactReadable)this.getOrCreateAtsConfig(userArt, rd);
        this.createRuleDefinitions(userArt, configFolder, rd);
        this.createUpdateColorColumnAttributes(atsConfigArt, userArt, rd);
        this.createUpdateConfigAttributes(atsConfigArt, userArt, rd);
        this.createUpdateValidStateAttributes(atsConfigArt, userArt, rd);
        return rd;
    }

    private void createRuleDefinitions(ArtifactReadable userArt, ArtifactId configFolderArt, XResultData rd) {
        try {
            if (this.atsServer.getArtifact((ArtifactId)AtsArtifactToken.RuleDefinitions) == null) {
                TransactionBuilder tx = this.atsServer.getOrcsApi().getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, (ArtifactId)userArt, "Add Rule Definitions Artifact");
                ArtifactToken ruleDefConfigArt = tx.createArtifact(AtsArtifactToken.RuleDefinitions);
                String ruleDefs = RestUtil.getResource("support/ruleDefinitions.ats");
                tx.createAttribute((ArtifactId)ruleDefConfigArt, (AttributeTypeId)AtsAttributeTypes.DslSheet, (Object)ruleDefs);
                if (rd.isErrors()) {
                    throw new OseeStateException(rd.toString(), new Object[0]);
                }
                tx.relate(configFolderArt, (IRelationType)CoreRelationTypes.Default_Hierarchical__Child, (ArtifactId)ruleDefConfigArt);
                tx.commit();
            }
        }
        catch (Exception ex) {
            OseeLog.log(UpdateAtsConfiguration.class, (Level)Level.SEVERE, (Throwable)ex);
            rd.error("Error loading column ruleDefinitions.ats file (see log for details) " + ex.getLocalizedMessage());
        }
    }

    private List<String> getViewsJsonStrings() throws Exception {
        LinkedList<String> viewsJson = new LinkedList<String>();
        viewsJson.add(RestUtil.getResource("support/views.json"));
        for (IAtsConfigurationViewsProvider provider : AtsConfigurationViewsService.getViewsProviders()) {
            viewsJson.add(provider.getViewsJson());
        }
        return viewsJson;
    }

    private void createUpdateConfigAttributes(ArtifactReadable configArt, ArtifactReadable userArt, XResultData rd) throws OseeCoreException {
        try {
            AtsViews databaseViews = this.getConfigViews();
            for (String viewsJson : this.getViewsJsonStrings()) {
                AtsViews atsViews = (AtsViews)this.gson.fromJson(viewsJson, AtsViews.class);
                LinkedList<AtsAttributeValueColumn> toAdd = new LinkedList<AtsAttributeValueColumn>();
                for (AtsAttributeValueColumn defaultView : atsViews.getAttrColumns()) {
                    boolean found = false;
                    for (AtsAttributeValueColumn dbView : databaseViews.getAttrColumns()) {
                        boolean defaultViewNameValid;
                        boolean bl = defaultViewNameValid = Strings.isValid((String)dbView.getName()) && Strings.isValid((String)defaultView.getName());
                        if (defaultViewNameValid && dbView.getName().equals(defaultView.getName())) {
                            found = true;
                            break;
                        }
                        if (found || !dbView.getAttrTypeName().equals(defaultView.getAttrTypeName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    toAdd.add(defaultView);
                }
                databaseViews.getAttrColumns().addAll(toAdd);
            }
            TransactionBuilder tx = this.atsServer.getOrcsApi().getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, (ArtifactId)userArt, "Create Update Config Attributes");
            Iterator iterator = configArt.getAttributes((AttributeTypeId)CoreAttributeTypes.GeneralStringData, DeletionFlag.EXCLUDE_DELETED).iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                AttributeReadable attributeReadable = (AttributeReadable)iterator.next();
                if (attributeReadable == null || !((String)attributeReadable.getValue()).startsWith(VIEWS_EQUAL_KEY)) continue;
                tx.setAttributeById((ArtifactId)configArt, (AttributeId)attributeReadable, this.getViewsAttrValue(databaseViews));
                rd.log("Create or update AtsConfig.VIEWS attribute\n");
                found = true;
                break;
            }
            if (!found) {
                tx.createAttribute((ArtifactId)configArt, (AttributeTypeId)CoreAttributeTypes.GeneralStringData, (Object)this.getViewsAttrValue(databaseViews));
                rd.log("Creating VIEWS attribute\n");
            }
            tx.commit();
        }
        catch (Exception ex) {
            OseeLog.log(UpdateAtsConfiguration.class, (Level)Level.SEVERE, (Throwable)ex);
            rd.error("Error loading column views.json file (see log for details) " + ex.getLocalizedMessage());
        }
    }

    private String getViewsAttrValue(AtsViews defaultViews) {
        return VIEWS_EQUAL_KEY + this.gson.toJson((Object)defaultViews);
    }

    public ArtifactId getOrCreateConfigFolder(ArtifactId userArt, XResultData rd) {
        ArtifactReadable configFolderArt = (ArtifactReadable)((QueryBuilder)this.atsServer.getOrcsApi().getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIds((ArtifactId)AtsArtifactToken.ConfigFolder)).getResults().getAtMostOneOrNull();
        if (configFolderArt == null) {
            TransactionBuilder tx = this.atsServer.getOrcsApi().getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, userArt, "Create Config Folder");
            ArtifactReadable headingFolderArt = (ArtifactReadable)((QueryBuilder)this.atsServer.getOrcsApi().getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIds((ArtifactId)AtsArtifactToken.HeadingFolder)).getResults().getExactlyOne();
            configFolderArt = (ArtifactReadable)tx.createArtifact(AtsArtifactToken.ConfigFolder);
            tx.relate((ArtifactId)headingFolderArt, (IRelationType)CoreRelationTypes.Default_Hierarchical__Parent, (ArtifactId)configFolderArt);
            tx.commit();
            rd.log("Created Config Folder");
        }
        return configFolderArt;
    }

    public ArtifactId getOrCreateAtsConfig(ArtifactReadable userArt, XResultData rd) {
        ArtifactReadable atsConfigArt = (ArtifactReadable)((QueryBuilder)this.atsServer.getOrcsApi().getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIds((ArtifactId)AtsArtifactToken.AtsConfig)).getResults().getAtMostOneOrNull();
        if (atsConfigArt == null) {
            TransactionBuilder tx = this.atsServer.getOrcsApi().getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, (ArtifactId)userArt, "Create AtsConfig");
            ArtifactReadable headingFolderArt = (ArtifactReadable)this.getOrCreateConfigFolder((ArtifactId)userArt, rd);
            atsConfigArt = (ArtifactReadable)tx.createArtifact(AtsArtifactToken.AtsConfig);
            tx.relate((ArtifactId)headingFolderArt, (IRelationType)CoreRelationTypes.Default_Hierarchical__Parent, (ArtifactId)atsConfigArt);
            tx.commit();
            rd.log("Created AtsConfig");
        }
        return atsConfigArt;
    }

    private void createUpdateColorColumnAttributes(ArtifactReadable atsConfigArt, ArtifactReadable userArt, XResultData rd) {
        ColorColumns columns = new ColorColumns();
        columns.addColumn(ColorTeamColumn.getColor());
        String colorColumnsJson = this.gson.toJson((Object)columns);
        this.atsServer.setConfigValue(COLOR_COLUMN_KEY, colorColumnsJson);
    }

    private void createUpdateValidStateAttributes(ArtifactReadable atsConfigArt, ArtifactReadable userArt, XResultData rd) {
        Collection validStateNames = this.atsServer.getWorkDefService().getAllValidStateNames(new XResultData());
        this.atsServer.setConfigValue(VALID_STATE_NAMES_KEY, Collections.toString((String)",", (Iterable)validStateNames));
    }

    public ArtifactId getOrCreateConfigsFolder(ArtifactId userArt, XResultData rd) {
        ArtifactId configFolderArt = this.getOrCreateConfigFolder(userArt, rd);
        ArtifactId configsFolderArt = (ArtifactId)((QueryBuilder)this.atsServer.getOrcsApi().getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIds((ArtifactId)AtsArtifactToken.ConfigsFolder)).getResults().getAtMostOneOrNull();
        if (configsFolderArt == null) {
            TransactionBuilder tx = this.atsServer.getOrcsApi().getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, userArt, "Create Configs Folder");
            configsFolderArt = tx.createArtifact(AtsArtifactToken.ConfigsFolder);
            tx.relate(configsFolderArt, (IRelationType)CoreRelationTypes.Default_Hierarchical__Parent, configFolderArt);
            tx.commit();
            rd.log("Created Configs Folder");
        }
        return configsFolderArt;
    }

    public Collection<String> getValidStateNames() {
        String stateNamesStr = this.atsServer.getConfigValue(VALID_STATE_NAMES_KEY);
        LinkedList<String> stateNames = new LinkedList<String>();
        if (Strings.isValid((String)stateNamesStr)) {
            String[] stringArray = stateNamesStr.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String stateName = stringArray[n2];
                stateNames.add(stateName);
                ++n2;
            }
        }
        return stateNames;
    }

    public AtsViews getConfigViews() {
        String viewsStr = this.atsServer.getConfigValue(VIEWS_KEY);
        AtsViews views = null;
        views = Strings.isValid((String)viewsStr) ? (AtsViews)this.gson.fromJson(viewsStr, AtsViews.class) : new AtsViews();
        return views;
    }

    public ColorColumns getColorColumns() {
        String colorStr = this.atsServer.getConfigValue(COLOR_COLUMN_KEY);
        ColorColumns columns = null;
        columns = Strings.isValid((String)colorStr) ? (ColorColumns)this.gson.fromJson(colorStr, ColorColumns.class) : new ColorColumns();
        return columns;
    }
}

